/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.container.mp4;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.RandomAccessSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.tools.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMp4SampleList
extends AbstractList<Sample> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMp4SampleList.class);
    private TrackBox trackBox = null;
    private SoftReference<ByteBuffer>[] cache = null;
    private int[] chunkNumsStartSampleNum;
    private int[] chunkNumsToSampleDescriptionIndex;
    private long[] chunkOffsets;
    private long[][] sampleOffsetsWithinChunks;
    private SampleSizeBox ssb;
    private int lastChunk = 0;
    private RandomAccessSource randomAccess;
    private ArrayList<SampleEntry> sampleEntries;

    public DefaultMp4SampleList(long track, Container topLevel, RandomAccessSource randomAccessFile) {
        this.randomAccess = randomAccessFile;
        MovieBox movieBox = (MovieBox)topLevel.getBoxes(MovieBox.class).get(0);
        List trackBoxes = movieBox.getBoxes(TrackBox.class);
        for (TrackBox tb : trackBoxes) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        this.sampleEntries = new ArrayList(this.trackBox.getSampleTableBox().getSampleDescriptionBox().getBoxes(SampleEntry.class));
        if (this.sampleEntries.size() != this.trackBox.getSampleTableBox().getSampleDescriptionBox().getBoxes().size()) {
            throw new AssertionError((Object)"stsd contains not only sample entries. Something's wrong here! Bailing out");
        }
        this.chunkOffsets = this.trackBox.getSampleTableBox().getChunkOffsetBox().getChunkOffsets();
        long[] chunkSizes = new long[this.chunkOffsets.length];
        this.cache = new SoftReference[this.chunkOffsets.length];
        Arrays.fill(this.cache, new SoftReference<Object>(null));
        this.sampleOffsetsWithinChunks = new long[this.chunkOffsets.length][];
        this.chunkNumsToSampleDescriptionIndex = new int[this.chunkOffsets.length];
        this.ssb = this.trackBox.getSampleTableBox().getSampleSizeBox();
        List s2chunkEntries = this.trackBox.getSampleTableBox().getSampleToChunkBox().getEntries();
        SampleToChunkBox.Entry[] entries = s2chunkEntries.toArray(new SampleToChunkBox.Entry[s2chunkEntries.size()]);
        int s2cIndex = 0;
        SampleToChunkBox.Entry next = entries[s2cIndex++];
        int currentChunkNo = 0;
        int currentSamplePerChunk = 0;
        int currentSampleDescriptionIndex = 0;
        long nextFirstChunk = next.getFirstChunk();
        int nextSamplePerChunk = CastUtils.l2i((long)next.getSamplesPerChunk());
        int nextSampleDescriptionIndex = CastUtils.l2i((long)next.getSampleDescriptionIndex());
        int currentSampleNo = 1;
        int lastSampleNo = this.size();
        do {
            if ((long)(++currentChunkNo) == nextFirstChunk) {
                currentSamplePerChunk = nextSamplePerChunk;
                currentSampleDescriptionIndex = nextSampleDescriptionIndex;
                if (entries.length > s2cIndex) {
                    next = entries[s2cIndex++];
                    nextSamplePerChunk = CastUtils.l2i((long)next.getSamplesPerChunk());
                    nextSampleDescriptionIndex = CastUtils.l2i((long)next.getSampleDescriptionIndex());
                    nextFirstChunk = next.getFirstChunk();
                } else {
                    nextSamplePerChunk = -1;
                    nextSampleDescriptionIndex = -1;
                    nextFirstChunk = Long.MAX_VALUE;
                }
            }
            this.sampleOffsetsWithinChunks[currentChunkNo - 1] = new long[currentSamplePerChunk];
            this.chunkNumsToSampleDescriptionIndex[currentChunkNo - 1] = currentSampleDescriptionIndex;
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum = new int[currentChunkNo + 1];
        s2cIndex = 0;
        next = entries[s2cIndex++];
        currentChunkNo = 0;
        currentSamplePerChunk = 0;
        nextFirstChunk = next.getFirstChunk();
        nextSamplePerChunk = CastUtils.l2i((long)next.getSamplesPerChunk());
        currentSampleNo = 1;
        do {
            this.chunkNumsStartSampleNum[currentChunkNo++] = currentSampleNo;
            if ((long)currentChunkNo != nextFirstChunk) continue;
            currentSamplePerChunk = nextSamplePerChunk;
            if (entries.length > s2cIndex) {
                next = entries[s2cIndex++];
                nextSamplePerChunk = CastUtils.l2i((long)next.getSamplesPerChunk());
                nextFirstChunk = next.getFirstChunk();
                continue;
            }
            nextSamplePerChunk = -1;
            nextFirstChunk = Long.MAX_VALUE;
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum[currentChunkNo] = Integer.MAX_VALUE;
        currentChunkNo = 0;
        long sampleSum = 0L;
        int i = 1;
        while ((long)i <= this.ssb.getSampleCount()) {
            while (i == this.chunkNumsStartSampleNum[currentChunkNo]) {
                ++currentChunkNo;
                sampleSum = 0L;
            }
            int n = currentChunkNo - 1;
            chunkSizes[n] = chunkSizes[n] + this.ssb.getSampleSizeAtIndex(i - 1);
            long[] sampleOffsetsWithinChunkscurrentChunkNo = this.sampleOffsetsWithinChunks[currentChunkNo - 1];
            int chunkNumsStartSampleNumcurrentChunkNo = this.chunkNumsStartSampleNum[currentChunkNo - 1];
            sampleOffsetsWithinChunkscurrentChunkNo[i - chunkNumsStartSampleNumcurrentChunkNo] = sampleSum;
            sampleSum += this.ssb.getSampleSizeAtIndex(i - 1);
            ++i;
        }
    }

    private synchronized int getChunkForSample(int index) {
        int sampleNum = index + 1;
        if (sampleNum >= this.chunkNumsStartSampleNum[this.lastChunk] && sampleNum < this.chunkNumsStartSampleNum[this.lastChunk + 1]) {
            return this.lastChunk;
        }
        if (sampleNum < this.chunkNumsStartSampleNum[this.lastChunk]) {
            this.lastChunk = 0;
            while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
                ++this.lastChunk;
            }
            return this.lastChunk;
        }
        ++this.lastChunk;
        while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
            ++this.lastChunk;
        }
        return this.lastChunk;
    }

    @Override
    public Sample get(int index) {
        if ((long)index >= this.ssb.getSampleCount()) {
            throw new IndexOutOfBoundsException();
        }
        return new SampleImpl(index);
    }

    @Override
    public int size() {
        return CastUtils.l2i((long)this.trackBox.getSampleTableBox().getSampleSizeBox().getSampleCount());
    }

    class SampleImpl
    implements Sample {
        private int index;

        public SampleImpl(int index) {
            this.index = index;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            channel.write(this.asByteBuffer());
        }

        @Override
        public long getSize() {
            return DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index);
        }

        @Override
        public synchronized ByteBuffer asByteBuffer() {
            ByteBuffer chunkBuffer;
            int chunkNumber = DefaultMp4SampleList.this.getChunkForSample(this.index);
            SoftReference chunkBufferSr = DefaultMp4SampleList.this.cache[chunkNumber];
            int chunkStartSample = DefaultMp4SampleList.this.chunkNumsStartSampleNum[chunkNumber] - 1;
            int sampleInChunk = this.index - chunkStartSample;
            long[] sampleOffsetsWithinChunk = DefaultMp4SampleList.this.sampleOffsetsWithinChunks[CastUtils.l2i((long)chunkNumber)];
            long offsetWithInChunk = sampleOffsetsWithinChunk[sampleInChunk];
            if (chunkBufferSr == null || (chunkBuffer = (ByteBuffer)chunkBufferSr.get()) == null) {
                try {
                    chunkBuffer = DefaultMp4SampleList.this.randomAccess.get(DefaultMp4SampleList.this.chunkOffsets[CastUtils.l2i((long)chunkNumber)], sampleOffsetsWithinChunk[sampleOffsetsWithinChunk.length - 1] + DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(chunkStartSample + sampleOffsetsWithinChunk.length - 1));
                    ((DefaultMp4SampleList)DefaultMp4SampleList.this).cache[chunkNumber] = new SoftReference<ByteBuffer>(chunkBuffer);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                    throw new IndexOutOfBoundsException(e.getMessage());
                }
            }
            ByteBuffer b = chunkBuffer.duplicate().position(CastUtils.l2i((long)offsetWithInChunk)).slice().limit(CastUtils.l2i((long)DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index)));
            return b;
        }

        public String toString() {
            return "Sample(index: " + this.index + " size: " + DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index) + ")";
        }

        @Override
        public SampleEntry getSampleEntry() {
            return (SampleEntry)DefaultMp4SampleList.this.sampleEntries.get(DefaultMp4SampleList.this.chunkNumsToSampleDescriptionIndex[DefaultMp4SampleList.this.getChunkForSample(this.index)] - 1);
        }
    }
}

