/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.SampleImpl;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.tools.CastUtils;

public class SilenceTrackImpl
implements Track {
    private Track source;
    private List<Sample> samples = new LinkedList<Sample>();
    private long[] decodingTimes;
    private String name;

    public SilenceTrackImpl(Track ofType, long ms) {
        this.source = ofType;
        this.name = "" + ms + "ms silence";
        assert (ofType.getSampleEntries().size() == 1) : "";
        if ("mp4a".equals(ofType.getSampleEntries().get(0).getType())) {
            int numFrames = CastUtils.l2i((long)(this.getTrackMetaData().getTimescale() * ms / 1000L / 1024L));
            this.decodingTimes = new long[numFrames];
            Arrays.fill(this.decodingTimes, this.getTrackMetaData().getTimescale() * ms / (long)numFrames / 1000L);
            while (numFrames-- > 0) {
                this.samples.add(new SampleImpl(ByteBuffer.wrap(new byte[]{33, 16, 4, 96, -116, 28}).rewind(), ofType.getSampleEntries().get(0)));
            }
        } else {
            throw new RuntimeException("Tracks of type " + ofType.getClass().getSimpleName() + " are not supported");
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return this.source.getSampleEntries();
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public long getDuration() {
        long duration = 0L;
        for (long delta : this.decodingTimes) {
            duration += delta;
        }
        return duration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Edit> getEdits() {
        return null;
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.source.getSampleGroups();
    }
}

