/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.encryption;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.iso14496.part15.HevcConfigurationBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.tracks.encryption.CencEncryptedTrack;
import org.mp4parser.muxer.tracks.encryption.CencEncryptingSampleEntryTransformer;
import org.mp4parser.muxer.tracks.encryption.CencEncryptingSampleList;
import org.mp4parser.muxer.tracks.encryption.KeyIdKeyPair;
import org.mp4parser.muxer.tracks.h264.H264NalUnitHeader;
import org.mp4parser.muxer.tracks.h264.H264TrackImpl;
import org.mp4parser.muxer.tracks.h265.H265NalUnitHeader;
import org.mp4parser.muxer.tracks.h265.H265TrackImpl;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReaderVariable;
import org.mp4parser.tools.RangeStartMap;

public class CencEncryptingTrackImpl
implements CencEncryptedTrack {
    private Track source;
    private CencEncryptingSampleList samples;
    private List<CencSampleAuxiliaryDataFormat> cencSampleAuxiliaryData;
    private LinkedHashSet<SampleEntry> sampleEntries = new LinkedHashSet();
    private boolean subSampleEncryption;
    private Object configurationBox;
    private Map<GroupEntry, long[]> groupEntries = new HashMap<GroupEntry, long[]>();

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, SecretKey key, boolean dummyIvs) {
        this(source, (RangeStartMap<Integer, UUID>)new RangeStartMap((Comparable)Integer.valueOf(0), (Object)defaultKeyId), Collections.singletonMap(defaultKeyId, key), "cenc", dummyIvs, false);
    }

    public CencEncryptingTrackImpl(Track source, RangeStartMap<Integer, UUID> indexToKeyId, Map<UUID, SecretKey> keys, String encryptionAlgo, boolean dummyIvs, boolean encryptButAllClear) {
        this.source = source;
        this.cencSampleAuxiliaryData = new ArrayList<CencSampleAuxiliaryDataFormat>();
        BigInteger one = new BigInteger("1");
        byte[] init = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (!dummyIvs) {
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(init);
        }
        BigInteger ivInt = new BigInteger(1, init);
        CencEncryptingSampleEntryTransformer tx = new CencEncryptingSampleEntryTransformer();
        HashMap<SampleEntry, Integer> nalLengthSizes = new HashMap<SampleEntry, Integer>();
        for (SampleEntry sampleEntry : source.getSampleEntries()) {
            List boxes = sampleEntry.getBoxes();
            for (Box box : boxes) {
                if (box instanceof AvcConfigurationBox) {
                    this.configurationBox = box;
                    AvcConfigurationBox avcC = (AvcConfigurationBox)this.configurationBox;
                    nalLengthSizes.put(sampleEntry, avcC.getLengthSizeMinusOne() + 1);
                    this.subSampleEncryption = true;
                    continue;
                }
                if (box instanceof HevcConfigurationBox) {
                    this.configurationBox = box;
                    HevcConfigurationBox hvcC = (HevcConfigurationBox)this.configurationBox;
                    nalLengthSizes.put(sampleEntry, hvcC.getLengthSizeMinusOne() + 1);
                    this.subSampleEncryption = true;
                    continue;
                }
                if (nalLengthSizes.containsKey(sampleEntry)) continue;
                nalLengthSizes.put(sampleEntry, -1);
            }
        }
        List<Sample> sourceSamples = source.getSamples();
        RangeStartMap indexToSampleEntry = new RangeStartMap();
        RangeStartMap indexToKey = new RangeStartMap();
        SampleEntry previousSampleEntry = null;
        for (int i = 0; i < sourceSamples.size(); ++i) {
            SampleEntry correct;
            Sample origSample = sourceSamples.get(i);
            int nalLengthSize = (Integer)nalLengthSizes.get(origSample.getSampleEntry());
            CencSampleAuxiliaryDataFormat e = new CencSampleAuxiliaryDataFormat();
            this.cencSampleAuxiliaryData.add(e);
            UUID keyId = (UUID)indexToKeyId.get((Object)i);
            if (keyId != null) {
                correct = tx.transform(origSample.getSampleEntry(), encryptionAlgo, (UUID)indexToKeyId.get((Object)i));
                this.sampleEntries.add(correct);
                if (previousSampleEntry != correct) {
                    indexToSampleEntry.put((Comparable)Integer.valueOf(i), (Object)correct);
                    indexToKey.put((Comparable)Integer.valueOf(i), (Object)new KeyIdKeyPair(keyId, keys.get(indexToKeyId.get((Object)i))));
                }
                previousSampleEntry = correct;
                byte[] iv = ivInt.toByteArray();
                byte[] eightByteIv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                System.arraycopy(iv, iv.length - 8 > 0 ? iv.length - 8 : 0, eightByteIv, 8 - iv.length < 0 ? 0 : 8 - iv.length, iv.length > 8 ? 8 : iv.length);
                e.iv = eightByteIv;
                ByteBuffer sample = origSample.asByteBuffer().rewind();
                if (nalLengthSize > 0) {
                    if (encryptButAllClear) {
                        e.pairs = new CencSampleAuxiliaryDataFormat.Pair[]{e.createPair(sample.remaining(), 0L)};
                    } else {
                        ArrayList<CencSampleAuxiliaryDataFormat.Pair> pairs = new ArrayList<CencSampleAuxiliaryDataFormat.Pair>(5);
                        while (sample.remaining() > 0) {
                            int nalLength = CastUtils.l2i((long)IsoTypeReaderVariable.read((ByteBuffer)sample, (int)nalLengthSize));
                            int nalGrossSize = nalLength + nalLengthSize;
                            int clearBytes = nalGrossSize < 112 || this.isClearNal(sample.duplicate()) ? nalGrossSize : 96 + nalGrossSize % 16;
                            pairs.add(e.createPair(clearBytes, (long)(nalGrossSize - clearBytes)));
                            sample.position(sample.position() + nalLength);
                        }
                        e.pairs = pairs.toArray(new CencSampleAuxiliaryDataFormat.Pair[pairs.size()]);
                    }
                }
                ivInt = ivInt.add(one);
                continue;
            }
            correct = origSample.getSampleEntry();
            this.sampleEntries.add(correct);
            if (previousSampleEntry != correct) {
                indexToSampleEntry.put((Comparable)Integer.valueOf(i), (Object)correct);
                indexToKey.put((Comparable)Integer.valueOf(i), null);
            }
            previousSampleEntry = correct;
        }
        this.samples = new CencEncryptingSampleList((RangeStartMap<Integer, KeyIdKeyPair>)indexToKey, (RangeStartMap<Integer, SampleEntry>)indexToSampleEntry, source.getSamples(), this.cencSampleAuxiliaryData);
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return this.subSampleEncryption;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.cencSampleAuxiliaryData;
    }

    @Override
    public synchronized List<SampleEntry> getSampleEntries() {
        return new ArrayList<SampleEntry>(this.sampleEntries);
    }

    @Override
    public long[] getSampleDurations() {
        return this.source.getSampleDurations();
    }

    @Override
    public long getDuration() {
        return this.source.getDuration();
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.source.getCompositionTimeEntries();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public String getName() {
        return "enc(" + this.source.getName() + ")";
    }

    @Override
    public List<Edit> getEdits() {
        return this.source.getEdits();
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.groupEntries;
    }

    private boolean isClearNal(ByteBuffer s) {
        if (this.configurationBox instanceof HevcConfigurationBox) {
            H265NalUnitHeader nuh = H265TrackImpl.getNalUnitHeader(s.slice());
            return !(nuh.nalUnitType >= 0 && nuh.nalUnitType <= 9 || nuh.nalUnitType >= 16 && nuh.nalUnitType <= 21 || nuh.nalUnitType >= 16 && nuh.nalUnitType <= 21);
        }
        if (this.configurationBox instanceof AvcConfigurationBox) {
            H264NalUnitHeader nuh = H264TrackImpl.getNalUnitHeader(s.slice());
            return nuh.nal_unit_type != 19 && nuh.nal_unit_type != 2 && nuh.nal_unit_type != 3 && nuh.nal_unit_type != 4 && nuh.nal_unit_type != 20 && nuh.nal_unit_type != 5 && nuh.nal_unit_type != 1;
        }
        throw new RuntimeException("Subsample encryption is activated but the CencEncryptingTrackImpl can't say if this sample is to be encrypted or not!");
    }
}

