/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.webvtt;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part30.WebVTTConfigurationBox;
import org.mp4parser.boxes.iso14496.part30.WebVTTSampleEntry;
import org.mp4parser.boxes.iso14496.part30.WebVTTSourceLabelBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CuePayloadBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CueSettingsBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.VTTCueBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.VTTEmptyCueBox;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Mp4Arrays;

public class WebVttTrack
extends AbstractTrack {
    private static final String WEBVTT_FILE_HEADER_STRING = "^\ufeff?WEBVTT((\\u0020|\t).*)?$";
    private static final Pattern WEBVTT_FILE_HEADER = Pattern.compile("^\ufeff?WEBVTT((\\u0020|\t).*)?$");
    private static final String WEBVTT_METADATA_HEADER_STRING = "\\S*[:=]\\S*";
    private static final Pattern WEBVTT_METADATA_HEADER = Pattern.compile("\\S*[:=]\\S*");
    private static final String WEBVTT_CUE_IDENTIFIER_STRING = "^(?!.*(-->)).*$";
    private static final Pattern WEBVTT_CUE_IDENTIFIER = Pattern.compile("^(?!.*(-->)).*$");
    private static final String WEBVTT_TIMESTAMP_STRING = "(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}";
    private static final Pattern WEBVTT_TIMESTAMP = Pattern.compile("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}");
    private static final String WEBVTT_CUE_SETTING_STRING = "\\S*:\\S*";
    private static final Pattern WEBVTT_CUE_SETTING = Pattern.compile("\\S*:\\S*");
    private final Sample EMPTY_SAMPLE = new Sample(){
        ByteBuffer vtte;
        {
            VTTEmptyCueBox vttEmptyCueBox = new VTTEmptyCueBox();
            this.vtte = ByteBuffer.allocate(CastUtils.l2i((long)vttEmptyCueBox.getSize()));
            try {
                vttEmptyCueBox.getBox((WritableByteChannel)new ByteBufferByteChannel(this.vtte));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.vtte.rewind();
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            channel.write(this.vtte.duplicate());
        }

        @Override
        public long getSize() {
            return this.vtte.remaining();
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return this.vtte.duplicate();
        }

        @Override
        public SampleEntry getSampleEntry() {
            return WebVttTrack.this.sampleEntry;
        }
    };
    TrackMetaData trackMetaData = new TrackMetaData();
    List<Sample> samples = new ArrayList<Sample>();
    long[] sampleDurations = new long[0];
    WebVTTSampleEntry sampleEntry;

    public WebVttTrack(InputStream is, String trackName, Locale locale) throws IOException {
        super(trackName);
        Matcher matcher;
        this.trackMetaData.setTimescale(1000L);
        this.trackMetaData.setLanguage(locale.getISO3Language());
        long mediaTimestampUs = 0L;
        this.sampleEntry = new WebVTTSampleEntry();
        WebVTTConfigurationBox webVttConf = new WebVTTConfigurationBox();
        this.sampleEntry.addBox((Box)webVttConf);
        this.sampleEntry.addBox((Box)new WebVTTSourceLabelBox());
        BufferedReader webvttData = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = webvttData.readLine();
        if (line == null || !WEBVTT_FILE_HEADER.matcher(line).matches()) {
            throw new IOException("Expected WEBVTT. Got " + line);
        }
        webVttConf.setConfig(webVttConf.getConfig() + "\n" + line);
        while (true) {
            if ((line = webvttData.readLine()) == null) {
                throw new IOException("Expected an empty line after webvtt header");
            }
            if (line.isEmpty()) break;
            matcher = WEBVTT_METADATA_HEADER.matcher(line);
            if (!matcher.find()) {
                throw new IOException("Expected WebVTT metadata header. Got " + line);
            }
            webVttConf.setConfig(webVttConf.getConfig() + "\n" + line);
        }
        while ((line = webvttData.readLine()) != null) {
            if ("".equals(line.trim())) continue;
            matcher = WEBVTT_CUE_IDENTIFIER.matcher(line);
            if (matcher.find()) {
                line = webvttData.readLine();
            }
            if (!(matcher = WEBVTT_TIMESTAMP.matcher(line)).find()) {
                throw new IOException("Expected cue start time: " + line);
            }
            long startTime = WebVttTrack.parseTimestampUs(matcher.group());
            if (!matcher.find()) {
                throw new IOException("Expected cue end time: " + line);
            }
            String endTimeString = matcher.group();
            long endTime = WebVttTrack.parseTimestampUs(endTimeString);
            line = line.substring(line.indexOf(endTimeString) + endTimeString.length());
            matcher = WEBVTT_CUE_SETTING.matcher(line);
            String settings = null;
            while (matcher.find()) {
                settings = matcher.group();
            }
            StringBuilder payload = new StringBuilder();
            while ((line = webvttData.readLine()) != null && !line.isEmpty()) {
                if (payload.length() > 0) {
                    payload.append("\n");
                }
                payload.append(line.trim());
            }
            if (startTime != mediaTimestampUs) {
                this.sampleDurations = Mp4Arrays.copyOfAndAppend((long[])this.sampleDurations, (long[])new long[]{startTime - mediaTimestampUs});
                this.samples.add(this.EMPTY_SAMPLE);
            }
            this.sampleDurations = Mp4Arrays.copyOfAndAppend((long[])this.sampleDurations, (long[])new long[]{endTime - startTime});
            VTTCueBox vttCueBox = new VTTCueBox();
            if (settings != null) {
                CueSettingsBox csb = new CueSettingsBox();
                csb.setContent(settings);
                vttCueBox.setCueSettingsBox(csb);
            }
            CuePayloadBox cuePayloadBox = new CuePayloadBox();
            cuePayloadBox.setContent(payload.toString());
            vttCueBox.setCuePayloadBox(cuePayloadBox);
            this.samples.add(new BoxBearingSample(Collections.singletonList(vttCueBox)));
            mediaTimestampUs = endTime;
        }
    }

    private static long parseTimestampUs(String s) throws NumberFormatException {
        if (!s.matches(WEBVTT_TIMESTAMP_STRING)) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value = 0L;
        for (String group : parts[0].split(":")) {
            value = value * 60L + Long.parseLong(group);
        }
        return value * 1000L + Long.parseLong(parts[1]);
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.sampleEntry);
    }

    @Override
    public long[] getSampleDurations() {
        long[] adoptedSampleDuration = new long[this.sampleDurations.length];
        for (int i = 0; i < adoptedSampleDuration.length; ++i) {
            adoptedSampleDuration[i] = this.sampleDurations[i] * this.trackMetaData.getTimescale() / 1000L;
        }
        return adoptedSampleDuration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "text";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public void close() throws IOException {
    }

    private class BoxBearingSample
    implements Sample {
        List<Box> boxes;

        public BoxBearingSample(List<Box> boxes) {
            this.boxes = boxes;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            for (Box box : this.boxes) {
                box.getBox(channel);
            }
        }

        @Override
        public long getSize() {
            long l = 0L;
            for (Box box : this.boxes) {
                l += box.getSize();
            }
            return l;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.writeTo(Channels.newChannel(baos));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ByteBuffer.wrap(baos.toByteArray());
        }

        @Override
        public SampleEntry getSampleEntry() {
            return WebVttTrack.this.sampleEntry;
        }
    }
}

