/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.dolby.DTSSpecificBox;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;

public class DTSTrackImpl
extends AbstractTrack {
    private static final int BUFFER = 0x4000000;
    TrackMetaData trackMetaData = new TrackMetaData();
    AudioSampleEntry audioSampleEntry;
    int samplerate;
    int bitrate;
    int frameSize = 0;
    int sampleSize;
    int samplesPerFrame;
    int channelCount;
    DTSSpecificBox ddts = new DTSSpecificBox();
    boolean isVBR = false;
    boolean coreSubStreamPresent = false;
    boolean extensionSubStreamPresent = false;
    int numExtSubStreams = 0;
    int coreMaxSampleRate = 0;
    int coreBitRate = 0;
    int coreChannelMask = 0;
    int coreFramePayloadInBytes = 0;
    int extAvgBitrate = 0;
    int extPeakBitrate = 0;
    int extSmoothBuffSize = 0;
    int extFramePayloadInBytes = 0;
    int maxSampleRate = 0;
    int lbrCodingPresent = 0;
    int numFramesTotal = 0;
    int samplesPerFrameAtMaxFs = 0;
    int numSamplesOrigAudioAtMaxFs = 0;
    int channelMask = 0;
    int codecDelayAtMaxFs = 0;
    int bcCoreMaxSampleRate = 0;
    int bcCoreBitRate = 0;
    int bcCoreChannelMask = 0;
    int lsbTrimPercent = 0;
    String type = "none";
    private long[] sampleDurations;
    private int dataOffset = 0;
    private DataSource dataSource;
    private List<Sample> samples;
    private String lang = "eng";

    public DTSTrackImpl(DataSource dataSource, String lang) throws IOException {
        super(dataSource.toString());
        this.lang = lang;
        this.dataSource = dataSource;
        this.parse();
    }

    public DTSTrackImpl(DataSource dataSource) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.parse();
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    private void parse() throws IOException {
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.audioSampleEntry = new AudioSampleEntry(this.type);
        this.audioSampleEntry.setChannelCount(this.channelCount);
        this.audioSampleEntry.setSampleRate((long)this.samplerate);
        this.audioSampleEntry.setDataReferenceIndex(1);
        this.audioSampleEntry.setSampleSize(16);
        this.audioSampleEntry.addBox((Box)this.ddts);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.samplerate);
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.audioSampleEntry);
    }

    @Override
    public long[] getSampleDurations() {
        return this.sampleDurations;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    private void parseDtshdhdr(int size, ByteBuffer bb) {
        int hdrVersion = bb.getInt();
        byte timeCodeHigh = bb.get();
        int timeCode = bb.getInt();
        byte timeCodeFrameRate = bb.get();
        short bitwStreamMetadata = bb.getShort();
        byte numAudioPresentations = bb.get();
        this.numExtSubStreams = bb.get();
        if ((bitwStreamMetadata & 1) == 1) {
            this.isVBR = true;
        }
        if ((bitwStreamMetadata & 8) == 8) {
            this.coreSubStreamPresent = true;
        }
        if ((bitwStreamMetadata & 0x10) == 16) {
            this.extensionSubStreamPresent = true;
            ++this.numExtSubStreams;
        } else {
            this.numExtSubStreams = 0;
        }
        for (int i = 14; i < size; ++i) {
            bb.get();
        }
    }

    private boolean parseCoressmd(int size, ByteBuffer bb) {
        byte cmsr_1 = bb.get();
        short cmsr_2 = bb.getShort();
        this.coreMaxSampleRate = cmsr_1 << 16 | cmsr_2 & 0xFFFF;
        this.coreBitRate = bb.getShort();
        this.coreChannelMask = bb.getShort();
        this.coreFramePayloadInBytes = bb.getInt();
        for (int i = 11; i < size; ++i) {
            bb.get();
        }
        return true;
    }

    private boolean parseAuprhdr(int size, ByteBuffer bb) {
        byte audioPresIndex = bb.get();
        short bitwAupresData = bb.getShort();
        byte a = bb.get();
        int b = bb.getShort();
        this.maxSampleRate = a << 16 | b & 0xFFFF;
        this.numFramesTotal = bb.getInt();
        this.samplesPerFrameAtMaxFs = bb.getShort();
        a = bb.get();
        b = bb.getInt();
        this.numSamplesOrigAudioAtMaxFs = a << 32 | b & 0xFFFF;
        this.channelMask = bb.getShort();
        this.codecDelayAtMaxFs = bb.getShort();
        int c = 21;
        if ((bitwAupresData & 3) == 3) {
            a = bb.get();
            b = bb.getShort();
            this.bcCoreMaxSampleRate = a << 16 | b & 0xFFFF;
            this.bcCoreBitRate = bb.getShort();
            this.bcCoreChannelMask = bb.getShort();
            c += 7;
        }
        if ((bitwAupresData & 4) > 0) {
            this.lsbTrimPercent = bb.get();
            ++c;
        }
        if ((bitwAupresData & 8) > 0) {
            this.lbrCodingPresent = 1;
        }
        while (c < size) {
            bb.get();
            ++c;
        }
        return true;
    }

    private boolean parseExtssmd(int size, ByteBuffer bb) {
        byte a = bb.get();
        short b = bb.getShort();
        this.extAvgBitrate = a << 16 | b & 0xFFFF;
        int i = 3;
        if (this.isVBR) {
            a = bb.get();
            b = bb.getShort();
            this.extPeakBitrate = a << 16 | b & 0xFFFF;
            this.extSmoothBuffSize = bb.getShort();
            i += 5;
        } else {
            this.extFramePayloadInBytes = bb.getInt();
            i += 4;
        }
        while (i < size) {
            bb.get();
            ++i;
        }
        return true;
    }

    private boolean readVariables() throws IOException {
        ByteBuffer bb = this.dataSource.map(0L, 25000L);
        int testHeader1 = bb.getInt();
        int testHeader2 = bb.getInt();
        if (testHeader1 != 1146377032 || testHeader2 != 1145586770) {
            throw new IOException("data does not start with 'DTSHDHDR' as required for a DTS-HD file");
        }
        while ((testHeader1 != 1398035021 || testHeader2 != 0x44415441) && bb.remaining() > 100) {
            int size = (int)bb.getLong();
            if (testHeader1 == 1146377032 && testHeader2 == 1145586770) {
                this.parseDtshdhdr(size, bb);
            } else if (testHeader1 == 1129271877 && testHeader2 == 1397968196) {
                if (!this.parseCoressmd(size, bb)) {
                    return false;
                }
            } else if (testHeader1 == 1096110162 && testHeader2 == 759710802) {
                if (!this.parseAuprhdr(size, bb)) {
                    return false;
                }
            } else if (testHeader1 == 1163416659 && testHeader2 == 1398754628) {
                if (!this.parseExtssmd(size, bb)) {
                    return false;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    byte by = bb.get();
                }
            }
            testHeader1 = bb.getInt();
            testHeader2 = bb.getInt();
        }
        long dataSize = bb.getLong();
        this.dataOffset = bb.position();
        int amode = -1;
        int extAudioId = 0;
        int extAudio = 0;
        int corePresent = -1;
        int extPresent = -1;
        boolean extXch = false;
        boolean extXXch = false;
        boolean extX96k = false;
        boolean extXbr = false;
        boolean extLbr = false;
        boolean extXll = false;
        boolean extCore = false;
        boolean done = false;
        while (!done) {
            BitReaderBuffer brb;
            int offset = bb.position();
            int sync = bb.getInt();
            if (sync == 2147385345) {
                if (corePresent == 1) {
                    done = true;
                    continue;
                }
                corePresent = 1;
                brb = new BitReaderBuffer(bb);
                int ftype = brb.readBits(1);
                int shrt = brb.readBits(5);
                int cpf = brb.readBits(1);
                if (ftype != 1 || shrt != 31 || cpf != 0) {
                    return false;
                }
                int nblks = brb.readBits(7);
                this.samplesPerFrame = 32 * (nblks + 1);
                int fsize = brb.readBits(14);
                this.frameSize += fsize + 1;
                amode = brb.readBits(6);
                int sfreq = brb.readBits(4);
                this.samplerate = DTSTrackImpl.getSampleRate(sfreq);
                int rate = brb.readBits(5);
                this.bitrate = DTSTrackImpl.getBitRate(rate);
                int fixedBit = brb.readBits(1);
                if (fixedBit != 0) {
                    return false;
                }
                int dynf = brb.readBits(1);
                int timef = brb.readBits(1);
                int auxf = brb.readBits(1);
                int hdcd = brb.readBits(1);
                extAudioId = brb.readBits(3);
                extAudio = brb.readBits(1);
                int aspf = brb.readBits(1);
                int lff = brb.readBits(2);
                int hflag = brb.readBits(1);
                int hcrc = 0;
                if (cpf == 1) {
                    hcrc = brb.readBits(16);
                }
                int filts = brb.readBits(1);
                int vernum = brb.readBits(4);
                int chist = brb.readBits(2);
                int pcmr = brb.readBits(3);
                switch (pcmr) {
                    case 0: 
                    case 1: {
                        this.sampleSize = 16;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.sampleSize = 20;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.sampleSize = 24;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                int sumf = brb.readBits(1);
                int sums = brb.readBits(1);
                int dialnorm = 0;
                int dng = 0;
                switch (vernum) {
                    case 6: {
                        dialnorm = brb.readBits(4);
                        dng = -(16 + dialnorm);
                        break;
                    }
                    case 7: {
                        dialnorm = brb.readBits(4);
                        dng = -dialnorm;
                        break;
                    }
                    default: {
                        brb.readBits(4);
                    }
                }
                bb.position(offset + fsize + 1);
                continue;
            }
            if (sync == 1683496997) {
                if (corePresent == -1) {
                    corePresent = 0;
                    this.samplesPerFrame = this.samplesPerFrameAtMaxFs;
                }
                extPresent = 1;
                brb = new BitReaderBuffer(bb);
                int userDefinedBits = brb.readBits(8);
                int nExtSSIndex = brb.readBits(2);
                int headerSizeType = brb.readBits(1);
                int nuBits4Header = 12;
                int nuBits4ExSSFsize = 20;
                if (headerSizeType == 0) {
                    nuBits4Header = 8;
                    nuBits4ExSSFsize = 16;
                }
                int nuExtSSHeaderSize = brb.readBits(nuBits4Header) + 1;
                int nuExtSSFsize = brb.readBits(nuBits4ExSSFsize) + 1;
                bb.position(offset + nuExtSSHeaderSize);
                int extSync = bb.getInt();
                if (extSync == 0x5A5A5A5A) {
                    if (extXch) {
                        done = true;
                    }
                    extXch = true;
                } else if (extSync == 1191201283) {
                    if (extXXch) {
                        done = true;
                    }
                    extXXch = true;
                } else if (extSync == 496366178) {
                    if (extX96k) {
                        done = true;
                    }
                    extX96k = true;
                } else if (extSync == 1700671838) {
                    if (extXbr) {
                        done = true;
                    }
                    extXbr = true;
                } else if (extSync == 176167201) {
                    if (extLbr) {
                        done = true;
                    }
                    extLbr = true;
                } else if (extSync == 1101174087) {
                    if (extXll) {
                        done = true;
                    }
                    extXll = true;
                } else if (extSync == 45126241) {
                    if (extCore) {
                        done = true;
                    }
                    extCore = true;
                }
                if (!done) {
                    this.frameSize += nuExtSSFsize;
                }
                bb.position(offset + nuExtSSFsize);
                continue;
            }
            throw new IOException("No DTS_SYNCWORD_* found at " + bb.position());
        }
        int fd = -1;
        switch (this.samplesPerFrame) {
            case 512: {
                fd = 0;
                break;
            }
            case 1024: {
                fd = 1;
                break;
            }
            case 2048: {
                fd = 2;
                break;
            }
            case 4096: {
                fd = 3;
            }
        }
        if (fd == -1) {
            return false;
        }
        int coreLayout = 31;
        switch (amode) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                coreLayout = amode;
            }
        }
        int streamContruction = 0;
        if (corePresent == 0) {
            if (extXll) {
                if (!extCore) {
                    streamContruction = 17;
                    this.type = "dtsl";
                } else {
                    streamContruction = 21;
                    this.type = "dtsh";
                }
            } else if (extLbr) {
                streamContruction = 18;
                this.type = "dtse";
            } else if (extCore) {
                this.type = "dtsh";
                if (!extXXch && !extXll) {
                    streamContruction = 19;
                } else if (extXXch && !extXll) {
                    streamContruction = 20;
                } else if (!extXXch && extXll) {
                    streamContruction = 21;
                }
            }
            this.samplerate = this.maxSampleRate;
            this.sampleSize = 24;
        } else if (extPresent < 1) {
            if (extAudio > 0) {
                switch (extAudioId) {
                    case 0: {
                        streamContruction = 2;
                        this.type = "dtsc";
                        break;
                    }
                    case 2: {
                        streamContruction = 4;
                        this.type = "dtsc";
                        break;
                    }
                    case 6: {
                        streamContruction = 3;
                        this.type = "dtsh";
                        break;
                    }
                    default: {
                        streamContruction = 0;
                        this.type = "dtsh";
                        break;
                    }
                }
            } else {
                streamContruction = 1;
                this.type = "dtsc";
            }
        } else {
            this.type = "dtsh";
            if (extAudio == 0) {
                if (!(extCore || !extXXch || extX96k || extXbr || extXll || extLbr)) {
                    streamContruction = 5;
                } else if (!(extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                    streamContruction = 6;
                } else if (!extCore && extXXch && !extX96k && extXbr && !extXll && !extLbr) {
                    streamContruction = 9;
                } else if (!(extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                    streamContruction = 10;
                } else if (!extCore && extXXch && extX96k && !extXbr && !extXll && !extLbr) {
                    streamContruction = 13;
                } else if (!(extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                    streamContruction = 14;
                }
            } else if (!(extAudioId != 0 || extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                streamContruction = 7;
            } else if (!(extAudioId != 6 || extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                streamContruction = 8;
            } else if (!(extAudioId != 0 || extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                streamContruction = 11;
            } else if (!(extAudioId != 6 || extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                streamContruction = 12;
            } else if (!(extAudioId != 0 || extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                streamContruction = 15;
            } else if (!(extAudioId != 2 || extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                streamContruction = 16;
            }
        }
        this.ddts.setDTSSamplingFrequency((long)this.maxSampleRate);
        if (this.isVBR) {
            this.ddts.setMaxBitRate((long)(1000 * (this.coreBitRate + this.extPeakBitrate)));
        } else {
            this.ddts.setMaxBitRate((long)(1000 * (this.coreBitRate + this.extAvgBitrate)));
        }
        this.ddts.setAvgBitRate((long)(1000 * (this.coreBitRate + this.extAvgBitrate)));
        this.ddts.setPcmSampleDepth(this.sampleSize);
        this.ddts.setFrameDuration(fd);
        this.ddts.setStreamConstruction(streamContruction);
        if ((this.coreChannelMask & 8) > 0 || (this.coreChannelMask & 0x1000) > 0) {
            this.ddts.setCoreLFEPresent(1);
        } else {
            this.ddts.setCoreLFEPresent(0);
        }
        this.ddts.setCoreLayout(coreLayout);
        this.ddts.setCoreSize(this.coreFramePayloadInBytes);
        this.ddts.setStereoDownmix(0);
        this.ddts.setRepresentationType(4);
        this.ddts.setChannelLayout(this.channelMask);
        if (this.coreMaxSampleRate > 0 && this.extAvgBitrate > 0) {
            this.ddts.setMultiAssetFlag(1);
        } else {
            this.ddts.setMultiAssetFlag(0);
        }
        this.ddts.setLBRDurationMod(this.lbrCodingPresent);
        this.ddts.setReservedBoxPresent(0);
        this.channelCount = 0;
        block29: for (int bit = 0; bit < 16; ++bit) {
            if ((this.channelMask >> bit & 1) != 1) continue;
            switch (bit) {
                case 0: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 12: 
                case 14: {
                    ++this.channelCount;
                    continue block29;
                }
                default: {
                    this.channelCount += 2;
                }
            }
        }
        this.samples = this.generateSamples(this.dataSource, this.dataOffset, dataSize, corePresent);
        this.sampleDurations = new long[this.samples.size()];
        Arrays.fill(this.sampleDurations, (long)this.samplesPerFrame);
        return true;
    }

    private List<Sample> generateSamples(DataSource dataSource, int dataOffset, long dataSize, int corePresent) throws IOException {
        ByteBuffer sample;
        LookAhead la = new LookAhead(dataSource, dataOffset, dataSize, corePresent);
        ArrayList<Sample> mySamples = new ArrayList<Sample>();
        while ((sample = la.findNextStart()) != null) {
            final ByteBuffer finalSample = sample;
            mySamples.add(new Sample(){

                @Override
                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write(finalSample.rewind());
                }

                @Override
                public long getSize() {
                    return finalSample.rewind().remaining();
                }

                @Override
                public ByteBuffer asByteBuffer() {
                    return finalSample;
                }

                @Override
                public SampleEntry getSampleEntry() {
                    return DTSTrackImpl.this.audioSampleEntry;
                }
            });
        }
        System.err.println("all samples found");
        return mySamples;
    }

    private static int getBitRate(int rate) throws IOException {
        int bitrate;
        switch (rate) {
            case 0: {
                bitrate = 32;
                break;
            }
            case 1: {
                bitrate = 56;
                break;
            }
            case 2: {
                bitrate = 64;
                break;
            }
            case 3: {
                bitrate = 96;
                break;
            }
            case 4: {
                bitrate = 112;
                break;
            }
            case 5: {
                bitrate = 128;
                break;
            }
            case 6: {
                bitrate = 192;
                break;
            }
            case 7: {
                bitrate = 224;
                break;
            }
            case 8: {
                bitrate = 256;
                break;
            }
            case 9: {
                bitrate = 320;
                break;
            }
            case 10: {
                bitrate = 384;
                break;
            }
            case 11: {
                bitrate = 448;
                break;
            }
            case 12: {
                bitrate = 512;
                break;
            }
            case 13: {
                bitrate = 576;
                break;
            }
            case 14: {
                bitrate = 640;
                break;
            }
            case 15: {
                bitrate = 768;
                break;
            }
            case 16: {
                bitrate = 960;
                break;
            }
            case 17: {
                bitrate = 1024;
                break;
            }
            case 18: {
                bitrate = 1152;
                break;
            }
            case 19: {
                bitrate = 1280;
                break;
            }
            case 20: {
                bitrate = 1344;
                break;
            }
            case 21: {
                bitrate = 1408;
                break;
            }
            case 22: {
                bitrate = 1411;
                break;
            }
            case 23: {
                bitrate = 1472;
                break;
            }
            case 24: {
                bitrate = 1536;
                break;
            }
            case 25: {
                bitrate = -1;
                break;
            }
            default: {
                throw new IOException("Unknown bitrate value");
            }
        }
        return bitrate;
    }

    private static int getSampleRate(int sfreq) throws IOException {
        int samplerate;
        switch (sfreq) {
            case 1: {
                samplerate = 8000;
                break;
            }
            case 2: {
                samplerate = 16000;
                break;
            }
            case 3: {
                samplerate = 32000;
                break;
            }
            case 6: {
                samplerate = 11025;
                break;
            }
            case 7: {
                samplerate = 22050;
                break;
            }
            case 8: {
                samplerate = 44100;
                break;
            }
            case 11: {
                samplerate = 12000;
                break;
            }
            case 12: {
                samplerate = 24000;
                break;
            }
            case 13: {
                samplerate = 48000;
                break;
            }
            default: {
                throw new IOException("Unknown Sample Rate");
            }
        }
        return samplerate;
    }

    class LookAhead {
        private final int corePresent;
        long bufferStartPos;
        int inBufferPos = 0;
        DataSource dataSource;
        long dataEnd;
        ByteBuffer buffer;
        long start;

        LookAhead(DataSource dataSource, long bufferStartPos, long dataSize, int corePresent) throws IOException {
            this.dataSource = dataSource;
            this.bufferStartPos = bufferStartPos;
            this.dataEnd = dataSize + bufferStartPos;
            this.corePresent = corePresent;
            this.fillBuffer();
        }

        public ByteBuffer findNextStart() throws IOException {
            try {
                while (this.corePresent == 1 ? !this.nextFourEquals0x7FFE8001() : !this.nextFourEquals0x64582025()) {
                    this.discardByte();
                }
                this.discardNext4AndMarkStart();
                while (this.corePresent == 1 ? !this.nextFourEquals0x7FFE8001orEof() : !this.nextFourEquals0x64582025orEof()) {
                    this.discardQWord();
                }
                return this.getSample();
            }
            catch (EOFException e) {
                return null;
            }
        }

        private void fillBuffer() throws IOException {
            System.err.println("Fill Buffer");
            this.buffer = this.dataSource.map(this.bufferStartPos, Math.min(this.dataEnd - this.bufferStartPos, 0x4000000L));
        }

        private boolean nextFourEquals0x64582025() throws IOException {
            return this.nextFourEquals((byte)100, (byte)88, (byte)32, (byte)37);
        }

        private boolean nextFourEquals0x7FFE8001() throws IOException {
            return this.nextFourEquals((byte)127, (byte)-2, (byte)-128, (byte)1);
        }

        private boolean nextFourEquals(byte a, byte b, byte c, byte d) throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 4) {
                return this.buffer.get(this.inBufferPos) == a && this.buffer.get(this.inBufferPos + 1) == b && this.buffer.get(this.inBufferPos + 2) == c && this.buffer.get(this.inBufferPos + 3) == d;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 4L >= this.dataSource.size()) {
                throw new EOFException();
            }
            return false;
        }

        private boolean nextFourEquals0x64582025orEof() throws IOException {
            return this.nextFourEqualsOrEof((byte)100, (byte)88, (byte)32, (byte)37);
        }

        private boolean nextFourEquals0x7FFE8001orEof() throws IOException {
            return this.nextFourEqualsOrEof((byte)127, (byte)-2, (byte)-128, (byte)1);
        }

        private boolean nextFourEqualsOrEof(byte a, byte b, byte c, byte d) throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 4) {
                if ((this.bufferStartPos + (long)this.inBufferPos) % 0x100000L == 0L) {
                    System.err.println("" + (this.bufferStartPos + (long)this.inBufferPos) / 1024L / 1024L);
                }
                return this.buffer.get(this.inBufferPos) == a && this.buffer.get(this.inBufferPos + 1) == b && this.buffer.get(this.inBufferPos + 2) == c && this.buffer.get(this.inBufferPos + 3) == d;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 4L > this.dataEnd) {
                return this.bufferStartPos + (long)this.inBufferPos == this.dataEnd;
            }
            this.bufferStartPos = this.start;
            this.inBufferPos = 0;
            this.fillBuffer();
            return this.nextFourEquals0x7FFE8001();
        }

        private void discardByte() {
            ++this.inBufferPos;
        }

        private void discardQWord() {
            this.inBufferPos += 4;
        }

        private void discardNext4AndMarkStart() {
            this.start = this.bufferStartPos + (long)this.inBufferPos;
            this.inBufferPos += 4;
        }

        private ByteBuffer getSample() {
            if (this.start >= this.bufferStartPos) {
                this.buffer.position((int)(this.start - this.bufferStartPos));
                ByteBuffer sample = this.buffer.slice();
                ((Buffer)sample).limit((int)((long)this.inBufferPos - (this.start - this.bufferStartPos)));
                return sample;
            }
            throw new RuntimeException("damn! NAL exceeds buffer");
        }
    }
}

