/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264.spspps;

import java.io.IOException;
import org.mp4parser.streaming.input.h264.spspps.ByteBufferBitreader;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    public static ScalingList read(ByteBufferBitreader is, int sizeOfScalingList) throws IOException {
        ScalingList sl = new ScalingList();
        sl.scalingList = new int[sizeOfScalingList];
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            if (nextScale != 0) {
                int deltaScale = is.readSE();
                nextScale = (lastScale + deltaScale + 256) % 256;
                sl.useDefaultScalingMatrixFlag = j == 0 && nextScale == 0;
            }
            sl.scalingList[j] = nextScale == 0 ? lastScale : nextScale;
            lastScale = sl.scalingList[j];
        }
        return sl;
    }

    public String toString() {
        return "ScalingList{scalingList=" + this.scalingList + ", useDefaultScalingMatrixFlag=" + this.useDefaultScalingMatrixFlag + '}';
    }
}

