/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageData;
import org.pitest.coverage.CoverageExporter;
import org.pitest.coverage.CoverageGenerator;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.analysis.LineMapper;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.CoverageProcess;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.process.LaunchOptions;
import org.pitest.process.ProcessArgs;
import org.pitest.util.ExitCode;
import org.pitest.util.Log;
import org.pitest.util.PitError;
import org.pitest.util.SocketFinder;
import org.pitest.util.Timings;
import org.pitest.util.Unchecked;

public class DefaultCoverageGenerator
implements CoverageGenerator {
    private static final Logger LOG = Log.getLogger();
    private final CoverageOptions coverageOptions;
    private final LaunchOptions launchOptions;
    private final CodeSource code;
    private final Timings timings;
    private final File workingDir;
    private final CoverageExporter exporter;
    private final boolean showProgress;
    private final Collection<String> failingTests;

    public DefaultCoverageGenerator(File workingDir, CoverageOptions coverageOptions, LaunchOptions launchOptions, CodeSource code, CoverageExporter exporter, Timings timings, boolean showProgress, Collection<String> failingTests) {
        this.coverageOptions = coverageOptions;
        this.code = code;
        this.launchOptions = launchOptions;
        this.timings = timings;
        this.workingDir = workingDir;
        this.exporter = exporter;
        this.showProgress = showProgress;
        this.failingTests = failingTests;
    }

    @Override
    public CoverageData calculateCoverage() {
        try {
            long t0 = System.currentTimeMillis();
            this.timings.registerStart(Timings.Stage.SCAN_CLASS_PATH);
            List tests = this.code.getTests();
            this.timings.registerEnd(Timings.Stage.SCAN_CLASS_PATH);
            CoverageData coverage = new CoverageData(this.code, (LineMap)new LineMapper(this.code), this.failingTests);
            this.timings.registerStart(Timings.Stage.COVERAGE);
            this.gatherCoverageData(tests, coverage);
            this.timings.registerEnd(Timings.Stage.COVERAGE);
            long time = (System.currentTimeMillis() - t0) / 1000L;
            LOG.info("Calculated coverage in " + time + " seconds.");
            DefaultCoverageGenerator.verifyBuildSuitableForMutationTesting(coverage);
            this.exporter.recordCoverage(coverage.createCoverage());
            return coverage;
        }
        catch (PitHelpError phe) {
            throw phe;
        }
        catch (Exception e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    private static void verifyBuildSuitableForMutationTesting(CoverageData coverage) {
        if (!coverage.allTestsGreen()) {
            throw new PitHelpError(Help.FAILING_TESTS, new Object[0]);
        }
    }

    private void gatherCoverageData(Collection<ClassInfo> tests, CoverageData coverage) throws IOException, InterruptedException, ExecutionException {
        FunctionalList filteredTests = FCollection.map(tests, DefaultCoverageGenerator.classInfoToName());
        SideEffect1<CoverageResult> handler = this.resultProcessor(coverage);
        SocketFinder sf = new SocketFinder();
        ServerSocket socket = sf.getNextAvailableServerSocket();
        CoverageProcess process = new CoverageProcess(ProcessArgs.withClassPath(this.code.getClassPath()).andBaseDir(this.workingDir).andLaunchOptions(this.launchOptions).andStderr(DefaultCoverageGenerator.logInfo()).andStdout(this.captureStandardOutIfVerbose()), this.coverageOptions, socket, (List<String>)filteredTests, handler);
        process.start();
        ExitCode exitCode = process.waitToDie();
        if (exitCode == ExitCode.JUNIT_ISSUE) {
            LOG.severe("Error generating coverage. Please check that your classpath contains JUnit 4.6 or above.");
            throw new PitError("Coverage generation minion exited abnormally. Please check the classpath.");
        }
        if (!exitCode.isOk()) {
            LOG.severe("Coverage generator Minion exited abnormally due to " + exitCode);
            throw new PitError("Coverage generation minion exited abnormally!");
        }
        LOG.fine("Coverage generator Minion exited ok");
    }

    private static F<ClassInfo, String> classInfoToName() {
        return new F<ClassInfo, String>(){

            public String apply(ClassInfo a) {
                return a.getName().asInternalName();
            }
        };
    }

    private SideEffect1<String> captureStandardOutIfVerbose() {
        if (this.coverageOptions.isVerbose()) {
            return DefaultCoverageGenerator.log();
        }
        return Prelude.noSideEffect(String.class);
    }

    private static SideEffect1<String> logInfo() {
        return new SideEffect1<String>(){

            public void apply(String a) {
                LOG.info("MINION : " + a);
            }
        };
    }

    private static SideEffect1<String> log() {
        return new SideEffect1<String>(){

            public void apply(String a) {
                LOG.fine("MINION : " + a);
            }
        };
    }

    private SideEffect1<CoverageResult> resultProcessor(final CoverageData coverage) {
        return new SideEffect1<CoverageResult>(){
            private final String[] spinner = new String[]{"\b/", "\b-", "\b\\", "\b|"};
            int i = 0;

            public void apply(CoverageResult cr) {
                coverage.calculateClassCoverage(cr);
                if (DefaultCoverageGenerator.this.showProgress) {
                    System.out.printf("%s", this.spinner[this.i % this.spinner.length]);
                }
                ++this.i;
            }
        };
    }

    @Override
    public TestPluginArguments getConfiguration() {
        return this.coverageOptions.getPitConfig();
    }

    @Override
    public LaunchOptions getLaunchOptions() {
        return this.launchOptions;
    }
}

