/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.mudebug.prapr.SuspChecker;
import org.mudebug.prapr.SuspStrategy;
import org.mudebug.prapr.commons.MutableInt;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.MutationAnalyser;
import org.pitest.mutationtest.build.AnalysisPriorityComparator;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.util.Log;

public class MutationTestBuilder {
    private final MutationSource mutationSource;
    private final WorkerFactory workerFactory;
    private final MutationGrouper grouper;
    private final SuspStrategy suspStrategy;
    private final int allTestsCount;
    private final Collection<String> failingTests;
    private final SuspChecker suspChecker;

    public MutationTestBuilder(WorkerFactory workerFactory, MutationAnalyser analyser, MutationSource mutationSource, MutationGrouper grouper, int allTestsCount, Collection<String> failingTests, SuspStrategy suspStrategy, SuspChecker suspChecker) {
        this.mutationSource = mutationSource;
        this.workerFactory = workerFactory;
        this.grouper = grouper;
        this.allTestsCount = allTestsCount;
        this.failingTests = failingTests;
        this.suspStrategy = suspStrategy;
        this.suspChecker = suspChecker;
    }

    public List<MutationAnalysisUnit> createMutationTestUnits(Collection<ClassName> codeClasses) {
        ArrayList<MutationAnalysisUnit> tus = new ArrayList<MutationAnalysisUnit>();
        FunctionalList allMutations = FCollection.flatMap(codeClasses, this.classToMutations());
        final MutableInt filteredOut = new MutableInt();
        FunctionalList mutations = FCollection.filter((Iterable)allMutations, (F)new Predicate<MutationDetails>(){

            public Boolean apply(MutationDetails md) {
                boolean result = MutationTestBuilder.this.suspChecker.isHit(md);
                if (!result) {
                    filteredOut.increment();
                }
                return result;
            }
        });
        Log.getLogger().info(String.format("*** %d/%d MUTATIONS HAVE BEEN FILTERED OUT.", filteredOut.intValue(), allMutations.size()));
        for (MutationDetails md : mutations) {
            md.setSusp(this.suspStrategy, this.failingTests, this.allTestsCount);
        }
        Collections.sort(mutations, this.comparator());
        FunctionalList needAnalysis = mutations;
        for (Collection collection : this.grouper.groupMutations(codeClasses, (Collection<MutationDetails>)needAnalysis)) {
            tus.add(this.makeUnanalysedUnit(collection));
        }
        Collections.sort(tus, new AnalysisPriorityComparator());
        return tus;
    }

    private Comparator<MutationDetails> comparator() {
        return new Comparator<MutationDetails>(){

            @Override
            public int compare(MutationDetails arg0, MutationDetails arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        };
    }

    private F<ClassName, Iterable<MutationDetails>> classToMutations() {
        return new F<ClassName, Iterable<MutationDetails>>(){

            public Iterable<MutationDetails> apply(ClassName a) {
                return MutationTestBuilder.this.mutationSource.createMutations(a);
            }
        };
    }

    private MutationAnalysisUnit makeUnanalysedUnit(Collection<MutationDetails> needAnalysis) {
        HashSet<ClassName> uniqueTestClasses = new HashSet<ClassName>();
        FCollection.flatMapTo(needAnalysis, MutationTestBuilder.mutationDetailsToTestClass(), uniqueTestClasses);
        return new MutationTestUnit(needAnalysis, uniqueTestClasses, this.workerFactory);
    }

    private static F<MutationDetails, Iterable<ClassName>> mutationDetailsToTestClass() {
        return new F<MutationDetails, Iterable<ClassName>>(){

            public Iterable<ClassName> apply(MutationDetails a) {
                return FCollection.map((Iterable)a.getTestsInOrder(), (F)TestInfo.toDefiningClassName());
            }
        };
    }
}

