/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.io.File;
import java.util.Collection;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.mutationtest.execute.MutationTestProcess;
import org.pitest.process.ProcessArgs;
import org.pitest.util.Log;
import org.pitest.util.SocketFinder;

public class WorkerFactory {
    private final String classPath;
    private final File baseDir;
    private final TestPluginArguments pitConfig;
    private final TimeoutLengthStrategy timeoutStrategy;
    private final boolean verbose;
    private final MutationConfig config;
    private final EngineArguments args;
    private final boolean reorderTestCases;
    private final boolean verboseReport;
    private final File dumpDir;

    public WorkerFactory(File baseDir, TestPluginArguments pitConfig, MutationConfig mutationConfig, EngineArguments args, TimeoutLengthStrategy timeoutStrategy, boolean verbose, String classPath, boolean reorderTestCases, boolean verboseReport, File dumpDir) {
        this.pitConfig = pitConfig;
        this.timeoutStrategy = timeoutStrategy;
        this.verbose = verbose;
        this.classPath = classPath;
        this.baseDir = baseDir;
        this.config = mutationConfig;
        this.args = args;
        this.reorderTestCases = reorderTestCases;
        this.verboseReport = verboseReport;
        this.dumpDir = dumpDir;
    }

    public MutationTestProcess createWorker(Collection<MutationDetails> remainingMutations, Collection<ClassName> testClasses) {
        MinionArguments fileArgs = new MinionArguments(remainingMutations, testClasses, this.config.getEngine().getName(), this.args, this.timeoutStrategy, Log.isVerbose(), this.pitConfig, this.args.getSuspChecker(), this.reorderTestCases, this.verboseReport, this.dumpDir);
        ProcessArgs args = ProcessArgs.withClassPath(this.classPath).andLaunchOptions(this.config.getLaunchOptions()).andBaseDir(this.baseDir).andStdout(this.captureStdOutIfVerbose()).andStderr((SideEffect1<String>)Prelude.printWith((Object)"stderr "));
        SocketFinder sf = new SocketFinder();
        MutationTestProcess worker = new MutationTestProcess(sf.getNextAvailableServerSocket(), args, fileArgs);
        return worker;
    }

    private SideEffect1<String> captureStdOutIfVerbose() {
        if (this.verbose) {
            return Prelude.printWith((Object)"stdout ");
        }
        return Prelude.noSideEffect(String.class);
    }
}

