/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AnnotationNode;
import org.pitest.bytecode.analysis.AnalysisFunctions;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class ExcludedAnnotationInterceptor
implements MutationInterceptor {
    private final List<String> configuredAnnotations;
    private boolean skipClass;
    private Predicate<MutationDetails> annotatedMethodMatcher;

    ExcludedAnnotationInterceptor(List<String> configuredAnnotations) {
        this.configuredAnnotations = configuredAnnotations;
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.skipClass = clazz.annotations().contains(this.avoidedAnnotation());
        if (!this.skipClass) {
            FunctionalList methods = clazz.methods().filter(this.hasAvoidedAnnotation()).map(AnalysisFunctions.matchMutationsInMethod());
            this.annotatedMethodMatcher = Prelude.or((Iterable)methods);
        }
    }

    private F<MethodTree, Boolean> hasAvoidedAnnotation() {
        return new F<MethodTree, Boolean>(){

            public Boolean apply(MethodTree a) {
                return a.annotations().contains(ExcludedAnnotationInterceptor.this.avoidedAnnotation());
            }
        };
    }

    private F<AnnotationNode, Boolean> avoidedAnnotation() {
        return new F<AnnotationNode, Boolean>(){

            public Boolean apply(AnnotationNode a) {
                return ExcludedAnnotationInterceptor.this.shouldAvoid(a.desc);
            }
        };
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.skipClass) {
            return Collections.emptyList();
        }
        return FCollection.filter(mutations, (F)Prelude.not(this.annotatedMethodMatcher));
    }

    @Override
    public void end() {
    }

    boolean shouldAvoid(String desc) {
        String matchAgainst = desc.replace(";", "");
        for (String each : this.configuredAnnotations) {
            if (!matchAgainst.endsWith(each)) continue;
            return true;
        }
        return false;
    }
}

