/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.NullReturnValsMutator;

class NullReturnsFilter
implements MutationInterceptor {
    private static final String MUTATOR_ID = NullReturnValsMutator.NULL_RETURN_VALUES.getGloballyUniqueId();
    private ClassTree currentClass;

    NullReturnsFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (F)Prelude.not(this.isEquivalent(m)));
    }

    private F<MutationDetails, Boolean> isEquivalent(Mutater m) {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                if (!MUTATOR_ID.equals(a.getMutator())) {
                    return false;
                }
                MethodTree method = (MethodTree)NullReturnsFilter.this.currentClass.methods().findFirst(MethodMatchers.forLocation(a.getId().getLocation())).value();
                int mutatedInstruction = a.getInstructionIndex();
                return this.returnsNull(method, mutatedInstruction);
            }

            private Boolean returnsNull(MethodTree method, int mutatedInstruction) {
                if (mutatedInstruction <= 0) {
                    return false;
                }
                return ((AbstractInsnNode)method.instructions().get(mutatedInstruction - 1)).getOpcode() == 1;
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

