package org.mulesoft.als.actions.references

import org.mulesoft.als.common.cache.ASTPartBranchCached
import org.mulesoft.als.common.dtoTypes.{Position, PositionRange}
import org.mulesoft.amfintegration.relationships.{AliasInfo, AliasRelationships, FullLink, RelationshipLink}

object FindReferences {
  def getReferences(
      uri: String,
      position: Position,
      allAliases: Seq[AliasInfo],
      allRelationships: Seq[RelationshipLink],
      astPartBranchCached: ASTPartBranchCached
  ): Seq[FullLink] =
    AliasRelationships
      .getLinks(allAliases, allRelationships, astPartBranchCached)
      .filter(r => containsPosition(uri, position, r.destination.uri, PositionRange(r.destination.range)))

  private def containsPosition(
      uri: String,
      position: Position,
      destinationUri: String,
      destinationRange: PositionRange
  ) =
    destinationUri == uri && destinationRange
      .contains(position)
}
