package org.mulesoft.amfintegration.vocabularies.jsonschema.agentnetwork

import amf.core.client.scala.model.domain.AmfObject

object AgentNetworkVocabulary {
  val BASE = "http://anypoint.com/vocabs/agents#"
  val KIND_BASE = "http://anypoint.com/vocabs/agents/reference/kind#"

  val DECLARATIONS = s"${BASE}DeclarationDefinitions"
  val REFERENCE = s"${BASE}Reference"
  val REF = s"${BASE}ref"

  // field name where the reference goes
  val NAME = s"${BASE}name"
  val KIND: String = s"${BASE}kind"

  def getKind(amfObject: AmfObject): Option[String] =
    amfObject.meta.typeIris.find(_.startsWith(AgentNetworkVocabulary.KIND_BASE))

  def getKind(kind: String): String =
    AgentNetworkVocabulary.KIND_BASE.concat(kind)

}
