package org.mulesoft.als.common

import amf.core.model.document.BaseUnit
import amf.core.model.domain.{AmfObject, DomainElement}
import amf.core.parser.{Position => AmfPosition}
import AmfSonElementFinder._
import amf.core.metamodel.document.BaseUnitModel
import amf.core.parser.FieldEntry

case class ObjectInTree(obj: AmfObject, stack: Seq[AmfObject])

object ObjectInTreeBuilder {

  def fromUnit(bu: BaseUnit, position: AmfPosition): ObjectInTree = {
    val (obj, stack) = bu.findSonWithStack(position, Seq((f: FieldEntry) => f.field != BaseUnitModel.References))
    ObjectInTree(obj, stack)
  }

  def fromSubTree(element: DomainElement, position: AmfPosition, previousStack: Seq[AmfObject]): ObjectInTree = {
    val (obj, stack) = element.findSonWithStack(position, Seq.empty)
    ObjectInTree(obj, stack ++ previousStack)
  }
}
