package org.mulesoft.amfintegration.dialect.dialects.asyncapi20

import amf.plugins.document.vocabularies.ReferenceStyles
import amf.plugins.document.vocabularies.model.domain.DocumentsModel
import org.mulesoft.amfintegration.dialect.BaseDialect
import org.mulesoft.amfintegration.dialect.dialects.asyncapi20.bindings._
import org.mulesoft.amfintegration.dialect.dialects.asyncapi20.schema._
import org.mulesoft.amfintegration.dialect.dialects.oas.nodes.{
  AMLContactObject,
  AMLExternalDocumentationObject,
  AMLInfoObject,
  AMLLicenseObject,
  AMLTagObject,
  DialectNode
}
import org.mulesoft.amfintegration.dialect.dialects.raml.raml10.Raml10Dialect

object AsyncApi20Dialect extends BaseDialect {
  private val _                        = Raml10Dialect().id // hack for ExampleNode.id
  override def DialectLocation: String = "file://vocabularies/dialects/asyncapi20.yaml"

  override val declares: Seq[DialectNode] = Seq(
    AsyncApi20WebApiNode,
    AsyncApi20SecuritySchemeObject,
    AsyncAPI20ApiKeySecurityObject,
    AsyncAPI20HttpApiKeySecurityObject,
    AsyncAPI20HttpSecurityObject,
    AsyncAPI20Auth20SecurityObject,
    AsyncAPI20penIdConnectUrl,
    Oauth2FlowObject,
    AsyncAPI20FlowObject,
    ChannelObject,
    CorrelationIdObjectNode,
    MessageObjectNode,
    MessageTraitsObjectNode,
    OperationObject,
    OperationTraitsObjectNode,
    ParameterObjectNode,
    ChannelBindingsObjectNode,
    ServerBindingObjectNode,
    MessageBindingObjectNode,
    OperationBindingsObjectNode,
    BaseShapeAsync2Node,
    AnyShapeAsync2Node,
    ArrayShapeAsync2Node,
    NodeShapeAsync2Node,
    NumberShapeAsync2Node,
    StringShapeAsync2Node,
    ChannelBindingObjectNode,
    ServerBindingObjectNode,
    MessageBindingObjectNode,
    OperationBindingObjectNode,
    DynamicBindingObjectNode,
    ServerBindingsObjectNode,
    OperationBindingsObjectNode,
    ChannelBindingsObjectNode,
    MessageBindingsObjectNode,
    AmqpChannelBindingObject,
    WsChannelBindingObject,
    LastWillMqttServerBindingObject,
    MqttServerBindingObjectNode,
    AmqpMessageBindingObjectNode,
    KafkaMessageBindingObjectNode,
    MqttMessageBindingObjectNode,
    HttpMessageBindingObjectNode,
    AmqpOperationBindingObjectNode,
    KafkaOperationBindingObjectNode,
    HttpOperationBindingObjectNode,
    MqttOperationBindingObjectNode,
    QueueAmqpChannelBinding,
    RoutingKeyAmqpChannelBinding,
    StringShapeAsync2Node,
    AMLExternalDocumentationObject,
    AMLInfoObject,
    AMLContactObject,
    AMLLicenseObject,
    AMLTagObject,
    AsyncApiServerObject
  )

  override def emptyDocument: DocumentsModel =
    DocumentsModel()
      .withId(DialectLocation + "#/documents")
      .withKeyProperty(true)
      .withReferenceStyle(ReferenceStyles.JSONSCHEMA)
      .withDeclarationsPath("components")

  override def encodes: DialectNode = AsyncApi20WebApiNode

  override def declaredNodes: Map[String, DialectNode] = Map(
    "securitySchemes"   -> AsyncApi20SecuritySchemeObject,
    "messages"          -> MessageObjectNode,
    "parameters"        -> ParameterObjectNode,
    "correlationIds"    -> CorrelationIdObjectNode,
    "operationTraits"   -> OperationTraitsObjectNode,
    "messageTraits"     -> MessageTraitsObjectNode,
    "serverBindings"    -> ServerBindingsObjectNode,
    "channelBindings"   -> ChannelBindingsObjectNode,
    "operationBindings" -> OperationBindingsObjectNode,
    "messageBindings"   -> MessageBindingsObjectNode,
    "schemas"           -> BaseShapeAsync2Node
  )

  override protected val name: String    = "asyncapi"
  override protected val version: String = "2.0.0"
}
