package org.mulesoft.amfintegration.parse.plugins

import amf.apicontract.internal.plugins.ApiParsePlugin
import amf.core.client.scala.errorhandling.AMFErrorHandler
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.parse.document.{ParserContext, ReferenceHandler}
import amf.core.internal.parser.Root
import amf.core.internal.remote.Spec
import amf.grpc.internal.plugins.parse.GrpcParsePlugin
import amf.grpc.internal.spec.parser.syntax.GrpcASTParserHelper

object AlsGrpcParsePlugin extends ApiParsePlugin with GrpcASTParserHelper {

  override def spec: Spec = GrpcParsePlugin.spec

  override def parse(document: Root, ctx: ParserContext): BaseUnit = GrpcParsePlugin.parse(document, ctx)

  override def mediaTypes: Seq[String] = GrpcParsePlugin.mediaTypes

  override def applies(element: Root): Boolean = true

  override def referenceHandler(eh: AMFErrorHandler): ReferenceHandler = GrpcParsePlugin.referenceHandler(eh)

  override def withIdAdoption: Boolean = GrpcParsePlugin.withIdAdoption

  override def validSpecsToReference: Seq[Spec] = GrpcParsePlugin.validSpecsToReference
}
