/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.high.level.builder;

import amf.core.annotations.Aliases;
import amf.core.annotations.SourceVendor;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.Fragment;
import amf.core.model.document.Module;
import amf.core.remote.Platform;
import amf.core.remote.Vendor;
import amf.plugins.document.vocabularies.model.document.DialectInstance;
import amf.plugins.document.vocabularies.model.document.DialectInstanceFragment;
import amf.plugins.document.vocabularies.model.document.DialectInstanceLibrary;
import java.io.Serializable;
import org.mulesoft.high.level.builder.ASTFactoryRegistry$;
import org.mulesoft.high.level.builder.IASTFactory;
import org.mulesoft.high.level.builder.NodeBuilder$;
import org.mulesoft.high.level.dialect.DialectProjectBuilder$;
import org.mulesoft.high.level.implementation.ASTNodeImpl;
import org.mulesoft.high.level.implementation.ASTUnit;
import org.mulesoft.high.level.implementation.ASTUnit$;
import org.mulesoft.high.level.implementation.Project;
import org.mulesoft.high.level.implementation.Project$;
import org.mulesoft.high.level.interfaces.IProject;
import org.mulesoft.high.level.typesystem.BaseUnitReference;
import org.mulesoft.high.level.typesystem.TypeBuilder$;
import org.mulesoft.typesystem.project.DependencyEntry;
import org.mulesoft.typesystem.project.FragmentDependencyEntry;
import org.mulesoft.typesystem.project.ModuleDependencyEntry;
import org.mulesoft.typesystem.project.TypeCollection;
import org.mulesoft.typesystem.project.TypeCollectionBundle;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ProjectBuilder$ {
    public static ProjectBuilder$ MODULE$;

    static {
        new ProjectBuilder$();
    }

    public IProject buildProject(BaseUnit rootUnit, Platform platform) {
        IProject iProject;
        BaseUnit baseUnit = rootUnit;
        if (baseUnit instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit;
            iProject = DialectProjectBuilder$.MODULE$.getInstance().buildProject((BaseUnit)dialectInstance, platform);
        } else if (baseUnit instanceof DialectInstanceLibrary) {
            DialectInstanceLibrary dialectInstanceLibrary = (DialectInstanceLibrary)baseUnit;
            iProject = DialectProjectBuilder$.MODULE$.getInstance().buildProject((BaseUnit)dialectInstanceLibrary, platform);
        } else if (baseUnit instanceof DialectInstanceFragment) {
            DialectInstanceFragment dialectInstanceFragment = (DialectInstanceFragment)baseUnit;
            iProject = DialectProjectBuilder$.MODULE$.getInstance().buildProject((BaseUnit)dialectInstanceFragment, platform);
        } else {
            iProject = this.buildProjectInternal(rootUnit, platform);
        }
        return iProject;
    }

    public IProject buildProjectInternal(BaseUnit rootUnit, Platform platform) {
        Project project;
        Option<Vendor> option = this.determineFormat(rootUnit);
        if (option instanceof Some) {
            Some some = (Some)option;
            Vendor format = (Vendor)some.value();
            Option<IASTFactory> option2 = ASTFactoryRegistry$.MODULE$.getFactory(format);
            if (!(option2 instanceof Some)) {
                throw new Error(new StringBuilder(16).append("Unknown format: ").append(format).toString());
            }
            Some some2 = (Some)option2;
            IASTFactory factory = (IASTFactory)some2.value();
            Map<String, BaseUnit> units = this.listUnits(rootUnit, this.listUnits$default$2());
            TypeCollectionBundle bundle = TypeBuilder$.MODULE$.buildTypes(units, factory);
            Project project2 = Project$.MODULE$.apply(bundle, format, platform);
            Map<String, ASTUnit> astUnits = this.createASTUnits(units, bundle, project2);
            astUnits.values().foreach((Function1 & Serializable & scala.Serializable)u -> {
                project2.addUnit(u);
                return BoxedUnit.UNIT;
            });
            this.initASTUnits(astUnits, bundle, factory);
            String rootUnitPath = TypeBuilder$.MODULE$.normalizedPath(rootUnit);
            project2.setRootUnit((ASTUnit)astUnits.apply(rootUnit.location().getOrElse((Function0 & Serializable & scala.Serializable)() -> rootUnitPath)));
            project = project2;
        } else {
            throw new Error("Unable to determine input format");
        }
        Project project3 = project;
        return project3;
    }

    public Map<String, ASTUnit> createASTUnits(Map<String, BaseUnit> units, TypeCollectionBundle bundle, Project project) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        units.values().foreach((Function1 & Serializable & scala.Serializable)bu -> {
            String unitPath = TypeBuilder$.MODULE$.normalizedPath((BaseUnit)bu);
            TypeCollection tc = (TypeCollection)bundle.typeCollections().apply((Object)unitPath);
            ASTUnit astUnit = ASTUnit$.MODULE$.apply((BaseUnit)bu, tc, project);
            return result.put((Object)astUnit.path(), (Object)astUnit);
        });
        return result;
    }

    public void initASTUnits(Map<String, ASTUnit> astUnits, TypeCollectionBundle bundle, IASTFactory factory) {
        astUnits.values().foreach((Function1 & Serializable & scala.Serializable)astUnit -> {
            ProjectBuilder$.$anonfun$initASTUnits$1(astUnits, astUnit);
            return BoxedUnit.UNIT;
        });
        astUnits.values().foreach((Function1 & Serializable & scala.Serializable)astUnit -> {
            ProjectBuilder$.$anonfun$initASTUnits$8(bundle, factory, astUnit);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Vendor> determineFormat(BaseUnit baseUnit) {
        None$ none$;
        BaseUnit baseUnit2 = baseUnit;
        if (baseUnit2 instanceof ExternalFragment) {
            none$ = None$.MODULE$;
        } else if (baseUnit.annotations().contains(SourceVendor.class)) {
            none$ = baseUnit.annotations().find(SourceVendor.class).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.vendor());
        } else if (baseUnit2 instanceof EncodesModel) {
            BaseUnit baseUnit3 = baseUnit2;
            none$ = ((EncodesModel)baseUnit3).encodes().annotations().find(SourceVendor.class).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.vendor());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Map<String, BaseUnit> listUnits(BaseUnit rootUnit, scala.collection.mutable.Map<String, BaseUnit> processed) {
        block0: {
            String id = TypeBuilder$.MODULE$.normalizedPath(rootUnit);
            if (processed.contains((Object)id)) break block0;
            processed.update((Object)id, (Object)rootUnit);
            rootUnit.references().foreach((Function1 & Serializable & scala.Serializable)unit -> MODULE$.listUnits((BaseUnit)unit, processed));
        }
        return processed;
    }

    private scala.collection.mutable.Map<String, BaseUnit> listUnits$default$2() {
        return (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$initASTUnits$5(String ref$1, Tuple2 usesEntry) {
        Object object = ((Tuple2)usesEntry._2())._1();
        String string = ref$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$7(ASTUnit referredAstUnit$1, String namespace$1, String libPath$1, ASTUnit astUnit$1, ASTUnit referringAstUnit) {
        ModuleDependencyEntry<ASTUnit> dep = new ModuleDependencyEntry<ASTUnit>(libPath$1, referredAstUnit$1, namespace$1, libPath$1);
        astUnit$1.registerDependency(dep);
        ModuleDependencyEntry<ASTUnit> reverseDep = new ModuleDependencyEntry<ASTUnit>(referringAstUnit.path(), referringAstUnit, namespace$1, libPath$1);
        referredAstUnit$1.registerReverseDependency(reverseDep);
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$6(Map astUnits$1, ASTUnit referredAstUnit$1, ASTUnit astUnit$1, Tuple2 usesEntry) {
        String namespace = (String)usesEntry._1();
        String referringModulePath = (String)((Tuple2)usesEntry._2())._1();
        String libPath = (String)((Tuple2)usesEntry._2())._2();
        astUnits$1.get((Object)referringModulePath).foreach((Function1 & Serializable & scala.Serializable)referringAstUnit -> {
            ProjectBuilder$.$anonfun$initASTUnits$7(referredAstUnit$1, namespace, libPath, astUnit$1, referringAstUnit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$4(Map astUnits$1, String ref$1, ASTUnit referredAstUnit$1, ASTUnit astUnit$1, Set aliases) {
        ((IterableLike)aliases.filter((Function1 & Serializable & scala.Serializable)usesEntry -> BoxesRunTime.boxToBoolean((boolean)ProjectBuilder$.$anonfun$initASTUnits$5(ref$1, usesEntry)))).foreach((Function1 & Serializable & scala.Serializable)usesEntry -> {
            ProjectBuilder$.$anonfun$initASTUnits$6(astUnits$1, referredAstUnit$1, astUnit$1, usesEntry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$2(Map astUnits$1, ASTUnit astUnit$1, BaseUnitReference u) {
        String ref = u.reference();
        ASTUnit referredAstUnit = (ASTUnit)astUnits$1.apply((Object)ref);
        BaseUnit baseUnit = referredAstUnit.baseUnit();
        if (baseUnit instanceof Module) {
            astUnit$1.baseUnit().annotations().find(Aliases.class).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.aliases()).foreach((Function1 & Serializable & scala.Serializable)aliases -> {
                ProjectBuilder$.$anonfun$initASTUnits$4(astUnits$1, ref, referredAstUnit, astUnit$1, aliases);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseUnit instanceof ExternalFragment) {
            DependencyEntry<ASTUnit> dep = new DependencyEntry<ASTUnit>(ref, referredAstUnit);
            astUnit$1.registerDependency(dep);
            DependencyEntry<ASTUnit> reverseDep = new DependencyEntry<ASTUnit>(astUnit$1.path(), astUnit$1);
            referredAstUnit.registerReverseDependency(reverseDep);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseUnit instanceof Fragment) {
            FragmentDependencyEntry<ASTUnit> dep = new FragmentDependencyEntry<ASTUnit>(ref, referredAstUnit);
            astUnit$1.registerDependency(dep);
            FragmentDependencyEntry<ASTUnit> reverseDep = new FragmentDependencyEntry<ASTUnit>(astUnit$1.path(), astUnit$1);
            referredAstUnit.registerReverseDependency(reverseDep);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$1(Map astUnits$1, ASTUnit astUnit) {
        TypeBuilder$.MODULE$.getReferences(astUnit.baseUnit()).foreach((Function1 & Serializable & scala.Serializable)u -> {
            ProjectBuilder$.$anonfun$initASTUnits$2(astUnits$1, astUnit, u);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$9(ASTUnit astUnit$2, ASTNodeImpl x) {
        astUnit$2.setRootNode(x);
        x.setASTUnit(astUnit$2);
    }

    public static final /* synthetic */ void $anonfun$initASTUnits$8(TypeCollectionBundle bundle$2, IASTFactory factory$1, ASTUnit astUnit) {
        Option<ASTNodeImpl> hlNode = NodeBuilder$.MODULE$.buildAST(astUnit.baseUnit(), bundle$2, factory$1);
        hlNode.foreach((Function1 & Serializable & scala.Serializable)x -> {
            ProjectBuilder$.$anonfun$initASTUnits$9(astUnit, x);
            return BoxedUnit.UNIT;
        });
        astUnit.initSources();
    }

    private ProjectBuilder$() {
        MODULE$ = this;
    }
}

