package org.mulesoft.lsp.feature.completion

/** Defines whether the insert text in a completion item should be interpreted as plain text or a snippet.
  */
case object InsertTextFormat extends Enumeration {
  type InsertTextFormat = Value

  /** The primary text to be inserted is treated as a plain string.
    */
  val PlainText: Value = Value(1)

  /** The primary text to be inserted is treated as a snippet.
    *
    * A snippet can define tab stops and placeholders
    */
  val Snippet: Value = Value(2)
}
