/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.language.server.modules.editorManager;

import java.io.Serializable;
import org.mulesoft.language.common.logger.ILogger;
import org.mulesoft.language.server.modules.commonInterfaces.IEditorTextBuffer;
import org.mulesoft.language.server.modules.commonInterfaces.IPoint;
import org.mulesoft.language.server.modules.commonInterfaces.IRange;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001=\u0011a\u0002V3yi\n+hMZ3s\u0013:4wN\u0003\u0002\u0004\t\u0005iQ\rZ5u_Jl\u0015M\\1hKJT!!\u0002\u0004\u0002\u000f5|G-\u001e7fg*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011\u0001\u00037b]\u001e,\u0018mZ3\u000b\u0005-a\u0011\u0001C7vY\u0016\u001cxN\u001a;\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0011G>lWn\u001c8J]R,'OZ1dKNL!a\u0007\r\u0003#%+E-\u001b;peR+\u0007\u0010\u001e\"vM\u001a,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\r)(/\u001b\t\u0003?\u0019r!\u0001\t\u0013\u0011\u0005\u0005\u0012R\"\u0001\u0012\u000b\u0005\rr\u0011A\u0002\u001fs_>$h(\u0003\u0002&%\u00051\u0001K]3eK\u001aL!a\n\u0015\u0003\rM#(/\u001b8h\u0015\t)#\u0003\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0019awnZ4feB\u0011A\u0006M\u0007\u0002[)\u0011!F\f\u0006\u0003_!\taaY8n[>t\u0017BA\u0019.\u0005\u001dIEj\\4hKJDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002\u0005!)QD\ra\u0001=!)!F\ra\u0001W!9!\b\u0001a\u0001\n\u0003Y\u0014\u0001\u0002;fqR,\u0012A\b\u0005\b{\u0001\u0001\r\u0011\"\u0001?\u0003!!X\r\u001f;`I\u0015\fHCA C!\t\t\u0002)\u0003\u0002B%\t!QK\\5u\u0011\u001d\u0019E(!AA\u0002y\t1\u0001\u001f\u00132\u0011\u0019)\u0005\u0001)Q\u0005=\u0005)A/\u001a=uA!9q\t\u0001a\u0001\n\u0003A\u0015a\u00037j]\u0016dUM\\4uQN,\u0012!\u0013\t\u0004\u0015>\u000bV\"A&\u000b\u00051k\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001dJ\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00016JA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA\tS\u0013\t\u0019&CA\u0002J]RDq!\u0016\u0001A\u0002\u0013\u0005a+A\bmS:,G*\u001a8hi\"\u001cx\fJ3r)\tyt\u000bC\u0004D)\u0006\u0005\t\u0019A%\t\re\u0003\u0001\u0015)\u0003J\u00031a\u0017N\\3MK:<G\u000f[:!\u0011\u0015Y\u0006\u0001\"\u0001]\u00031a\u0017N\\3Cs>3gm]3u)\t\tV\fC\u0003_5\u0002\u0007\u0011+\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006A\u0002!\t!Y\u0001\u001aG\"\f'/Y2uKJLe\u000eZ3y\r>\u0014\bk\\:ji&|g\u000e\u0006\u0002RE\")1m\u0018a\u0001I\u0006A\u0001o\\:ji&|g\u000e\u0005\u0002\u0018K&\u0011a\r\u0007\u0002\u0007\u0013B{\u0017N\u001c;\t\u000b!\u0004A\u0011A5\u00023A|7/\u001b;j_:4uN]\"iCJ\f7\r^3s\u0013:$W\r\u001f\u000b\u0003I*DQAX4A\u0002ECQ\u0001\u001c\u0001\u0005\u00025\f1B]1oO\u00164uN\u001d*poR\u0019a.]:\u0011\u0005]y\u0017B\u00019\u0019\u0005\u0019I%+\u00198hK\")!o\u001ba\u0001#\u0006A!o\\<QCJ\fW\u000eC\u0003uW\u0002\u0007Q/\u0001\bj]\u000edW\u000fZ3OK^d\u0017N\\3\u0011\u0005E1\u0018BA<\u0013\u0005\u001d\u0011un\u001c7fC:DQ!\u001f\u0001\u0005\u0002i\fabZ3u)\u0016DH/\u00138SC:<W\r\u0006\u0002\u001fw\")A\u0010\u001fa\u0001]\u0006)!/\u00198hK\")a\u0010\u0001C\u0001\u007f\u0006q1/\u001a;UKb$\u0018J\u001c*b]\u001e,GcB \u0002\u0002\u0005\r\u0011Q\u0001\u0005\u0006yv\u0004\rA\u001c\u0005\u0006uu\u0004\rA\b\u0005\t\u0003\u000fi\b\u0013!a\u0001k\u0006!bn\u001c:nC2L'0\u001a'j]\u0016,e\u000eZ5oONDq!a\u0003\u0001\t\u0003\ti!A\u0004hKR$V\r\u001f;\u0015\u0003yAq!!\u0005\u0001\t\u0003\t\u0019\"\u0001\bhKR,e\u000e\u001a)pg&$\u0018n\u001c8\u0015\u0003\u0011Dq!a\u0006\u0001\t\u0003\tI\"A\u0004tKR$V\r\u001f;\u0015\u0007}\nY\u0002\u0003\u0004;\u0003+\u0001\rA\b\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003-Ig.\u001b;NCB\u0004\u0018N\\4\u0015\u0003}B\u0011\"!\n\u0001#\u0003%\t%a\n\u00021M,G\u000fV3yi&s'+\u00198hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002*)\u001aQ/a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000e\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\t\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TextBufferInfo
implements IEditorTextBuffer {
    private final ILogger logger;
    private String text;
    private ArrayBuffer<Object> lineLengths;

    public String text() {
        return this.text;
    }

    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    public ArrayBuffer<Object> lineLengths() {
        return this.lineLengths;
    }

    public void lineLengths_$eq(ArrayBuffer<Object> x$1) {
        this.lineLengths = x$1;
    }

    @Override
    public int lineByOffset(int offset) {
        int n;
        Object object = new Object();
        try {
            IntRef currentOffset = IntRef.create((int)0);
            this.lineLengths().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                currentOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
                if (currentOffset$1.elem > offset) {
                    throw new NonLocalReturnControl.mcI.sp(object, i);
                }
            });
            n = this.lineLengths().length() - 1;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int characterIndexForPosition(IPoint position) {
        void var3_3;
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), position.row()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int result = lineStartOffset.elem + position.column();
        this.logger.debugDetail("characterIndexForPosition:: [" + position.row() + ":" + position.column() + "] = " + result, "EditorManager", "TextBufferInfo#characterIndexForPosition");
        return (int)var3_3;
    }

    @Override
    public IPoint positionForCharacterIndex(int offset) {
        IPoint iPoint;
        IntRef pos = IntRef.create((int)offset);
        ObjectRef found = ObjectRef.create((Object)None$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.lineLengths().length()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((Option)found$1.elem).isEmpty()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
            if (pos$1.elem < lineLength) {
                $this.logger.debugDetail("positionForCharacterIndex:" + offset + ": [" + i + ":" + pos$1.elem + "]", "EditorManager", "TextBufferInfo#positionForCharacterIndex");
                found$1.elem = Option$.MODULE$.apply((Object)new IPoint(i, pos$1.elem));
            }
            pos$1.elem -= lineLength;
        });
        if (((Option)found.elem).isDefined()) {
            iPoint = (IPoint)((Option)found.elem).get();
        } else if (pos.elem == 0) {
            int resultRow = this.lineLengths().length() - 1;
            int resultColumn = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(this.lineLengths().length() - 1));
            this.logger.debugDetail("positionForCharacterIndex:" + offset + ": [" + resultRow + ":" + resultColumn + "]", "EditorManager", "TextBufferInfo#positionForCharacterIndex");
            iPoint = new IPoint(resultRow, resultColumn);
        } else {
            String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Character position exceeds text length: ", " > + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), BoxesRunTime.boxToInteger((int)this.text().length())}));
            this.logger.error(errorMessage, "EditorManager", "TextBufferInfo#positionForCharacterIndex");
            throw new Error(errorMessage);
        }
        return iPoint;
    }

    @Override
    public IRange rangeForRow(int rowParam, boolean includeNewline) {
        this.logger.debugDetail("rangeForRow start:" + rowParam, "EditorManager", "TextBufferInfo#rangeForRow");
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowParam).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$2.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(rowParam));
        IPoint startPoint = new IPoint(rowParam, 0);
        IPoint endPoint = new IPoint(rowParam, lineLength);
        this.logger.debugDetail("rangeForRow return:" + rowParam + ": [" + startPoint.row() + ":" + startPoint.column() + "]" + ",[" + endPoint.row() + ":" + endPoint.column() + "]", "EditorManager", "TextBufferInfo#rangeForRow");
        return new IRange(null, startPoint, endPoint){
            private IPoint start;
            private IPoint end;

            public IPoint start() {
                return this.start;
            }

            public void start_$eq(IPoint x$1) {
                this.start = x$1;
            }

            public IPoint end() {
                return this.end;
            }

            public void end_$eq(IPoint x$1) {
                this.end = x$1;
            }
            {
                this.start = startPoint$1;
                this.end = endPoint$1;
            }
        };
    }

    @Override
    public String getTextInRange(IRange range) {
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        String result = this.text().substring(startOffset, endOffset);
        this.logger.debugDetail("Text in range: [" + range.start().row() + ":" + range.start().column() + "]" + ",[" + range.end().row() + ":" + range.end().column() + "]:\n" + result, "EditorManager", "TextBufferInfo#getTextInRange");
        return result;
    }

    @Override
    public void setTextInRange(IRange range, String text, boolean normalizeLineEndings) {
        this.logger.debug("Setting text in range: [" + range.start().row() + ":" + range.start().column() + "] ," + "[" + range.end().row() + ":" + range.end().column() + "]\n" + text, "EditorManager", "TextBufferInfo#setTextInRange");
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        this.logger.debugDetail("Found range in absolute coords: [" + startOffset + ":" + endOffset + "]", "EditorManager", "TextBufferInfo#setTextInRange");
        String startText = startOffset > 0 ? this.text().substring(0, startOffset) : "";
        String endText = endOffset < this.text().length() ? this.text().substring(endOffset) : "";
        this.logger.debugDetail("Start text is:\n" + startText, "EditorManager", "TextBufferInfo#setTextInRange");
        this.logger.debugDetail("End text is:\n" + endText, "EditorManager", "TextBufferInfo#setTextInRange");
        this.setText(startText + text + endText);
        this.logger.debugDetail("Final text is:\n" + this.text(), "EditorManager", "TextBufferInfo#setTextInRange");
    }

    @Override
    public String getText() {
        return this.text();
    }

    @Override
    public IPoint getEndPosition() {
        return this.positionForCharacterIndex(this.text().length() - 1);
    }

    public void setText(String text) {
        this.text_$eq(text);
        this.initMapping();
    }

    @Override
    public boolean setTextInRange$default$3() {
        return false;
    }

    public void initMapping() {
        this.lineLengths_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        IntRef ind = IntRef.create((int)0);
        int l = this.text().length();
        BooleanRef ignoreNext = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), l).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block3: {
                block4: {
                    block2: {
                        if (!ignoreNext$1.elem) break block2;
                        ignoreNext$1.elem = false;
                        break block3;
                    }
                    ignoreNext$1.elem = false;
                    if (this.text().charAt(i) != '\r') break block4;
                    if (i < l - 1 && this.text().charAt(i + 1) == '\n') {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 2)));
                        ind$1.elem = i + 2;
                        ignoreNext$1.elem = true;
                    } else {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                        ind$1.elem = i + 1;
                    }
                    break block3;
                }
                if (this.text().charAt(i) != '\n') break block3;
                this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                ind$1.elem = i + 1;
            }
        });
        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(l - ind.elem)));
    }

    public TextBufferInfo(String uri, ILogger logger) {
        this.logger = logger;
        this.text = "";
        this.lineLengths = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

