/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import amf.core.remote.Aml$;
import amf.core.remote.Oas20$;
import amf.core.remote.Platform;
import amf.core.remote.Raml08$;
import amf.core.remote.Raml10$;
import java.io.Serializable;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.common.TextEdit;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.IDocumentChangeExecutor;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.lsp.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SaveOptions;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncConsumer;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u00015\u00111\u0003V3yi\u0012{7-^7f]Rl\u0015M\\1hKJT!a\u0001\u0003\u0002\u0011Q,\u0007\u0010^:z]\u000eT!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"A\u0002bYNT!!\u0003\u0006\u0002\u00115,H.Z:pMRT\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001635\taC\u0003\u0002\u0004/)\u0011\u0001\u0004C\u0001\u0004YN\u0004\u0018B\u0001\u000e\u0017\u0005a!V\r\u001f;E_\u000e,X.\u001a8u'ft7mQ8ogVlWM\u001d\u0005\t9\u0001\u0011)\u0019!C\u0005;\u00051An\\4hKJ,\u0012A\b\t\u0003?\u0005j\u0011\u0001\t\u0006\u00039\u0011I!A\t\u0011\u0003\r1{wmZ3s\u0011!!\u0003A!A!\u0002\u0013q\u0012a\u00027pO\u001e,'\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005A\u0001\u000f\\1uM>\u0014X.F\u0001)!\tI\u0003'D\u0001+\u0015\tYC&\u0001\u0004sK6|G/\u001a\u0006\u0003[9\nAaY8sK*\tq&A\u0002b[\u001aL!!\r\u0016\u0003\u0011Ac\u0017\r\u001e4pe6D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\na2\fGOZ8s[\u0002BQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtDcA\u001c:uA\u0011\u0001\bA\u0007\u0002\u0005!)A\u0004\u000ea\u0001=!)a\u0005\u000ea\u0001Q!9A\b\u0001b\u0001\n\u0003j\u0014\u0001\u0002;za\u0016,\u0012A\u0010\b\u0003+}J!\u0001\u0011\f\u00025Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7i\u001c8gS\u001e$\u0016\u0010]3\t\r\t\u0003\u0001\u0015!\u0003?\u0003\u0015!\u0018\u0010]3!\u0011\u0015!\u0005\u0001\"\u0011F\u0003-\t\u0007\u000f\u001d7z\u0007>tg-[4\u0015\u0005\u0019#\u0007\u0003B$P%\u0006t!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-c\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tq\u0005#A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&AB#ji\",'O\u0003\u0002O!A\u00111K\u0018\b\u0003)rs!!V.\u000f\u0005YSfBA,Z\u001d\tI\u0005,C\u0001\f\u0013\tI!\"\u0003\u0002\u0019\u0011%\u00111aF\u0005\u0003;Z\tA\u0003V3yi\u0012{7-^7f]R\u001c\u0016P\\2LS:$\u0017BA0a\u0005Q!V\r\u001f;E_\u000e,X.\u001a8u'ft7mS5oI*\u0011QL\u0006\t\u0003+\tL!a\u0019\f\u0003/Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001cw\n\u001d;j_:\u001c\b\"B3D\u0001\u00041\u0017AB2p]\u001aLw\rE\u0002\u0010O&L!\u0001\u001b\t\u0003\r=\u0003H/[8o!\t)\".\u0003\u0002l-\t\t3+\u001f8dQJ|g.\u001b>bi&|gn\u00117jK:$8)\u00199bE&d\u0017\u000e^5fg\"9Q\u000e\u0001a\u0001\n\u0003q\u0017aC;sSR{W\tZ5u_J,\u0012a\u001c\t\u0005aV<x0D\u0001r\u0015\t\u00118/A\u0004nkR\f'\r\\3\u000b\u0005Q\u0004\u0012AC2pY2,7\r^5p]&\u0011a/\u001d\u0002\u0004\u001b\u0006\u0004\bC\u0001=}\u001d\tI(\u0010\u0005\u0002J!%\u00111\u0010E\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|!A\u0019\u0001(!\u0001\n\u0007\u0005\r!A\u0001\u0007UKb$Hi\\2v[\u0016tG\u000fC\u0005\u0002\b\u0001\u0001\r\u0011\"\u0001\u0002\n\u0005yQO]5U_\u0016#\u0017\u000e^8s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001cA\b\u0002\u000e%\u0019\u0011q\u0002\t\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003'\t)!!AA\u0002=\f1\u0001\u001f\u00132\u0011\u001d\t9\u0002\u0001Q!\n=\fA\"\u001e:j)>,E-\u001b;pe\u0002B\u0011\"a\u0007\u0001\u0001\u0004%\t!!\b\u0002/\u0011|7-^7f]R\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cXCAA\u0010!\u0015\u0001\u0018\u0011EA\u0013\u0013\r\t\u0019#\u001d\u0002\u0004'\u0016$\bcB\b\u0002(\u0005-\u00121B\u0005\u0004\u0003S\u0001\"!\u0003$v]\u000e$\u0018n\u001c82!\rA\u0014QF\u0005\u0004\u0003_\u0011!aD\"iC:<W\r\u001a#pGVlWM\u001c;\t\u0013\u0005M\u0002\u00011A\u0005\u0002\u0005U\u0012a\u00073pGVlWM\u001c;DQ\u0006tw-\u001a'jgR,g.\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005]\u0002BCA\n\u0003c\t\t\u00111\u0001\u0002 !A\u00111\b\u0001!B\u0013\ty\"\u0001\re_\u000e,X.\u001a8u\u0007\"\fgnZ3MSN$XM\\3sg\u0002B\u0011\"a\u0010\u0001\u0001\u0004%\t!!\u0011\u0002+\u0011|7-^7f]R|\u0005/\u001a8MSN$XM\\3sgV\u0011\u00111\t\t\u0006a\u0006\u0005\u0012Q\t\t\b\u001f\u0005\u001d\u0012qIA\u0006!\rA\u0014\u0011J\u0005\u0004\u0003\u0017\u0012!AD(qK:,G\rR8dk6,g\u000e\u001e\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0001\u0003#\n\u0011\u0004Z8dk6,g\u000e^(qK:d\u0015n\u001d;f]\u0016\u00148o\u0018\u0013fcR!\u00111BA*\u0011)\t\u0019\"!\u0014\u0002\u0002\u0003\u0007\u00111\t\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002D\u00051Bm\\2v[\u0016tGo\u00149f]2K7\u000f^3oKJ\u001c\b\u0005C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0001\u0002^\u00051Bm\\2v[\u0016tGo\u00117pg\u0016d\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0002`A)\u0001/!\t\u0002bA1q\"a\nx\u0003\u0017A\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\u00025\u0011|7-^7f]R\u001cEn\\:f\u0019&\u001cH/\u001a8feN|F%Z9\u0015\t\u0005-\u0011\u0011\u000e\u0005\u000b\u0003'\t\u0019'!AA\u0002\u0005}\u0003\u0002CA7\u0001\u0001\u0006K!a\u0018\u0002/\u0011|7-^7f]R\u001cEn\\:f\u0019&\u001cH/\u001a8feN\u0004\u0003\"CA9\u0001\u0001\u0007I\u0011AA:\u0003Y!wnY;nK:$8\t[1oO\u0016,\u00050Z2vi>\u0014XCAA;!\u0011yq-a\u001e\u0011\u0007a\nI(C\u0002\u0002|\t\u0011q#\u0013#pGVlWM\u001c;DQ\u0006tw-Z#yK\u000e,Ho\u001c:\t\u0013\u0005}\u0004\u00011A\u0005\u0002\u0005\u0005\u0015A\u00073pGVlWM\u001c;DQ\u0006tw-Z#yK\u000e,Ho\u001c:`I\u0015\fH\u0003BA\u0006\u0003\u0007C!\"a\u0005\u0002~\u0005\u0005\t\u0019AA;\u0011!\t9\t\u0001Q!\n\u0005U\u0014a\u00063pGVlWM\u001c;DQ\u0006tw-Z#yK\u000e,Ho\u001c:!\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000b!\"\u001b8ji&\fG.\u001b>f)\t\ty\t\u0005\u0004\u0002\u0012\u0006]\u00151B\u0007\u0003\u0003'S1!!&\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u00033\u000b\u0019J\u0001\u0004GkR,(/\u001a\u0005\b\u0003;\u0003A\u0011AAP\u0003Aygn\u00115b]\u001e,Gi\\2v[\u0016tG\u000f\u0006\u0004\u0002\f\u0005\u0005\u0016Q\u0015\u0005\t\u0003G\u000bY\n1\u0001\u0002&\u0005AA.[:uK:,'\u000f\u0003\u0006\u0002(\u0006m\u0005\u0013!a\u0001\u0003S\u000b1\"\u001e8tk\n\u001c8M]5cKB\u0019q\"a+\n\u0007\u00055\u0006CA\u0004C_>dW-\u00198\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\u0006\u0001rN\\(qK:,G\rR8dk6,g\u000e\u001e\u000b\u0007\u0003\u0017\t),a.\t\u0011\u0005\r\u0016q\u0016a\u0001\u0003\u000bB!\"a*\u00020B\u0005\t\u0019AAU\u0011\u001d\tY\f\u0001C\u0001\u0003{\u000b\u0001c\u001c8DY>\u001cX\r\u001a#pGVlWM\u001c;\u0015\r\u0005-\u0011qXAa\u0011!\t\u0019+!/A\u0002\u0005\u0005\u0004BCAT\u0003s\u0003\n\u00111\u0001\u0002*\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017aD4fiR+\u0007\u0010\u001e#pGVlWM\u001c;\u0015\t\u0005%\u00171\u001a\t\u0004\u001f\u001d|\bbBAg\u0003\u0007\u0004\ra^\u0001\u0004kJL\u0007bBAi\u0001\u0011\u0005\u00111[\u0001\u000f_:|\u0005/\u001a8E_\u000e,X.\u001a8u)\u0011\tY!!6\t\u0011\u0005]\u0017q\u001aa\u0001\u0003\u000f\n\u0001\u0002Z8dk6,g\u000e\u001e\u0005\b\u00037\u0004A\u0011AAo\u0003e\u0019X\r\u001e#pGVlWM\u001c;DQ\u0006tw-Z#yK\u000e,Ho\u001c:\u0015\t\u0005-\u0011q\u001c\u0005\t\u0003C\fI\u000e1\u0001\u0002x\u0005AQ\r_3dkR|'\u000fC\u0004\u0002f\u0002!\t!a\u001d\u00023\u001d,G\u000fR8dk6,g\u000e^\"iC:<W-\u0012=fGV$xN\u001d\u0005\b\u0003S\u0004A\u0011AAv\u0003I!wnY;nK:$x+Y:DQ\u0006tw-\u001a3\u0015\t\u0005-\u0011Q\u001e\u0005\t\u0003/\f9\u000f1\u0001\u0002,!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\u0018aD8o\u00072|7/\u001a#pGVlWM\u001c;\u0015\t\u0005-\u0011Q\u001f\u0005\b\u0003\u001b\fy\u000f1\u0001x\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\f\u0001c\u001c8DQ\u0006tw-\u001a)pg&$\u0018n\u001c8\u0015\r\u0005-\u0011Q`A\u0000\u0011\u001d\ti-a>A\u0002]D\u0001B!\u0001\u0002x\u0002\u0007!1A\u0001\ta>\u001c\u0018\u000e^5p]B\u0019qB!\u0002\n\u0007\t\u001d\u0001CA\u0002J]RDqAa\u0003\u0001\t\u0003\u0011i!A\teKR,'/\\5oK2\u000bgnZ;bO\u0016$Ra\u001eB\b\u0005'AqA!\u0005\u0003\n\u0001\u0007q/A\u0002ve2DqA!\u0006\u0003\n\u0001\u0007q/\u0001\u0003uKb$\bb\u0002B\r\u0001\u0011\u0005!1D\u0001\u0010I\u0016$XM]7j]\u0016\u001c\u0016P\u001c;bqR)qO!\b\u0003 !9!\u0011\u0003B\f\u0001\u00049\bb\u0002B\u000b\u0005/\u0001\ra\u001e\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0003\u001d!\u0017\u000eZ(qK:$B!a\u0003\u0003(!A!\u0011\u0006B\u0011\u0001\u0004\u0011Y#\u0001\u0004qCJ\fWn\u001d\t\u0004+\t5\u0012b\u0001B\u0018-\tIB)\u001b3Pa\u0016tG+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005k\t\u0011\u0002Z5e\u0007\"\fgnZ3\u0015\t\u0005-!q\u0007\u0005\t\u0005S\u0011\t\u00041\u0001\u0003:A\u0019QCa\u000f\n\u0007\tubCA\u000eES\u0012\u001c\u0005.\u00198hKR+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn\u001d\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0003!!\u0017\u000eZ\"m_N,G\u0003BA\u0006\u0005\u000bB\u0001B!\u000b\u0003@\u0001\u0007!q\t\t\u0004+\t%\u0013b\u0001B&-\tQB)\u001b3DY>\u001cX\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\"I!q\n\u0001\u0012\u0002\u0013\u0005!\u0011K\u0001\u001b_:|\u0005/\u001a8fI\u0012{7-^7f]R$C-\u001a4bk2$HEM\u000b\u0003\u0005'RC!!+\u0003V-\u0012!q\u000b\t\u0005\u00053\u0012\u0019'\u0004\u0002\u0003\\)!!Q\fB0\u0003%)hn\u00195fG.,GMC\u0002\u0003bA\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ga\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003j\u0001\t\n\u0011\"\u0001\u0003R\u0005QrN\\\"iC:<W\rR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%e!I!Q\u000e\u0001\u0012\u0002\u0013\u0005!\u0011K\u0001\u001b_:\u001cEn\\:fI\u0012{7-^7f]R$C-\u001a4bk2$HE\r")
public class TextDocumentManager
implements TextDocumentSyncConsumer {
    private final Logger logger;
    private final Platform platform;
    private final TextDocumentSyncConfigType$ type;
    private Map<String, TextDocument> uriToEditor;
    private Set<Function1<ChangedDocument, BoxedUnit>> documentChangeListeners;
    private Set<Function1<OpenedDocument, BoxedUnit>> documentOpenListeners;
    private Set<Function1<String, BoxedUnit>> documentCloseListeners;
    private Option<IDocumentChangeExecutor> documentChangeExecutor;

    private Logger logger() {
        return this.logger;
    }

    private Platform platform() {
        return this.platform;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    @Override
    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        this.logger().debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$4 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option<Object> x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option<Object> x$6 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option<Object>)x$3, (Option<Enumeration.Value>)x$4, x$5, x$6, (Option<SaveOptions>)x$2));
    }

    public Map<String, TextDocument> uriToEditor() {
        return this.uriToEditor;
    }

    public void uriToEditor_$eq(Map<String, TextDocument> x$1) {
        this.uriToEditor = x$1;
    }

    public Set<Function1<ChangedDocument, BoxedUnit>> documentChangeListeners() {
        return this.documentChangeListeners;
    }

    public void documentChangeListeners_$eq(Set<Function1<ChangedDocument, BoxedUnit>> x$1) {
        this.documentChangeListeners = x$1;
    }

    public Set<Function1<OpenedDocument, BoxedUnit>> documentOpenListeners() {
        return this.documentOpenListeners;
    }

    public void documentOpenListeners_$eq(Set<Function1<OpenedDocument, BoxedUnit>> x$1) {
        this.documentOpenListeners = x$1;
    }

    public Set<Function1<String, BoxedUnit>> documentCloseListeners() {
        return this.documentCloseListeners;
    }

    public void documentCloseListeners_$eq(Set<Function1<String, BoxedUnit>> x$1) {
        this.documentCloseListeners = x$1;
    }

    public Option<IDocumentChangeExecutor> documentChangeExecutor() {
        return this.documentChangeExecutor;
    }

    public void documentChangeExecutor_$eq(Option<IDocumentChangeExecutor> x$1) {
        this.documentChangeExecutor = x$1;
    }

    @Override
    public Future<BoxedUnit> initialize() {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void onChangeDocument(Function1<ChangedDocument, BoxedUnit> listener, boolean unsubscribe) {
        if (unsubscribe) {
            this.documentChangeListeners().remove(listener);
        } else {
            this.documentChangeListeners().add(listener);
        }
    }

    public boolean onChangeDocument$default$2() {
        return false;
    }

    public void onOpenedDocument(Function1<OpenedDocument, BoxedUnit> listener, boolean unsubscribe) {
        if (unsubscribe) {
            this.documentOpenListeners().remove(listener);
        } else {
            this.documentOpenListeners().add(listener);
        }
    }

    public boolean onOpenedDocument$default$2() {
        return false;
    }

    public void onClosedDocument(Function1<String, BoxedUnit> listener, boolean unsubscribe) {
        if (unsubscribe) {
            this.documentCloseListeners().remove(listener);
        } else {
            this.documentCloseListeners().add(listener);
        }
    }

    public boolean onClosedDocument$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Option<TextDocument> getTextDocument(String uri) {
        Option option;
        this.logger().debugDetail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked for uri ", ", while having following editors registered: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})) + this.uriToEditor().keys().mkString(","), "EditorManager", "getTextDocument");
        Option directResult = this.uriToEditor().get((Object)uri);
        if (directResult.isDefined()) {
            option = directResult;
        } else if (uri.startsWith("file://") || uri.startsWith("FILE://")) {
            void var3_3;
            None$ found = None$.MODULE$;
            if (uri.startsWith("file:///") || uri.startsWith("FILE:///")) {
                String path = uri.substring("file:///".length()).replace("%5C", "\\");
                Option result = this.uriToEditor().get((Object)path);
                if (result.isDefined()) {
                    found = result;
                }
            }
            if (found.isEmpty()) {
                String path = uri.substring("file://".length()).replace("%5C", "\\");
                Option result = this.uriToEditor().get((Object)path);
                if (result.isDefined()) {
                    found = result;
                }
            }
            option = var3_3;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void onOpenDocument(OpenedDocument document) {
        this.logger().debug("Document is opened", "EditorManager", "onOpenDocument");
        String language = this.determineLanguage(document.uri(), document.text());
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().update((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), language, syntax, this.logger()));
        this.documentChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.apply((Object)new ChangedDocument(document.uri(), document.version(), (Option<String>)new Some((Object)document.text()), (Option<Seq<TextEdit>>)None$.MODULE$));
            return BoxedUnit.UNIT;
        });
    }

    public void setDocumentChangeExecutor(IDocumentChangeExecutor executor) {
        this.documentChangeExecutor_$eq((Option<IDocumentChangeExecutor>)new Some((Object)executor));
    }

    public Option<IDocumentChangeExecutor> getDocumentChangeExecutor() {
        return this.documentChangeExecutor();
    }

    public void documentWasChanged(ChangedDocument document) {
        Object object = new Object();
        try {
            this.logger().debug("Document is changed", "EditorManager", "onChangeDocument");
            this.logger().debugDetail("Uri is:\n " + document.uri(), "EditorManager", "onChangeDocument");
            this.logger().debugDetail("Text is:\n " + document.text(), "EditorManager", "onChangeDocument");
            this.uriToEditor().get((Object)document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
                TextDocumentManager.$anonfun$documentWasChanged$1(this, document, object, current);
                return BoxedUnit.UNIT;
            });
            String language = this.determineLanguage(document.uri(), (String)document.text().get());
            String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
            this.uriToEditor().update((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), language, syntax, this.logger()));
            this.documentChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                listener.apply((Object)document);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void onCloseDocument(String uri) {
        this.uriToEditor().remove((Object)uri);
    }

    public void onChangePosition(String uri, int position) {
        block0: {
            Option<TextDocument> editorOption = this.getTextDocument(uri);
            if (!editorOption.isDefined()) break block0;
            ((TextDocument)editorOption.get()).setCursorPosition(position);
        }
    }

    public String determineLanguage(String url, String text) {
        return url.endsWith(".raml") ? (text.startsWith("#%RAML 1.0") ? Raml10$.MODULE$.toString() : Raml08$.MODULE$.toString()) : ((url.endsWith(".yaml") || url.endsWith(".yml")) && text.startsWith("#%") ? Aml$.MODULE$.toString() : Oas20$.MODULE$.toString());
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        this.onOpenDocument(new OpenedDocument(params.textDocument().uri(), params.textDocument().version(), params.textDocument().text()));
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.text());
        this.documentWasChanged(new ChangedDocument(document.uri(), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        this.onCloseDocument(params.textDocument().uri());
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(TextDocumentManager $this, ChangedDocument document$2, Object nonLocalReturnKey1$1, TextDocument current) {
        int currentVersion = current.version();
        String currentText = current.text();
        if (currentVersion == document$2.version()) {
            $this.logger().debugDetail("Version of the reported change is equal to the previous one", "EditorManager", "onChangeDocument");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        if (document$2.version() < currentVersion && document$2.text().contains((Object)currentText)) {
            $this.logger().debugDetail("No changes detected", "EditorManager", "onChangeDocument");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public TextDocumentManager(Logger logger, Platform platform) {
        this.logger = logger;
        this.platform = platform;
        this.type = TextDocumentSyncConfigType$.MODULE$;
        this.uriToEditor = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentChangeListeners = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentOpenListeners = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentCloseListeners = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentChangeExecutor = None$.MODULE$;
    }
}

