/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.modules.common;

import java.io.Serializable;
import org.mulesoft.als.common.dtoTypes.Position;
import org.mulesoft.als.common.dtoTypes.Position$;
import org.mulesoft.als.common.dtoTypes.PositionRange;
import org.mulesoft.als.server.modules.common.SearchUtils;
import org.mulesoft.als.server.modules.common.interfaces.ILocation;
import org.mulesoft.high.level.ReferenceSearchResult;
import org.mulesoft.high.level.Search$;
import org.mulesoft.high.level.interfaces.IASTUnit;
import org.mulesoft.high.level.interfaces.IHighLevelNode;
import org.mulesoft.high.level.interfaces.IProject;
import org.mulesoft.typesystem.json.interfaces.NodeRange;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SearchUtils$ {
    public static SearchUtils$ MODULE$;
    private final Seq<Object> breakers;

    static {
        new SearchUtils$();
    }

    private Seq<Object> breakers() {
        return this.breakers;
    }

    public SearchUtils.TextIssue org$mulesoft$als$server$modules$common$SearchUtils$$findTextIssue(String content, int position) {
        int start = position;
        int end = position;
        if (this.isBreaker(end, content)) {
            --end;
        }
        if (this.isBreaker(start, content)) {
            start = end;
        }
        while (start > 0 && !this.isBreaker(start, content)) {
            --start;
        }
        while (end < content.length() && !this.isBreaker(end, content)) {
            ++end;
        }
        return new SearchUtils.TextIssue(content.substring(++start, end), start, end);
    }

    private Seq<SearchUtils.TextIssue> findTextIssues(String content, String label, int searchStart, int searchEnd) {
        ListBuffer issues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int index = content.indexOf(label, searchStart);
        while (index > -1 && index < searchEnd) {
            issues.$plus$eq((Object)this.org$mulesoft$als$server$modules$common$SearchUtils$$findTextIssue(content, index));
            index = content.indexOf(label, index + 1);
        }
        return (Seq)((SeqLike)issues.filter((Function1 & Serializable & scala.Serializable)issue -> BoxesRunTime.boxToBoolean((boolean)SearchUtils$.$anonfun$findTextIssues$1(label, issue)))).distinct();
    }

    private boolean isBreaker(int index, String content) {
        return this.breakers().contains((Object)BoxesRunTime.boxToCharacter((char)content.charAt(index)));
    }

    public Option<Seq<ILocation>> findReferences(IProject project, Position position) {
        return this.findReferences(project, position.offset(project.rootASTUnit().text()));
    }

    public Option<Seq<ILocation>> findReferences(IProject project, int position) {
        None$ none$;
        Option option = Search$.MODULE$.findReferencesByPosition(project.rootASTUnit(), position);
        if (option instanceof Some) {
            Some some = (Some)option;
            ReferenceSearchResult searchResult = (ReferenceSearchResult)some.value();
            ObjectRef result = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            Seq nodes = (Seq)searchResult.references().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SearchUtils$.$anonfun$findReferences$1(x$2)));
            String issueName = this.org$mulesoft$als$server$modules$common$SearchUtils$$findTextIssue(project.rootASTUnit().text(), position).label();
            nodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
                SearchUtils$.$anonfun$findReferences$2(result, issueName, node);
                return BoxedUnit.UNIT;
            });
            none$ = new Some(((ListBuffer)result.elem).sortWith((Function2 & Serializable & scala.Serializable)(l1, l2) -> BoxesRunTime.boxToBoolean((boolean)SearchUtils$.$anonfun$findReferences$4(l1, l2))));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<ILocation>> findDeclaration(IProject project, Position position) {
        None$ none$;
        Option option = Search$.MODULE$.findDefinitionByPosition(project.rootASTUnit(), position);
        if (option instanceof Some) {
            Some some = (Some)option;
            ReferenceSearchResult searchResult = (ReferenceSearchResult)some.value();
            none$ = new Some(((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IHighLevelNode[]{searchResult.definition()}))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sourceInfo().ranges().headOption(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SearchUtils$.$anonfun$findDeclaration$2(x$4)))).map((Function1 & Serializable & scala.Serializable)lowLevelRange -> {
                IASTUnit unit = searchResult.definition().astUnit();
                int start = ((NodeRange)lowLevelRange.get()).start().position();
                int end = start + unit.text().substring(start).indexOf(":");
                return new ILocation(unit, start, end){
                    private final String rawText;
                    private PositionRange posRange;
                    private String uri;
                    private int version;

                    private String rawText() {
                        return this.rawText;
                    }

                    public PositionRange posRange() {
                        return this.posRange;
                    }

                    public void posRange_$eq(PositionRange x$1) {
                        this.posRange = x$1;
                    }

                    public String uri() {
                        return this.uri;
                    }

                    public void uri_$eq(String x$1) {
                        this.uri = x$1;
                    }

                    public int version() {
                        return this.version;
                    }

                    public void version_$eq(int x$1) {
                        this.version = x$1;
                    }
                    {
                        this.rawText = unit$1.text();
                        this.posRange = new PositionRange(Position$.MODULE$.apply(start$1, this.rawText()), Position$.MODULE$.apply(end$1, this.rawText()));
                        this.uri = unit$1.path().replace("file:///", "/");
                        this.version = -1;
                    }
                };
            }, Seq$.MODULE$.canBuildFrom()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<ILocation>> findAll(IProject project, Position position) {
        None$ none$;
        Some some;
        Seq result;
        Option<Seq<ILocation>> option = this.findDeclaration(project, position);
        Object object = option instanceof Some ? ((result = (Seq)(some = (Some)option).value()).isEmpty() ? None$.MODULE$ : new Some((Object)result)) : None$.MODULE$;
        None$ none$2 = object;
        if (none$2 instanceof Some) {
            None$ none$3;
            Some some2 = (Some)none$2;
            Seq result2 = (Seq)some2.value();
            Option<Seq<ILocation>> option2 = this.findReferences(project, ((ILocation)result2.head()).posRange().start().offset(project.rootASTUnit().text()) + 1);
            if (option2 instanceof Some) {
                Some some3 = (Some)option2;
                Seq refs = (Seq)some3.value();
                none$3 = new Some((Object)refs.toBuffer().$plus$eq(result2.head()));
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        } else {
            None$ none$4;
            Option<Seq<ILocation>> option3 = this.findReferences(project, position);
            if (option3 instanceof Some) {
                Some some4 = (Some)option3;
                Seq refs = (Seq)some4.value();
                none$4 = new Some((Object)refs.toBuffer().$plus$eq((Object)new ILocation(project, position){
                    private final String text;
                    private SearchUtils.TextIssue issue;
                    private PositionRange posRange;
                    private String uri;
                    private int version;

                    private String text() {
                        return this.text;
                    }

                    private SearchUtils.TextIssue issue() {
                        return this.issue;
                    }

                    private void issue_$eq(SearchUtils.TextIssue x$1) {
                        this.issue = x$1;
                    }

                    public PositionRange posRange() {
                        return this.posRange;
                    }

                    public void posRange_$eq(PositionRange x$1) {
                        this.posRange = x$1;
                    }

                    public String uri() {
                        return this.uri;
                    }

                    public void uri_$eq(String x$1) {
                        this.uri = x$1;
                    }

                    public int version() {
                        return this.version;
                    }

                    public void version_$eq(int x$1) {
                        this.version = x$1;
                    }
                    {
                        this.text = project$1.rootASTUnit().text();
                        this.issue = SearchUtils$.MODULE$.org$mulesoft$als$server$modules$common$SearchUtils$$findTextIssue(this.text(), position$1.offset(this.text()));
                        this.posRange = new PositionRange(Position$.MODULE$.apply(this.issue().start(), this.text()), Position$.MODULE$.apply(this.issue().end(), this.text()));
                        this.uri = project$1.rootASTUnit().path().replace("file:///", "/");
                        this.version = -1;
                    }
                }));
            } else {
                none$4 = None$.MODULE$;
            }
            none$ = none$4;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$findTextIssues$1(String label$1, SearchUtils.TextIssue issue) {
        String string = issue.label();
        String string2 = label$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findReferences$1(IHighLevelNode x$2) {
        boolean bl;
        Option option = x$2.sourceInfo().ranges().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            NodeRange range = (NodeRange)some.value();
            bl = range.start().resolved();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$findReferences$2(ObjectRef result$1, String issueName$1, IHighLevelNode node) {
        NodeRange nodeRange = (NodeRange)node.sourceInfo().ranges().headOption().get();
        MODULE$.findTextIssues(node.astUnit().text(), issueName$1, nodeRange.start().position(), nodeRange.end().position()).foreach((Function1 & Serializable & scala.Serializable)issue -> ((ListBuffer)result$1.elem).$plus$eq((Object)new ILocation(node, (SearchUtils.TextIssue)issue){
            private final String rawText;
            private PositionRange posRange;
            private String uri;
            private int version;
            private final SearchUtils.TextIssue issue$1;

            private String rawText() {
                return this.rawText;
            }

            public PositionRange posRange() {
                return this.posRange;
            }

            public void posRange_$eq(PositionRange x$1) {
                this.posRange = x$1;
            }

            public String uri() {
                return this.uri;
            }

            public void uri_$eq(String x$1) {
                this.uri = x$1;
            }

            public int version() {
                return this.version;
            }

            public void version_$eq(int x$1) {
                this.version = x$1;
            }

            public String toString() {
                return new StringBuilder(2).append(this.uri()).append("_").append(this.issue$1.start()).append("_").append(this.issue$1.end()).toString();
            }

            public boolean equals(Object obj) {
                return this.toString().equals(obj.toString());
            }

            public int hashCode() {
                return this.toString().hashCode();
            }
            {
                this.issue$1 = issue$1;
                this.rawText = node$1.astUnit().text();
                this.posRange = new PositionRange(Position$.MODULE$.apply(issue$1.start(), this.rawText()), Position$.MODULE$.apply(issue$1.end(), this.rawText()));
                this.uri = node$1.astUnit().path().replace("file:///", "/");
                this.version = -1;
            }
        }));
    }

    public static final /* synthetic */ boolean $anonfun$findReferences$4(ILocation l1, ILocation l2) {
        return l1.posRange().start().$less(l2.posRange().start());
    }

    public static final /* synthetic */ boolean $anonfun$findDeclaration$2(Option x$4) {
        boolean bl;
        Option option = x$4;
        if (option instanceof Some) {
            Some some = (Some)option;
            NodeRange range = (NodeRange)some.value();
            bl = range.start().resolved();
        } else {
            bl = false;
        }
        return bl;
    }

    private SearchUtils$() {
        MODULE$ = this;
        this.breakers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ".", ";", ":", " ", "\"", "'", "{", "}", "[", "]", "/", "|", "\n", "\t", "\r"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)x$1.charAt(0)), Seq$.MODULE$.canBuildFrom());
    }
}

