/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import java.io.Serializable;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.common.interfaces.IEditorTextBuffer;
import org.mulesoft.als.server.modules.common.interfaces.IPoint;
import org.mulesoft.als.server.modules.common.interfaces.IRange;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u00015\u0011a\u0002V3yi\n+hMZ3s\u0013:4wN\u0003\u0002\u0004\t\u0005AA/\u001a=ugft7M\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0007\u0005d7O\u0003\u0002\n\u0015\u0005AQ.\u001e7fg>4GOC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012AC5oi\u0016\u0014h-Y2fg*\u0011\u0011DG\u0001\u0007G>lWn\u001c8\u000b\u0005m!\u0011aB7pIVdWm]\u0005\u0003;Y\u0011\u0011#S#eSR|'\u000fV3yi\n+hMZ3s\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013aA;sSB\u0011\u0011\u0005\u000b\b\u0003E\u0019\u0002\"a\t\t\u000e\u0003\u0011R!!\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\t9\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014\u0011\u0011!a\u0003A!A!\u0002\u0013i\u0013A\u00027pO\u001e,'\u000f\u0005\u0002/a5\tqF\u0003\u0002-\t%\u0011\u0011g\f\u0002\u0007\u0019><w-\u001a:\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\r)t\u0007\u000f\t\u0003m\u0001i\u0011A\u0001\u0005\u0006?I\u0002\r\u0001\t\u0005\u0006YI\u0002\r!\f\u0005\bu\u0001\u0001\r\u0011\"\u0001<\u0003\u0011!X\r\u001f;\u0016\u0003\u0001Bq!\u0010\u0001A\u0002\u0013\u0005a(\u0001\u0005uKb$x\fJ3r)\ty$\t\u0005\u0002\u0010\u0001&\u0011\u0011\t\u0005\u0002\u0005+:LG\u000fC\u0004Dy\u0005\u0005\t\u0019\u0001\u0011\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006K\u0001I\u0001\u0006i\u0016DH\u000f\t\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u0003-a\u0017N\\3MK:<G\u000f[:\u0016\u0003%\u00032AS(R\u001b\u0005Y%B\u0001'N\u0003\u001diW\u000f^1cY\u0016T!A\u0014\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Q\u0017\nY\u0011I\u001d:bs\n+hMZ3s!\ty!+\u0003\u0002T!\t\u0019\u0011J\u001c;\t\u000fU\u0003\u0001\u0019!C\u0001-\u0006yA.\u001b8f\u0019\u0016tw\r\u001e5t?\u0012*\u0017\u000f\u0006\u0002@/\"91\tVA\u0001\u0002\u0004I\u0005BB-\u0001A\u0003&\u0011*\u0001\u0007mS:,G*\u001a8hi\"\u001c\b\u0005C\u0003\\\u0001\u0011\u0005A,\u0001\u0007mS:,')_(gMN,G\u000f\u0006\u0002R;\")aL\u0017a\u0001#\u00061qN\u001a4tKRDQ\u0001\u0019\u0001\u0005\u0002\u0005\f\u0011d\u00195be\u0006\u001cG/\u001a:J]\u0012,\u0007PR8s!>\u001c\u0018\u000e^5p]R\u0011\u0011K\u0019\u0005\u0006G~\u0003\r\u0001Z\u0001\ta>\u001c\u0018\u000e^5p]B\u0011Q#Z\u0005\u0003MZ\u0011a!\u0013)pS:$\b\"\u00025\u0001\t\u0003I\u0017!\u00079pg&$\u0018n\u001c8G_J\u001c\u0005.\u0019:bGR,'/\u00138eKb$\"\u0001\u001a6\t\u000by;\u0007\u0019A)\t\u000b1\u0004A\u0011A7\u0002\u0017I\fgnZ3G_J\u0014vn\u001e\u000b\u0004]F\u001c\bCA\u000bp\u0013\t\u0001hC\u0001\u0004J%\u0006tw-\u001a\u0005\u0006e.\u0004\r!U\u0001\te><\b+\u0019:b[\")Ao\u001ba\u0001k\u0006q\u0011N\\2mk\u0012,g*Z<mS:,\u0007CA\bw\u0013\t9\bCA\u0004C_>dW-\u00198\t\u000be\u0004A\u0011\u0001>\u0002\u001d\u001d,G\u000fV3yi&s'+\u00198hKR\u0011\u0001e\u001f\u0005\u0006yb\u0004\rA\\\u0001\u0006e\u0006tw-\u001a\u0005\u0006}\u0002!\ta`\u0001\u000fg\u0016$H+\u001a=u\u0013:\u0014\u0016M\\4f)\u001dy\u0014\u0011AA\u0002\u0003\u000bAQ\u0001`?A\u00029DQAO?A\u0002\u0001B\u0001\"a\u0002~!\u0003\u0005\r!^\u0001\u0015]>\u0014X.\u00197ju\u0016d\u0015N\\3F]\u0012LgnZ:\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u00059q-\u001a;UKb$H#\u0001\u0011\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005qq-\u001a;F]\u0012\u0004vn]5uS>tG#\u00013\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\u000591/\u001a;UKb$HcA \u0002\u001c!1!(!\u0006A\u0002\u0001Bq!a\b\u0001\t\u0003\t\t#A\u0006j]&$X*\u00199qS:<G#A \t\u0013\u0005\u0015\u0002!%A\u0005B\u0005\u001d\u0012\u0001G:fiR+\u0007\u0010^%o%\u0006tw-\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0006\u0016\u0004k\u0006-2FAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0002#\u0001\u0006b]:|G/\u0019;j_:LA!a\u000f\u00022\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TextBufferInfo
implements IEditorTextBuffer {
    private final Logger logger;
    private String text;
    private ArrayBuffer<Object> lineLengths;

    public String text() {
        return this.text;
    }

    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    public ArrayBuffer<Object> lineLengths() {
        return this.lineLengths;
    }

    public void lineLengths_$eq(ArrayBuffer<Object> x$1) {
        this.lineLengths = x$1;
    }

    @Override
    public int lineByOffset(int offset) {
        int n;
        Object object = new Object();
        try {
            IntRef currentOffset = IntRef.create((int)0);
            this.lineLengths().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                currentOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
                if (currentOffset$1.elem > offset) {
                    throw new NonLocalReturnControl.mcI.sp(object, i);
                }
            });
            n = this.lineLengths().length() - 1;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int characterIndexForPosition(IPoint position) {
        void var3_3;
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), position.row()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int result = lineStartOffset.elem + position.column();
        this.logger.debugDetail(new StringBuilder(34).append("characterIndexForPosition:: [").append(position.row()).append(":").append(position.column()).append("] = ").append(result).toString(), "EditorManager", "TextBufferInfo#characterIndexForPosition");
        return (int)var3_3;
    }

    @Override
    public IPoint positionForCharacterIndex(int offset) {
        IPoint iPoint;
        IntRef pos = IntRef.create((int)offset);
        ObjectRef found = ObjectRef.create((Object)None$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.lineLengths().length()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((Option)found$1.elem).isEmpty()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
            if (pos$1.elem < lineLength) {
                $this.logger.debugDetail(new StringBuilder(31).append("positionForCharacterIndex:").append(offset).append(": [").append(i).append(":").append(pos$1.elem).append("]").toString(), "EditorManager", "TextBufferInfo#positionForCharacterIndex");
                found$1.elem = Option$.MODULE$.apply((Object)new IPoint(i, pos$1.elem));
            }
            pos$1.elem -= lineLength;
        });
        if (((Option)found.elem).isDefined()) {
            iPoint = (IPoint)((Option)found.elem).get();
        } else if (pos.elem == 0) {
            int resultRow = this.lineLengths().length() - 1;
            int resultColumn = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(this.lineLengths().length() - 1));
            this.logger.debugDetail(new StringBuilder(31).append("positionForCharacterIndex:").append(offset).append(": [").append(resultRow).append(":").append(resultColumn).append("]").toString(), "EditorManager", "TextBufferInfo#positionForCharacterIndex");
            iPoint = new IPoint(resultRow, resultColumn);
        } else {
            String errorMessage = new StringBuilder(45).append("Character position exceeds text length: ").append(offset).append(" > + ").append(this.text().length()).toString();
            this.logger.error(errorMessage, "EditorManager", "TextBufferInfo#positionForCharacterIndex");
            throw new Error(errorMessage);
        }
        return iPoint;
    }

    @Override
    public IRange rangeForRow(int rowParam, boolean includeNewline) {
        this.logger.debugDetail(new StringBuilder(18).append("rangeForRow start:").append(rowParam).toString(), "EditorManager", "TextBufferInfo#rangeForRow");
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowParam).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$2.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(rowParam));
        IPoint startPoint = new IPoint(rowParam, 0);
        IPoint endPoint = new IPoint(rowParam, lineLength);
        this.logger.debugDetail(new StringBuilder(28).append("rangeForRow return:").append(rowParam).append(": [").append(startPoint.row()).append(":").append(startPoint.column()).append("]").append(",[").append(endPoint.row()).append(":").append(endPoint.column()).append("]").toString(), "EditorManager", "TextBufferInfo#rangeForRow");
        return new IRange(null, startPoint, endPoint){
            private IPoint start;
            private IPoint end;

            public IPoint start() {
                return this.start;
            }

            public void start_$eq(IPoint x$1) {
                this.start = x$1;
            }

            public IPoint end() {
                return this.end;
            }

            public void end_$eq(IPoint x$1) {
                this.end = x$1;
            }
            {
                this.start = startPoint$1;
                this.end = endPoint$1;
            }
        };
    }

    @Override
    public String getTextInRange(IRange range) {
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        String result = this.text().substring(startOffset, endOffset);
        this.logger.debugDetail(new StringBuilder(24).append("Text in range: [").append(range.start().row()).append(":").append(range.start().column()).append("]").append(",[").append(range.end().row()).append(":").append(range.end().column()).append("]:\n").append(result).toString(), "EditorManager", "TextBufferInfo#getTextInRange");
        return result;
    }

    @Override
    public void setTextInRange(IRange range, String text, boolean normalizeLineEndings) {
        this.logger.debug(new StringBuilder(32).append("Setting text in range: [").append(range.start().row()).append(":").append(range.start().column()).append("] ,").append("[").append(range.end().row()).append(":").append(range.end().column()).append("]\n").append(text).toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        this.logger.debugDetail(new StringBuilder(35).append("Found range in absolute coords: [").append(startOffset).append(":").append(endOffset).append("]").toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        String startText = startOffset > 0 ? this.text().substring(0, startOffset) : "";
        String endText = endOffset < this.text().length() ? this.text().substring(endOffset) : "";
        this.logger.debugDetail(new StringBuilder(15).append("Start text is:\n").append(startText).toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        this.logger.debugDetail(new StringBuilder(13).append("End text is:\n").append(endText).toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        this.setText(new StringBuilder(0).append(startText).append(text).append(endText).toString());
        this.logger.debugDetail(new StringBuilder(15).append("Final text is:\n").append(this.text()).toString(), "EditorManager", "TextBufferInfo#setTextInRange");
    }

    @Override
    public String getText() {
        return this.text();
    }

    @Override
    public IPoint getEndPosition() {
        return this.positionForCharacterIndex(this.text().length() - 1);
    }

    public void setText(String text) {
        this.text_$eq(text);
        this.initMapping();
    }

    @Override
    public boolean setTextInRange$default$3() {
        return false;
    }

    public void initMapping() {
        this.lineLengths_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        IntRef ind = IntRef.create((int)0);
        int l = this.text().length();
        BooleanRef ignoreNext = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), l).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block3: {
                block4: {
                    block2: {
                        if (!ignoreNext$1.elem) break block2;
                        ignoreNext$1.elem = false;
                        break block3;
                    }
                    ignoreNext$1.elem = false;
                    if (this.text().charAt(i) != '\r') break block4;
                    if (i < l - 1 && this.text().charAt(i + 1) == '\n') {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 2)));
                        ind$1.elem = i + 2;
                        ignoreNext$1.elem = true;
                    } else {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                        ind$1.elem = i + 1;
                    }
                    break block3;
                }
                if (this.text().charAt(i) != '\n') break block3;
                this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                ind$1.elem = i + 1;
            }
        });
        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(l - ind.elem)));
    }

    public TextBufferInfo(String uri, Logger logger) {
        this.logger = logger;
        this.text = "";
        this.lineLengths = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

