/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import java.io.Serializable;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.FOCUS_FILE$;
import org.mulesoft.als.server.modules.ast.OPEN_FILE$;
import org.mulesoft.als.server.modules.ast.TextListener;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.als.server.textsync.TextDocumentContainer;
import org.mulesoft.lsp.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.edit.TextEdit;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidFocusParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncConsumer;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u000b\u0017\u0001\u0005B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005M\u0001\t\u0005\t\u0015!\u00039\u0011!i\u0005A!b\u0001\n\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bU\u0003A\u0011\u0001,\t\u000fm\u0003!\u0019!C!9\"1\u0001\r\u0001Q\u0001\nuCQ!\u0019\u0001\u0005B\tDq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\n\u0019B+\u001a=u\t>\u001cW/\\3oi6\u000bg.Y4fe*\u0011q\u0003G\u0001\ti\u0016DHo]=oG*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005ma\u0012aA1mg*\u0011QDH\u0001\t[VdWm]8gi*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015.\u001b\u0005Q#BA\f,\u0015\taC$A\u0002mgBL!A\f\u0016\u00031Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7i\u001c8tk6,'/A\u0006ve&$v.\u00123ji>\u0014X#A\u0019\u0011\u0005I\u001aT\"\u0001\f\n\u0005Q2\"!\u0006+fqR$unY;nK:$8i\u001c8uC&tWM]\u0001\rkJLGk\\#eSR|'\u000fI\u0001\rI\u0016\u0004XM\u001c3f]\u000eLWm]\u000b\u0002qA\u0019\u0011(\u0011#\u000f\u0005izdBA\u001e?\u001b\u0005a$BA\u001f!\u0003\u0019a$o\\8u}%\tQ%\u0003\u0002AI\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"D\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0001#\u0003CA#K\u001b\u00051%BA$I\u0003\r\t7\u000f\u001e\u0006\u0003\u0013b\tq!\\8ek2,7/\u0003\u0002L\r\naA+\u001a=u\u0019&\u001cH/\u001a8fe\u0006iA-\u001a9f]\u0012,gnY5fg\u0002\na\u0001\\8hO\u0016\u0014X#A(\u0011\u0005A\u0013V\"A)\u000b\u00055C\u0012BA*R\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003X1fS\u0006C\u0001\u001a\u0001\u0011\u0015ys\u00011\u00012\u0011\u00151t\u00011\u00019\u0011\u0015iu\u00011\u0001P\u0003\u0011!\u0018\u0010]3\u0016\u0003us!!\u000b0\n\u0005}S\u0013A\u0007+fqR$unY;nK:$8+\u001f8d\u0007>tg-[4UsB,\u0017!\u0002;za\u0016\u0004\u0013aC1qa2L8i\u001c8gS\u001e$\"a\u0019=\u0011\te\"g-^\u0005\u0003K\u000e\u0013a!R5uQ\u0016\u0014\bCA4s\u001d\tA\u0007O\u0004\u0002j_:\u0011!N\u001c\b\u0003W6t!a\u000f7\n\u0003}I!!\b\u0010\n\u00051b\u0012BA\f,\u0013\t\t(&\u0001\u000bUKb$Hi\\2v[\u0016tGoU=oG.Kg\u000eZ\u0005\u0003gR\u0014A\u0003V3yi\u0012{7-^7f]R\u001c\u0016P\\2LS:$'BA9+!\tIc/\u0003\u0002xU\t9B+\u001a=u\t>\u001cW/\\3oiNKhnY(qi&|gn\u001d\u0005\u0006s*\u0001\rA_\u0001\u0007G>tg-[4\u0011\u0007\rZX0\u0003\u0002}I\t1q\n\u001d;j_:\u0004\"!\u000b@\n\u0005}T#!I*z]\u000eD'o\u001c8ju\u0006$\u0018n\u001c8DY&,g\u000e^\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\u0018AC5oSRL\u0017\r\\5{KR\u0011\u0011Q\u0001\t\u0007\u0003\u000f\ti!!\u0005\u000e\u0005\u0005%!bAA\u0006I\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005=\u0011\u0011\u0002\u0002\u0007\rV$XO]3\u0011\u0007\r\n\u0019\"C\u0002\u0002\u0016\u0011\u0012A!\u00168ji\u0006qqN\\(qK:$unY;nK:$H\u0003BA\t\u00037Aq!!\b\r\u0001\u0004\ty\"\u0001\u0005e_\u000e,X.\u001a8u!\r\u0011\u0014\u0011E\u0005\u0004\u0003G1\"AD(qK:,G\rR8dk6,g\u000e^\u0001\u0013I>\u001cW/\\3oi^\u000b7o\u00115b]\u001e,G\r\u0006\u0003\u0002\u0012\u0005%\u0002bBA\u000f\u001b\u0001\u0007\u00111\u0006\t\u0004e\u00055\u0012bAA\u0018-\ty1\t[1oO\u0016$Gi\\2v[\u0016tG/A\bp]\u000ecwn]3E_\u000e,X.\u001a8u)\u0011\t\t\"!\u000e\t\u000f\u0005]b\u00021\u0001\u0002:\u0005\u0019QO]5\u0011\t\u0005m\u00121\t\b\u0005\u0003{\ty\u0004\u0005\u0002<I%\u0019\u0011\u0011\t\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t)%a\u0012\u0003\rM#(/\u001b8h\u0015\r\t\t\u0005J\u0001\u0011_:\u001c\u0005.\u00198hKB{7/\u001b;j_:$b!!\u0005\u0002N\u0005=\u0003bBA\u001c\u001f\u0001\u0007\u0011\u0011\b\u0005\b\u0003#z\u0001\u0019AA*\u0003!\u0001xn]5uS>t\u0007cA\u0012\u0002V%\u0019\u0011q\u000b\u0013\u0003\u0007%sG/A\beKR,'/\\5oKNKh\u000e^1y)\u0019\tI$!\u0018\u0002b!9\u0011q\f\tA\u0002\u0005e\u0012aA;sY\"9\u00111\r\tA\u0002\u0005e\u0012\u0001\u0002;fqR\fq\u0001Z5e\u001fB,g\u000e\u0006\u0003\u0002\u0012\u0005%\u0004bBA6#\u0001\u0007\u0011QN\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0007%\ny'C\u0002\u0002r)\u0012\u0011\u0004R5e\u001fB,g\u000eV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006IA-\u001b3DQ\u0006tw-\u001a\u000b\u0005\u0003#\t9\bC\u0004\u0002lI\u0001\r!!\u001f\u0011\u0007%\nY(C\u0002\u0002~)\u00121\u0004R5e\u0007\"\fgnZ3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018\u0001\u00033jI\u000ecwn]3\u0015\t\u0005E\u00111\u0011\u0005\b\u0003W\u001a\u0002\u0019AAC!\rI\u0013qQ\u0005\u0004\u0003\u0013S#A\u0007#jI\u000ecwn]3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018\u0001\u00033jI\u001a{7-^:\u0015\t\u0005E\u0011q\u0012\u0005\b\u0003W\"\u0002\u0019AAI!\rI\u00131S\u0005\u0004\u0003+S#A\u0004#jI\u001a{7-^:QCJ\fWn\u001d")
public class TextDocumentManager
implements TextDocumentSyncConsumer {
    private final TextDocumentContainer uriToEditor;
    private final List<TextListener> dependencies;
    private final Logger logger;
    private final TextDocumentSyncConfigType$ type;

    public TextDocumentContainer uriToEditor() {
        return this.uriToEditor;
    }

    public List<TextListener> dependencies() {
        return this.dependencies;
    }

    private Logger logger() {
        return this.logger;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        this.logger().debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$1 = None$.MODULE$;
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$3 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option x$4 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option)x$2, (Option)x$3, x$4, x$5, (Option)x$1));
    }

    public Future<BoxedUnit> initialize() {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void onOpenDocument(OpenedDocument document) {
        this.logger().debug("Document is opened", "EditorManager", "onOpenDocument");
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), syntax, this.logger())));
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.notify(document.uri(), OPEN_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void documentWasChanged(ChangedDocument document) {
        Object object = new Object();
        try {
            this.logger().debug("Document is changed", "EditorManager", "onChangeDocument");
            this.logger().debugDetail(new StringBuilder(9).append("Uri is:\n ").append(document.uri()).toString(), "EditorManager", "onChangeDocument");
            this.logger().debugDetail(new StringBuilder(10).append("Text is:\n ").append(document.text()).toString(), "EditorManager", "onChangeDocument");
            this.uriToEditor().get(document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
                TextDocumentManager.$anonfun$documentWasChanged$1(this, document, object, current);
                return BoxedUnit.UNIT;
            });
            String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
            this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), syntax, this.logger())));
            this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.notify(document.uri(), CHANGE_FILE$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void onCloseDocument(String uri) {
        this.uriToEditor().remove(uri);
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.notify(uri, CLOSE_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void onChangePosition(String uri, int position) {
        this.uriToEditor().get(uri).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.setCursorPosition(position);
            return BoxedUnit.UNIT;
        });
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.onOpenDocument(new OpenedDocument(params.textDocument().uri(), params.textDocument().version(), params.textDocument().text()));
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.text());
        this.documentWasChanged(new ChangedDocument(document.uri(), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.onCloseDocument(params.textDocument().uri());
    }

    public void didFocus(DidFocusParams params) {
        this.uriToEditor().get(params.uri()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            TextDocumentManager.$anonfun$didFocus$1(this, params, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(TextDocumentManager $this, ChangedDocument document$2, Object nonLocalReturnKey1$1, TextDocument current) {
        int currentVersion = current.version();
        String currentText = current.text();
        if (currentVersion == document$2.version()) {
            $this.logger().debugDetail("Version of the reported change is equal to the previous one", "EditorManager", "onChangeDocument");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        if (document$2.version() < currentVersion && document$2.text().contains((Object)currentText)) {
            $this.logger().debugDetail("No changes detected", "EditorManager", "onChangeDocument");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ void $anonfun$didFocus$1(TextDocumentManager $this, DidFocusParams params$1, TextDocument x$6) {
        $this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.notify(params$1.uri(), FOCUS_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public TextDocumentManager(TextDocumentContainer uriToEditor, List<TextListener> dependencies, Logger logger) {
        this.uriToEditor = uriToEditor;
        this.dependencies = dependencies;
        this.logger = logger;
        this.type = TextDocumentSyncConfigType$.MODULE$;
    }
}

