package org.mulesoft.als.server.lsp4j

import java.util.concurrent.CompletableFuture

import org.eclipse.lsp4j.services.WorkspaceService
import org.eclipse.lsp4j.{DidChangeConfigurationParams, DidChangeWatchedFilesParams, ExecuteCommandParams}
import org.mulesoft.lsp.server.{LanguageServer => lspLanguageServer}
import org.mulesoft.lsp.workspace.{ExecuteCommandParams => InternalCommandParams}

import scala.collection.JavaConverters._
import scala.compat.java8.FutureConverters._

class WorkspaceServiceImpl(private val inner: lspLanguageServer) extends WorkspaceService {
  private val workspaceService = inner.workspaceService

  override def didChangeConfiguration(params: DidChangeConfigurationParams): Unit = {}

  override def didChangeWatchedFiles(params: DidChangeWatchedFilesParams): Unit = {}

  override def executeCommand(params: ExecuteCommandParams): CompletableFuture[Object] = {
    val internal = InternalCommandParams(params.getCommand, params.getArguments.asScala.toList.map(_.toString))
    workspaceService.executeCommand(internal).toJava.toCompletableFuture
  }
}