/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.modules.workspace;

import amf.internal.environment.Environment;
import java.io.Serializable;
import java.util.UUID;
import org.mulesoft.als.common.FileUtils$;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.ast.BaseUnitListener;
import org.mulesoft.als.server.modules.ast.CHANGE_CONFIG$;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.NotificationKind;
import org.mulesoft.als.server.modules.ast.WORKSPACE_TERMINATED$;
import org.mulesoft.als.server.modules.workspace.CompilableUnit;
import org.mulesoft.als.server.modules.workspace.Idle$;
import org.mulesoft.als.server.modules.workspace.NotAvailable$;
import org.mulesoft.als.server.modules.workspace.ParsedUnit;
import org.mulesoft.als.server.modules.workspace.ProcessingFile;
import org.mulesoft.als.server.modules.workspace.ProcessingProject$;
import org.mulesoft.als.server.modules.workspace.Repository;
import org.mulesoft.als.server.modules.workspace.Snapshot;
import org.mulesoft.als.server.modules.workspace.StagingArea;
import org.mulesoft.als.server.modules.workspace.UnavailableWorkspaceException;
import org.mulesoft.als.server.modules.workspace.UnitNotFoundException;
import org.mulesoft.als.server.modules.workspace.WorkspaceState;
import org.mulesoft.als.server.textsync.EnvironmentProvider;
import org.mulesoft.als.server.workspace.extract.WorkspaceConf;
import org.mulesoft.als.server.workspace.extract.WorkspaceConfigurationProvider;
import org.mulesoft.amfmanager.AmfParseResult;
import org.mulesoft.lsp.feature.telemetry.MessageTypes$;
import org.mulesoft.lsp.feature.telemetry.TelemetryProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u001b7\u0001\rC\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!I\u00111\u0003\u0001A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003;\u0001\u0001\u0019!C\u0005\u0003?A\u0001\"a\u000b\u0001A\u0003&\u0011q\u0003\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0011\"!\u0012\u0001\u0001\u0004%I!a\u0012\t\u0011\u0005-\u0003\u0001)Q\u0005\u0003cAq!!\u0014\u0001\t\u0003\ty\u0003C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011Q\f\u0001\u0005\u0002\u0005e\u0003\"CA0\u0001\t\u0007I\u0011BA1\u0011!\tI\u0007\u0001Q\u0001\n\u0005\r\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0007C\u0001\"a#\u0001A\u0003%\u0011Q\u0011\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0005\u0003\u001fC\u0011\"!(\u0001\u0001\u0004%I!a(\t\u0011\u0005\r\u0006\u0001)Q\u0005\u0003#C\u0011\"!*\u0001\u0001\u0004%I!a*\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005M\u0006\u0002CA\\\u0001\u0001\u0006K!!+\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!a<\u0001\t\u0003\t\t\u0010C\u0004\u0002x\u0002!I!!<\t\u000f\u0005e\b\u0001\"\u0003\u0002n\"9\u00111 \u0001\u0005\n\u0005u\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011\u001d\u0011i\u0002\u0001C\u0005\u0003[DqAa\b\u0001\t\u0013\u0011\t\u0003C\u0005\u0003(\u0001\u0011\r\u0011\"\u0003\u0003*!A!\u0011\u0007\u0001!\u0002\u0013\u0011Y\u0003C\u0004\u00034\u0001!I!!<\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!q\t\u0001\u0005\n\t%\u0003b\u0002B+\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003n\u0001!IAa\u001c\t\u000f\tU\u0004\u0001\"\u0003\u0003x\t9rk\u001c:lgB\f7-Z\"p]R,g\u000e^'b]\u0006<WM\u001d\u0006\u0003oa\n\u0011b^8sWN\u0004\u0018mY3\u000b\u0005eR\u0014aB7pIVdWm\u001d\u0006\u0003wq\naa]3sm\u0016\u0014(BA\u001f?\u0003\r\tGn\u001d\u0006\u0003\u007f\u0001\u000b\u0001\"\\;mKN|g\r\u001e\u0006\u0002\u0003\u0006\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0019|G\u000eZ3s+\u0005a\u0005CA'U\u001d\tq%\u000b\u0005\u0002P\r6\t\u0001K\u0003\u0002R\u0005\u00061AH]8pizJ!a\u0015$\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'\u001a\u000bqAZ8mI\u0016\u0014\b%A\nf]ZL'o\u001c8nK:$\bK]8wS\u0012,'\u000f\u0005\u0002[;6\t1L\u0003\u0002]u\u0005AA/\u001a=ugft7-\u0003\u0002_7\n\u0019RI\u001c<je>tW.\u001a8u!J|g/\u001b3fe\u0006\tB/\u001a7f[\u0016$(/\u001f)s_ZLG-\u001a:\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017!\u0003;fY\u0016lW\r\u001e:z\u0015\t)g-A\u0004gK\u0006$XO]3\u000b\u0005\u001dt\u0014a\u00017ta&\u0011\u0011N\u0019\u0002\u0012)\u0016dW-\\3uef\u0004&o\u001c<jI\u0016\u0014\u0018A\u00027pO\u001e,'\u000f\u0005\u0002m]6\tQN\u0003\u0002ku%\u0011q.\u001c\u0002\u0007\u0019><w-\u001a:\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:\u0011\u0007I<(P\u0004\u0002tk:\u0011q\n^\u0005\u0002\u000f&\u0011aOR\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018P\u0001\u0003MSN$(B\u0001<G!\tYh0D\u0001}\u0015\ti\b(A\u0002bgRL!a ?\u0003!\t\u000b7/Z+oSRd\u0015n\u001d;f]\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u0006\u0005%\u00111BA\u0007\u0003\u001f\t\t\u0002E\u0002\u0002\b\u0001i\u0011A\u000e\u0005\u0006\u0015\u001e\u0001\r\u0001\u0014\u0005\u00061\u001e\u0001\r!\u0017\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0005\u0006U\u001e\u0001\ra\u001b\u0005\u0006a\u001e\u0001\r!]\u0001\u0006gR\fG/Z\u000b\u0003\u0003/\u0001B!a\u0002\u0002\u001a%\u0019\u00111\u0004\u001c\u0003\u001d]{'o[:qC\u000e,7\u000b^1uK\u0006I1\u000f^1uK~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u0002F\u0003GI1!!\nG\u0005\u0011)f.\u001b;\t\u0013\u0005%\u0012\"!AA\u0002\u0005]\u0011a\u0001=%c\u000511\u000f^1uK\u0002\nabY8oM&<W*Y5o\r&dW-\u0006\u0002\u00022A)Q)a\r\u00028%\u0019\u0011Q\u0007$\u0003\r=\u0003H/[8o!\u0011\tI$!\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\tq!\u001a=ue\u0006\u001cGO\u0003\u00028u%!\u00111IA\u001e\u000559vN]6ta\u0006\u001cWmQ8oM\u0006\u00112m\u001c8gS\u001el\u0015-\u001b8GS2,w\fJ3r)\u0011\t\t#!\u0013\t\u0013\u0005%B\"!AA\u0002\u0005E\u0012aD2p]\u001aLw-T1j]\u001aKG.\u001a\u0011\u0002-]|'o[:qC\u000e,7i\u001c8gS\u001e,(/\u0019;j_:\f\u0011c]3u\u0007>tg-[4NC&tg)\u001b7f)\u0011\t\t#a\u0015\t\u000f\u0005Us\u00021\u0001\u00022\u0005iqo\u001c:lgB\f7-Z\"p]\u001a\f\u0001\"\\1j]\u001aKG.Z\u000b\u0003\u00037\u0002B!RA\u001a\u0019\u0006Q1m\u001c8gS\u001e4\u0015\u000e\\3\u0002\u0017M$\u0018mZ5oO\u0006\u0013X-Y\u000b\u0003\u0003G\u0002B!a\u0002\u0002f%\u0019\u0011q\r\u001c\u0003\u0017M#\u0018mZ5oO\u0006\u0013X-Y\u0001\rgR\fw-\u001b8h\u0003J,\u0017\rI\u0001\fK:4\u0018N]8o[\u0016tG/\u0006\u0002\u0002pA!\u0011\u0011OA?\u001b\t\t\u0019H\u0003\u0003\u0002l\u0005U$\u0002BA<\u0003s\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0003w\n1!Y7g\u0013\u0011\ty(a\u001d\u0003\u0017\u0015sg/\u001b:p]6,g\u000e^\u0001\u000be\u0016\u0004xn]5u_JLXCAAC!\u0011\t9!a\"\n\u0007\u0005%eG\u0001\u0006SKB|7/\u001b;pef\f1B]3q_NLGo\u001c:zA\u000591-\u001e:sK:$XCAAI!\u0019\t\u0019*!'\u0002\"5\u0011\u0011Q\u0013\u0006\u0004\u0003/3\u0015AC2p]\u000e,(O]3oi&!\u00111TAK\u0005\u00191U\u000f^;sK\u0006Y1-\u001e:sK:$x\fJ3r)\u0011\t\t#!)\t\u0013\u0005%\u0002$!AA\u0002\u0005E\u0015\u0001C2veJ,g\u000e\u001e\u0011\u0002=]|'o[:qC\u000e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014XCAAU!\u0015)\u00151GAV!\u0011\tI$!,\n\t\u0005=\u00161\b\u0002\u001f/>\u00148n\u001d9bG\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0013xN^5eKJ\f!e^8sWN\u0004\u0018mY3D_:4\u0017nZ;sCRLwN\u001c)s_ZLG-\u001a:`I\u0015\fH\u0003BA\u0011\u0003kC\u0011\"!\u000b\u001c\u0003\u0003\u0005\r!!+\u0002?]|'o[:qC\u000e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0006dC:\u0004&o\\2fgN,\"!!0\u0011\u0007\u0015\u000by,C\u0002\u0002B\u001a\u0013qAQ8pY\u0016\fg.A\u0006dQ\u0006tw-\u001a3GS2,GCBA\u0011\u0003\u000f\fY\r\u0003\u0004\u0002Jz\u0001\r\u0001T\u0001\u0004kJL\u0007bBAg=\u0001\u0007\u0011qZ\u0001\u0005W&tG\rE\u0002|\u0003#L1!a5}\u0005Aqu\u000e^5gS\u000e\fG/[8o\u0017&tG-A\thKR\u001cu.\u001c9jY\u0006\u0014G.Z+oSR$B!!7\u0002bB1\u00111SAM\u00037\u0004B!a\u0002\u0002^&\u0019\u0011q\u001c\u001c\u0003\u001d\r{W\u000e]5mC\ndW-\u00168ji\"1\u0011\u0011Z\u0010A\u00021\u000bAA\\3yiR!\u0011\u0011SAt\u0011\u001d\tI\u000f\ta\u0001\u0003#\u000b\u0011AZ\u0001\baJ|7-Z:t)\t\t\t*A\txSRD7i\u001c8gS\u001e,(/\u0019;j_:$B!!\u0002\u0002t\"9\u0011Q\u001f\u0012A\u0002\u0005-\u0016\u0001D2p]\u001a\u0004&o\u001c<jI\u0016\u0014\u0018A\u00059sKB\u0014xnY3tgNs\u0017\r]:i_R\fq\u0002\u001d:pG\u0016\u001c8o\u00158baNDw\u000e^\u0001\u0015Q\u0006\u001c8\t[1oO\u0016$7i\u001c8gS\u001e4\u0015\u000e\\3\u0015\t\u0005u\u0016q \u0005\b\u0005\u0003)\u0003\u0019\u0001B\u0002\u0003!\u0019h.\u00199tQ>$\b\u0003BA\u0004\u0005\u000bI1Aa\u00027\u0005!\u0019f.\u00199tQ>$\u0018\u0001\u00024bS2$BA!\u0004\u0003\u0014A\u0019QIa\u0004\n\u0007\tEaIA\u0004O_RD\u0017N\\4\t\r\u0005%g\u00051\u0001M\u0003\u001d9W\r\u001e(fqR$BA!\u0007\u0003\u001cA)Q)a\r\u0002Z\"1\u0011\u0011Z\u0014A\u00021\u000baaZ8JI2,\u0017aC2iC:<Wm\u0015;bi\u0016$B!!\t\u0003$!9!QE\u0015A\u0002\u0005]\u0011\u0001\u00038foN#\u0018\r^3\u0002\u0015%\u001cH)[:bE2,G-\u0006\u0002\u0003,A1\u00111\u0013B\u0017\u0003CIAAa\f\u0002\u0016\n9\u0001K]8nSN,\u0017aC5t\t&\u001c\u0018M\u00197fI\u0002\nq\u0001Z5tC\ndW-\u0001\fqe>\u001cWm]:Jg>d\u0017\r^3e\u0007\"\fgnZ3t)\u0019\t\tJ!\u000f\u0003F!9!1H\u0017A\u0002\tu\u0012!\u00024jY\u0016\u001c\b\u0003\u0002:x\u0005\u007f\u0001b!\u0012B!\u0019\u0006=\u0017b\u0001B\"\r\n1A+\u001e9mKJBq!a\u001b.\u0001\u0004\ty'A\bqe>\u001cWm]:Jg>d\u0017\r^3e)!\t\tJa\u0013\u0003P\tE\u0003B\u0002B']\u0001\u0007A*\u0001\u0003gS2,\u0007bBA6]\u0001\u0007\u0011q\u000e\u0005\u0007\u0005'r\u0003\u0019\u0001'\u0002\tU,\u0018\u000eZ\u0001\tg\",H\u000fZ8x]\u0006Q1\r\\3b]\u001aKG.Z:\u0015\t\u0005\u0005\"1\f\u0005\b\u0005;\u0002\u0004\u0019\u0001B\u001f\u0003-\u0019Gn\\:fI\u001aKG.Z:\u00025A\u0014xnY3tg\u000eC\u0017M\\4f\u0007>tg-[4DQ\u0006tw-Z:\u0015\t\u0005E%1\r\u0005\b\u0005\u0003\t\u0004\u0019\u0001B\u0002\u0003M\u0001(o\\2fgN\u001c\u0005.\u00198hK\u000e{gNZ5h)\u0011\t\tJ!\u001b\t\u000f\t-$\u00071\u0001\u00022\u0005YQ.Y=cK\u000e{gNZ5h\u0003A\u0001(o\\2fgNlei\u00115b]\u001e,7\u000f\u0006\u0004\u0002\u0012\nE$1\u000f\u0005\u0007\u0003/\u001a\u0004\u0019\u0001'\t\u000f\t\u00051\u00071\u0001\u0003\u0004\u0005)\u0001/\u0019:tKRA!\u0011\u0010BD\u0005\u0013\u0013Y\t\u0005\u0004\u0002\u0014\u0006e%1\u0010\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)\u0019!\u0011\u0011 \u0002\u0015\u0005lg-\\1oC\u001e,'/\u0003\u0003\u0003\u0006\n}$AD!nMB\u000b'o]3SKN,H\u000e\u001e\u0005\u0007\u0003\u0013$\u0004\u0019\u0001'\t\u000f\u0005-D\u00071\u0001\u0002p!1!1\u000b\u001bA\u00021\u0003")
public class WorkspaceContentManager {
    private final String folder;
    private final EnvironmentProvider environmentProvider;
    private final TelemetryProvider telemetryProvider;
    public final Logger org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger;
    private final List<BaseUnitListener> dependencies;
    private WorkspaceState state;
    private Option<WorkspaceConf> configMainFile;
    private final StagingArea stagingArea;
    private final Repository repository;
    private Future<BoxedUnit> current;
    private Option<WorkspaceConfigurationProvider> workspaceConfigurationProvider;
    private final Promise<BoxedUnit> isDisabled;

    public String folder() {
        return this.folder;
    }

    private WorkspaceState state() {
        return this.state;
    }

    private void state_$eq(WorkspaceState x$1) {
        this.state = x$1;
    }

    private Option<WorkspaceConf> configMainFile() {
        return this.configMainFile;
    }

    private void configMainFile_$eq(Option<WorkspaceConf> x$1) {
        this.configMainFile = x$1;
    }

    public Option<WorkspaceConf> workspaceConfiguration() {
        return this.configMainFile();
    }

    public void setConfigMainFile(Option<WorkspaceConf> workspaceConf) {
        this.repository().cleanTree();
        this.repository().setCachables((Set<String>)((Set)workspaceConf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.cachables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        this.configMainFile_$eq(workspaceConf);
    }

    public Option<String> mainFile() {
        return this.configMainFile().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mainFile());
    }

    public Option<String> configFile() {
        return this.configMainFile().flatMap((Function1 & Serializable & scala.Serializable)ic -> ic.configReader().map((Function1 & Serializable & scala.Serializable)cr -> new StringBuilder(1).append(ic.rootFolder()).append("/").append(cr.configFileName()).toString()));
    }

    private StagingArea stagingArea() {
        return this.stagingArea;
    }

    public Environment environment() {
        return this.stagingArea().snapshot().environment();
    }

    private Repository repository() {
        return this.repository;
    }

    private Future<BoxedUnit> current() {
        return this.current;
    }

    private void current_$eq(Future<BoxedUnit> x$1) {
        this.current = x$1;
    }

    private Option<WorkspaceConfigurationProvider> workspaceConfigurationProvider() {
        return this.workspaceConfigurationProvider;
    }

    private void workspaceConfigurationProvider_$eq(Option<WorkspaceConfigurationProvider> x$1) {
        this.workspaceConfigurationProvider = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canProcess() {
        WorkspaceState workspaceState = this.state();
        Idle$ idle$ = Idle$.MODULE$;
        if (workspaceState == null) {
            if (idle$ != null) {
                return false;
            }
        } else if (!workspaceState.equals(idle$)) return false;
        Future<BoxedUnit> future = this.current();
        Future future2 = Future$.MODULE$.unit();
        if (future == null) {
            if (future2 == null) return true;
            return false;
        } else {
            if (!future.equals((Object)future2)) return false;
            return true;
        }
    }

    public synchronized void changedFile(String uri, NotificationKind kind) {
        block1: {
            WorkspaceState workspaceState = this.state();
            NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
            if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
                throw new UnavailableWorkspaceException();
            }
            this.stagingArea().enqueue(uri, kind);
            if (!this.canProcess()) break block1;
            this.current_$eq(this.process());
        }
    }

    public Future<CompilableUnit> getCompilableUnit(String uri) {
        Future future;
        String encodedUri = FileUtils$.MODULE$.getEncodedUri(uri, this.environmentProvider.platform());
        Option<ParsedUnit> option = this.repository().getParsed(encodedUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            ParsedUnit pu = (ParsedUnit)some.value();
            WorkspaceState workspaceState = this.state();
            NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
            future = Future$.MODULE$.successful((Object)pu.toCU(this.getNext(encodedUri), this.mainFile(), this.repository().getReferenceStack(encodedUri), !(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)));
        } else {
            future = (Future)this.getNext(encodedUri).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(encodedUri));
        }
        return future;
    }

    private Future<BoxedUnit> next(Future<BoxedUnit> f) {
        return f.recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkspaceContentManager $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger.error(A1.getMessage(), "WorkspaceContentManager", "Processing request");
                Future future = Future$.MODULE$.successful((Object)Unit$.MODULE$);
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)u -> {
            this.current_$eq(this.process());
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> process() {
        WorkspaceState workspaceState = this.state();
        NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
        if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
            throw new UnavailableWorkspaceException();
        }
        return this.stagingArea().isPending() ? this.next(this.preprocessSnapshot()) : this.goIdle();
    }

    public WorkspaceContentManager withConfiguration(WorkspaceConfigurationProvider confProvider) {
        this.workspaceConfigurationProvider_$eq((Option<WorkspaceConfigurationProvider>)new Some((Object)confProvider));
        return this;
    }

    private Future<BoxedUnit> preprocessSnapshot() {
        return this.stagingArea().shouldDie() ? this.disable() : this.processSnapshot();
    }

    private Future<BoxedUnit> processSnapshot() {
        Snapshot snapshot = this.stagingArea().snapshot();
        Tuple2 tuple2 = snapshot.files().partition((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processSnapshot$1(this, u)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List treeUnits = (List)tuple2._1();
        List isolated = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)treeUnits, (Object)isolated);
        Tuple2 tuple23 = tuple22;
        List treeUnits2 = (List)tuple23._1();
        List isolated2 = (List)tuple23._2();
        List changedTreeUnits = (List)treeUnits2.filter((Function1 & Serializable & scala.Serializable)tu -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processSnapshot$2(tu)));
        return this.hasChangedConfigFile(snapshot) ? this.processChangeConfigChanges(snapshot) : (changedTreeUnits.nonEmpty() ? this.processMFChanges(((WorkspaceConf)this.configMainFile().get()).mainFile(), snapshot) : this.processIsolatedChanges((List<Tuple2<String, NotificationKind>>)isolated2, snapshot.environment()));
    }

    private boolean hasChangedConfigFile(Snapshot snapshot) {
        return ((LinearSeqOptimized)snapshot.files().map((Function1 & Serializable & scala.Serializable)x$4 -> (NotificationKind)x$4._2(), List$.MODULE$.canBuildFrom())).contains((Object)CHANGE_CONFIG$.MODULE$);
    }

    private Nothing$ fail(String uri) {
        throw new UnitNotFoundException(uri);
    }

    private Option<Future<CompilableUnit>> getNext(String uri) {
        Future<BoxedUnit> future = this.current();
        Future future2 = Future$.MODULE$.unit();
        Future<BoxedUnit> future3 = future;
        Object object = !(future2 != null ? !future2.equals(future3) : future3 != null) ? None$.MODULE$ : new Some((Object)this.current().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> this.getCompilableUnit(uri), ExecutionContext.Implicits$.MODULE$.global()));
        return object;
    }

    private Future<BoxedUnit> goIdle() {
        this.changeState(Idle$.MODULE$);
        return Future$.MODULE$.unit();
    }

    private synchronized void changeState(WorkspaceState newState) {
        WorkspaceState workspaceState = this.state();
        NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
        if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
            throw new UnavailableWorkspaceException();
        }
        this.state_$eq(newState);
    }

    private Promise<BoxedUnit> isDisabled() {
        return this.isDisabled;
    }

    private Future<BoxedUnit> disable() {
        this.changeState(NotAvailable$.MODULE$);
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)$this.dependencies.map((Function1 & Serializable & scala.Serializable)d -> {
            WorkspaceContentManager.$anonfun$disable$2(this, d);
            return BoxedUnit.UNIT;
        }, List$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            WorkspaceContentManager.$anonfun$disable$4(this, x$6);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> processIsolatedChanges(List<Tuple2<String, NotificationKind>> files, Environment environment) {
        Tuple2 tuple2 = files.partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processIsolatedChanges$1(x$7)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List closedFiles = (List)tuple2._1();
        List changedFiles = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)closedFiles, (Object)changedFiles);
        Tuple2 tuple23 = tuple22;
        List closedFiles2 = (List)tuple23._1();
        List changedFiles2 = (List)tuple23._2();
        this.cleanFiles((List<Tuple2<String, NotificationKind>>)closedFiles2);
        return changedFiles2.nonEmpty() ? this.processIsolated((String)((Tuple2)files.head())._1(), environment, UUID.randomUUID().toString()) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private Future<BoxedUnit> processIsolated(String file, Environment environment, String uuid) {
        this.changeState(new ProcessingFile(file));
        this.stagingArea().dequeue((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file}))));
        return this.parse(file, environment, uuid).map((Function1 & Serializable & scala.Serializable)bu -> {
            WorkspaceContentManager.$anonfun$processIsolated$1(this, uuid, bu);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> shutdown() {
        this.changedFile(this.folder(), WORKSPACE_TERMINATED$.MODULE$);
        return this.isDisabled().future();
    }

    private void cleanFiles(List<Tuple2<String, NotificationKind>> closedFiles) {
        closedFiles.foreach((Function1 & Serializable & scala.Serializable)cf -> {
            this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                x$10.onRemoveFile((String)cf._1());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private Future<BoxedUnit> processChangeConfigChanges(Snapshot snapshot) {
        Future future;
        this.changeState(ProcessingProject$.MODULE$);
        this.stagingArea().enqueue((List<Tuple2<String, NotificationKind>>)((List)snapshot.files().filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processChangeConfigChanges$1(t)))));
        Option<WorkspaceConfigurationProvider> option = this.workspaceConfigurationProvider();
        if (option instanceof Some) {
            Some some = (Some)option;
            WorkspaceConfigurationProvider cp = (WorkspaceConfigurationProvider)some.value();
            future = cp.obtainConfiguration(this.environmentProvider.platform(), snapshot.environment()).flatMap((Function1 & Serializable & scala.Serializable)maybeConfig -> this.processChangeConfig((Option<WorkspaceConf>)maybeConfig), ExecutionContext.Implicits$.MODULE$.global());
        } else {
            future = Future$.MODULE$.failed((Throwable)new Exception("Expected Configuration Provider"));
        }
        return future;
    }

    private Future<BoxedUnit> processChangeConfig(Option<WorkspaceConf> maybeConfig) {
        Future<BoxedUnit> future;
        this.configMainFile_$eq(maybeConfig);
        Option<WorkspaceConf> option = maybeConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            WorkspaceConf conf = (WorkspaceConf)some.value();
            this.repository().setCachables(conf.cachables());
            future = this.processMFChanges(conf.mainFile(), this.stagingArea().snapshot());
        } else {
            this.repository().cleanTree();
            this.repository().setCachables((Set<String>)Predef$.MODULE$.Set().empty());
            future = Future$.MODULE$.unit();
        }
        return future;
    }

    private Future<BoxedUnit> processMFChanges(String mainFile, Snapshot snapshot) {
        this.changeState(ProcessingProject$.MODULE$);
        String uuid = UUID.randomUUID().toString();
        return this.parse(new StringBuilder(1).append(this.folder()).append("/").append(mainFile).toString(), snapshot.environment(), uuid).flatMap((Function1 & Serializable & scala.Serializable)u -> this.repository().newTree((AmfParseResult)u).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            WorkspaceContentManager.$anonfun$processMFChanges$2(this, u, uuid, snapshot, x$11);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<AmfParseResult> parse(String uri, Environment environment, String uuid) {
        this.telemetryProvider.addTimedMessage("Start AMF Parse", "WorkspaceContentManager", "parse", MessageTypes$.MODULE$.BEGIN_PARSE(), uri, uuid);
        Future eventualUnit = this.environmentProvider.amfConfiguration().parserHelper().parse(FileUtils$.MODULE$.getDecodedUri(uri, this.environmentProvider.platform()), environment.withResolver(this.repository().resolverCache()));
        eventualUnit.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            this.telemetryProvider.addTimedMessage("End AMF Parse", "WorkspaceContentManager", "parse", MessageTypes$.MODULE$.END_PARSE(), uri, uuid);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return eventualUnit;
    }

    public static final /* synthetic */ boolean $anonfun$processSnapshot$1(WorkspaceContentManager $this, Tuple2 u) {
        return $this.repository().inTree((String)u._1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$processSnapshot$2(Tuple2 tu) {
        Object object = tu._2();
        CHANGE_FILE$ cHANGE_FILE$ = CHANGE_FILE$.MODULE$;
        if (object == null) {
            if (cHANGE_FILE$ == null) return true;
        } else if (object.equals(cHANGE_FILE$)) return true;
        Object object2 = tu._2();
        CLOSE_FILE$ cLOSE_FILE$ = CLOSE_FILE$.MODULE$;
        if (object2 != null) {
            if (!object2.equals(cLOSE_FILE$)) return false;
            return true;
        }
        if (cLOSE_FILE$ == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$disable$2(WorkspaceContentManager $this, BaseUnitListener d) {
        $this.repository().getAllFilesUris().foreach((Function1 & Serializable & scala.Serializable)uri -> {
            d.onRemoveFile(uri);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$disable$4(WorkspaceContentManager $this, List x$6) {
        $this.isDisabled().success((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$processIsolatedChanges$1(Tuple2 x$7) {
        Object object = x$7._2();
        CLOSE_FILE$ cLOSE_FILE$ = CLOSE_FILE$.MODULE$;
        return !(object != null ? !object.equals(cLOSE_FILE$) : cLOSE_FILE$ != null);
    }

    public static final /* synthetic */ void $anonfun$processIsolated$1(WorkspaceContentManager $this, String uuid$1, AmfParseResult bu) {
        $this.repository().update(bu.baseUnit());
        $this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.onNewAst(new Tuple2((Object)bu, (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), uuid$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$processChangeConfigChanges$1(Tuple2 t) {
        Object object = t._2();
        CHANGE_CONFIG$ cHANGE_CONFIG$ = CHANGE_CONFIG$.MODULE$;
        return !(object != null ? !object.equals(cHANGE_CONFIG$) : cHANGE_CONFIG$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$processMFChanges$4(WorkspaceContentManager $this, Tuple2 t) {
        return !$this.repository().inTree((String)t._1());
    }

    public static final /* synthetic */ void $anonfun$processMFChanges$2(WorkspaceContentManager $this, AmfParseResult u$1, String uuid$2, Snapshot snapshot$1, BoxedUnit x$11) {
        $this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.onNewAst(new Tuple2((Object)u$1, $this.repository().references()), uuid$2);
            return BoxedUnit.UNIT;
        });
        $this.stagingArea().enqueue((List<Tuple2<String, NotificationKind>>)((List)snapshot$1.files().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processMFChanges$4($this, t)))));
    }

    public WorkspaceContentManager(String folder, EnvironmentProvider environmentProvider, TelemetryProvider telemetryProvider, Logger logger, List<BaseUnitListener> dependencies) {
        this.folder = folder;
        this.environmentProvider = environmentProvider;
        this.telemetryProvider = telemetryProvider;
        this.org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger = logger;
        this.dependencies = dependencies;
        this.state = Idle$.MODULE$;
        this.configMainFile = None$.MODULE$;
        this.stagingArea = new StagingArea(environmentProvider);
        this.repository = new Repository(logger);
        this.current = Future$.MODULE$.unit();
        this.workspaceConfigurationProvider = None$.MODULE$;
        this.isDisabled = Promise$.MODULE$.apply();
    }
}

