/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.modules.workspace;

import amf.internal.environment.Environment;
import java.io.Serializable;
import java.util.UUID;
import org.mulesoft.als.common.FileUtils$;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.ast.BaseUnitListener;
import org.mulesoft.als.server.modules.ast.CHANGE_CONFIG$;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.NotificationKind;
import org.mulesoft.als.server.modules.ast.WORKSPACE_TERMINATED$;
import org.mulesoft.als.server.modules.workspace.CompilableUnit;
import org.mulesoft.als.server.modules.workspace.Idle$;
import org.mulesoft.als.server.modules.workspace.NotAvailable$;
import org.mulesoft.als.server.modules.workspace.ParsedUnit;
import org.mulesoft.als.server.modules.workspace.ProcessingFile;
import org.mulesoft.als.server.modules.workspace.ProcessingProject$;
import org.mulesoft.als.server.modules.workspace.Relationships;
import org.mulesoft.als.server.modules.workspace.Relationships$;
import org.mulesoft.als.server.modules.workspace.Repository;
import org.mulesoft.als.server.modules.workspace.Snapshot;
import org.mulesoft.als.server.modules.workspace.StagingArea;
import org.mulesoft.als.server.modules.workspace.UnavailableWorkspaceException;
import org.mulesoft.als.server.modules.workspace.UnitNotFoundException;
import org.mulesoft.als.server.modules.workspace.WorkspaceState;
import org.mulesoft.als.server.textsync.EnvironmentProvider;
import org.mulesoft.als.server.workspace.extract.WorkspaceConf;
import org.mulesoft.als.server.workspace.extract.WorkspaceConfigurationProvider;
import org.mulesoft.amfmanager.AmfParseResult;
import org.mulesoft.lsp.feature.telemetry.MessageTypes$;
import org.mulesoft.lsp.feature.telemetry.TelemetryProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001\u0002\u001c8\u0001\u0011C\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t1\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\n\u0003?\u0001\u0001\u0019!C\u0005\u0003CA\u0001\"!\f\u0001A\u0003&\u0011\u0011\u0004\u0005\n\u0003_\u0001\u0001\u0019!C\u0005\u0003cA\u0011\"a\u0012\u0001\u0001\u0004%I!!\u0013\t\u0011\u00055\u0003\u0001)Q\u0005\u0003gAq!a\u0014\u0001\t\u0003\t\t\u0004C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\u0002\u0005m\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0015\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\n\u0003\u0007\u0003!\u0019!C\u0005\u0003\u000bC\u0001\"!$\u0001A\u0003%\u0011q\u0011\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#C\u0011\"a(\u0001\u0001\u0004%I!!)\t\u0011\u0005\u0015\u0006\u0001)Q\u0005\u0003'C\u0011\"a*\u0001\u0001\u0004%I!!+\t\u0013\u0005M\u0006\u00011A\u0005\n\u0005U\u0006\u0002CA]\u0001\u0001\u0006K!a+\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\ti\u000f\u0001C\u0005\u0003_Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002z\u0002!I!a<\t\u000f\u0005m\b\u0001\"\u0003\u0002p\"9\u0011Q \u0001\u0005\n\u0005}\bb\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011y\u0002\u0001C\u0005\u0003_DqA!\t\u0001\t\u0013\u0011\u0019\u0003C\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,!A!1\u0007\u0001!\u0002\u0013\u0011i\u0003C\u0004\u00036\u0001!I!a<\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!\u0011\n\u0001\u0005\n\t-\u0003b\u0002B,\u0001\u0011\u0005\u0011q\u001e\u0005\b\u00053\u0002A\u0011\u0002B.\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003p\u0001!IA!\u001d\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!q\u0012\u0001\u0005\u0002\tE%aF,pe.\u001c\b/Y2f\u0007>tG/\u001a8u\u001b\u0006t\u0017mZ3s\u0015\tA\u0014(A\u0005x_J\\7\u000f]1dK*\u0011!hO\u0001\b[>$W\u000f\\3t\u0015\taT(\u0001\u0004tKJ4XM\u001d\u0006\u0003}}\n1!\u00197t\u0015\t\u0001\u0015)\u0001\u0005nk2,7o\u001c4u\u0015\u0005\u0011\u0015aA8sO\u000e\u00011C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061am\u001c7eKJ,\u0012!\u0014\t\u0003\u001dVs!aT*\u0011\u0005A;U\"A)\u000b\u0005I\u001b\u0015A\u0002\u001fs_>$h(\u0003\u0002U\u000f\u00061\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!v)A\u0004g_2$WM\u001d\u0011\u0002'\u0015tg/\u001b:p]6,g\u000e\u001e)s_ZLG-\u001a:\u0011\u0005msV\"\u0001/\u000b\u0005u[\u0014\u0001\u0003;fqR\u001c\u0018P\\2\n\u0005}c&aE#om&\u0014xN\\7f]R\u0004&o\u001c<jI\u0016\u0014\u0018!\u0005;fY\u0016lW\r\u001e:z!J|g/\u001b3feB\u0011!-[\u0007\u0002G*\u0011A-Z\u0001\ni\u0016dW-\\3uefT!AZ4\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0001nP\u0001\u0004YN\u0004\u0018B\u00016d\u0005E!V\r\\3nKR\u0014\u0018\u0010\u0015:pm&$WM]\u0001\u0007Y><w-\u001a:\u0011\u00055|W\"\u00018\u000b\u0005-\\\u0014B\u00019o\u0005\u0019aunZ4fe\u0006aA-\u001a9f]\u0012,gnY5fgB\u00191\u000f_>\u000f\u0005Q4hB\u0001)v\u0013\u0005A\u0015BA<H\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\t1K7\u000f\u001e\u0006\u0003o\u001e\u0003\"\u0001`@\u000e\u0003uT!A`\u001d\u0002\u0007\u0005\u001cH/C\u0002\u0002\u0002u\u0014\u0001CQ1tKVs\u0017\u000e\u001e'jgR,g.\u001a:\u0002\rqJg.\u001b;?)1\t9!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n!\r\tI\u0001A\u0007\u0002o!)1j\u0002a\u0001\u001b\")\u0011l\u0002a\u00015\")\u0001m\u0002a\u0001C\")1n\u0002a\u0001Y\")\u0011o\u0002a\u0001e\u0006)1\u000f^1uKV\u0011\u0011\u0011\u0004\t\u0005\u0003\u0013\tY\"C\u0002\u0002\u001e]\u0012abV8sWN\u0004\u0018mY3Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR!\u00111EA\u0015!\r1\u0015QE\u0005\u0004\u0003O9%\u0001B+oSRD\u0011\"a\u000b\n\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'\u0001\u0004ti\u0006$X\rI\u0001\u000fG>tg-[4NC&tg)\u001b7f+\t\t\u0019\u0004E\u0003G\u0003k\tI$C\u0002\u00028\u001d\u0013aa\u00149uS>t\u0007\u0003BA\u001e\u0003\u0007j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\bKb$(/Y2u\u0015\tA4(\u0003\u0003\u0002F\u0005u\"!D,pe.\u001c\b/Y2f\u0007>tg-\u0001\nd_:4\u0017nZ'bS:4\u0015\u000e\\3`I\u0015\fH\u0003BA\u0012\u0003\u0017B\u0011\"a\u000b\r\u0003\u0003\u0005\r!a\r\u0002\u001f\r|gNZ5h\u001b\u0006LgNR5mK\u0002\nac^8sWN\u0004\u0018mY3D_:4\u0017nZ;sCRLwN\\\u0001\u0012g\u0016$8i\u001c8gS\u001el\u0015-\u001b8GS2,G\u0003BA\u0012\u0003+Bq!a\u0016\u0010\u0001\u0004\t\u0019$A\u0007x_J\\7\u000f]1dK\u000e{gNZ\u0001\t[\u0006LgNR5mKV\u0011\u0011Q\f\t\u0005\r\u0006UR*\u0001\u0006d_:4\u0017n\u001a$jY\u0016\f1b\u001d;bO&tw-\u0011:fCV\u0011\u0011Q\r\t\u0005\u0003\u0013\t9'C\u0002\u0002j]\u00121b\u0015;bO&tw-\u0011:fC\u0006a1\u000f^1hS:<\u0017I]3bA\u0005YQM\u001c<je>tW.\u001a8u+\t\t\t\b\u0005\u0003\u0002t\u0005}TBAA;\u0015\u0011\ti'a\u001e\u000b\t\u0005e\u00141P\u0001\tS:$XM\u001d8bY*\u0011\u0011QP\u0001\u0004C64\u0017\u0002BAA\u0003k\u00121\"\u00128wSJ|g.\\3oi\u0006Q!/\u001a9pg&$xN]=\u0016\u0005\u0005\u001d\u0005\u0003BA\u0005\u0003\u0013K1!a#8\u0005)\u0011V\r]8tSR|'/_\u0001\fe\u0016\u0004xn]5u_JL\b%A\u0004dkJ\u0014XM\u001c;\u0016\u0005\u0005M\u0005CBAK\u00037\u000b\u0019#\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T$\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001e\u0006]%A\u0002$viV\u0014X-A\u0006dkJ\u0014XM\u001c;`I\u0015\fH\u0003BA\u0012\u0003GC\u0011\"a\u000b\u0019\u0003\u0003\u0005\r!a%\u0002\u0011\r,(O]3oi\u0002\nad^8sWN\u0004\u0018mY3D_:4\u0017nZ;sCRLwN\u001c)s_ZLG-\u001a:\u0016\u0005\u0005-\u0006#\u0002$\u00026\u00055\u0006\u0003BA\u001e\u0003_KA!!-\u0002>\tqrk\u001c:lgB\f7-Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0015:pm&$WM]\u0001#o>\u00148n\u001d9bG\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0013xN^5eKJ|F%Z9\u0015\t\u0005\r\u0012q\u0017\u0005\n\u0003WY\u0012\u0011!a\u0001\u0003W\u000bqd^8sWN\u0004\u0018mY3D_:4\u0017nZ;sCRLwN\u001c)s_ZLG-\u001a:!\u0003)\u0019\u0017M\u001c)s_\u000e,7o]\u000b\u0003\u0003\u007f\u00032ARAa\u0013\r\t\u0019m\u0012\u0002\b\u0005>|G.Z1o\u0003-\u0019\u0007.\u00198hK\u00124\u0015\u000e\\3\u0015\r\u0005\r\u0012\u0011ZAg\u0011\u0019\tYM\ba\u0001\u001b\u0006\u0019QO]5\t\u000f\u0005=g\u00041\u0001\u0002R\u0006!1.\u001b8e!\ra\u00181[\u0005\u0004\u0003+l(\u0001\u0005(pi&4\u0017nY1uS>t7*\u001b8e\u0003E9W\r^\"p[BLG.\u00192mKVs\u0017\u000e\u001e\u000b\u0005\u00037\f\u0019\u000f\u0005\u0004\u0002\u0016\u0006m\u0015Q\u001c\t\u0005\u0003\u0013\ty.C\u0002\u0002b^\u0012abQ8na&d\u0017M\u00197f+:LG\u000f\u0003\u0004\u0002L~\u0001\r!T\u0001\u0005]\u0016DH\u000f\u0006\u0003\u0002\u0014\u0006%\bbBAvA\u0001\u0007\u00111S\u0001\u0002M\u00069\u0001O]8dKN\u001cHCAAJ\u0003E9\u0018\u000e\u001e5D_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003\u000f\t)\u0010C\u0004\u0002x\n\u0002\r!!,\u0002\u0019\r|gN\u001a)s_ZLG-\u001a:\u0002%A\u0014X\r\u001d:pG\u0016\u001c8o\u00158baNDw\u000e^\u0001\u0010aJ|7-Z:t':\f\u0007o\u001d5pi\u0006!\u0002.Y:DQ\u0006tw-\u001a3D_:4\u0017n\u001a$jY\u0016$B!a0\u0003\u0002!9!1A\u0013A\u0002\t\u0015\u0011\u0001C:oCB\u001c\bn\u001c;\u0011\t\u0005%!qA\u0005\u0004\u0005\u00139$\u0001C*oCB\u001c\bn\u001c;\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0005\u0005\u001f\u0011)\u0002E\u0002G\u0005#I1Aa\u0005H\u0005\u001dqu\u000e\u001e5j]\u001eDa!a3'\u0001\u0004i\u0015aB4fi:+\u0007\u0010\u001e\u000b\u0005\u00057\u0011i\u0002E\u0003G\u0003k\tY\u000e\u0003\u0004\u0002L\u001e\u0002\r!T\u0001\u0007O>LE\r\\3\u0002\u0017\rD\u0017M\\4f'R\fG/\u001a\u000b\u0005\u0003G\u0011)\u0003C\u0004\u0003(%\u0002\r!!\u0007\u0002\u00119,wo\u0015;bi\u0016\f!\"[:ESN\f'\r\\3e+\t\u0011i\u0003\u0005\u0004\u0002\u0016\n=\u00121E\u0005\u0005\u0005c\t9JA\u0004Qe>l\u0017n]3\u0002\u0017%\u001cH)[:bE2,G\rI\u0001\bI&\u001c\u0018M\u00197f\u0003Y\u0001(o\\2fgNL5o\u001c7bi\u0016$7\t[1oO\u0016\u001cHCBAJ\u0005w\u00119\u0005C\u0004\u0003>5\u0002\rAa\u0010\u0002\u000b\u0019LG.Z:\u0011\tMD(\u0011\t\t\u0007\r\n\rS*!5\n\u0007\t\u0015sI\u0001\u0004UkBdWM\r\u0005\b\u0003[j\u0003\u0019AA9\u0003=\u0001(o\\2fgNL5o\u001c7bi\u0016$G\u0003CAJ\u0005\u001b\u0012\tFa\u0015\t\r\t=c\u00061\u0001N\u0003\u00111\u0017\u000e\\3\t\u000f\u00055d\u00061\u0001\u0002r!1!Q\u000b\u0018A\u00025\u000bA!^;jI\u0006A1\u000f[;uI><h.\u0001\u0006dY\u0016\fgNR5mKN$B!a\t\u0003^!9!q\f\u0019A\u0002\t}\u0012aC2m_N,GMR5mKN\f!\u0004\u001d:pG\u0016\u001c8o\u00115b]\u001e,7i\u001c8gS\u001e\u001c\u0005.\u00198hKN$B!a%\u0003f!9!1A\u0019A\u0002\t\u0015\u0011a\u00059s_\u000e,7o]\"iC:<WmQ8oM&<G\u0003BAJ\u0005WBqA!\u001c3\u0001\u0004\t\u0019$A\u0006nCf\u0014WmQ8oM&<\u0017\u0001\u00059s_\u000e,7o]'G\u0007\"\fgnZ3t)\u0019\t\u0019Ja\u001d\u0003v!1\u0011\u0011L\u001aA\u00025CqAa\u00014\u0001\u0004\u0011)!A\u0003qCJ\u001cX\r\u0006\u0005\u0003|\t%%1\u0012BG!\u0019\t)*a'\u0003~A!!q\u0010BC\u001b\t\u0011\tIC\u0002\u0003\u0004~\n!\"Y7g[\u0006t\u0017mZ3s\u0013\u0011\u00119I!!\u0003\u001d\u0005kg\rU1sg\u0016\u0014Vm];mi\"1\u00111\u001a\u001bA\u00025Cq!!\u001c5\u0001\u0004\t\t\b\u0003\u0004\u0003VQ\u0002\r!T\u0001\u0011O\u0016$(+\u001a7bi&|gn\u001d5jaN$BAa%\u0003\u001aB!\u0011\u0011\u0002BK\u0013\r\u00119j\u000e\u0002\u000e%\u0016d\u0017\r^5p]ND\u0017\u000e]:\t\r\u0005-W\u00071\u0001N\u0001")
public class WorkspaceContentManager {
    private final String folder;
    private final EnvironmentProvider environmentProvider;
    private final TelemetryProvider telemetryProvider;
    public final Logger org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger;
    private final List<BaseUnitListener> dependencies;
    private WorkspaceState state;
    private Option<WorkspaceConf> configMainFile;
    private final StagingArea stagingArea;
    private final Repository repository;
    private Future<BoxedUnit> current;
    private Option<WorkspaceConfigurationProvider> workspaceConfigurationProvider;
    private final Promise<BoxedUnit> isDisabled;

    public String folder() {
        return this.folder;
    }

    private WorkspaceState state() {
        return this.state;
    }

    private void state_$eq(WorkspaceState x$1) {
        this.state = x$1;
    }

    private Option<WorkspaceConf> configMainFile() {
        return this.configMainFile;
    }

    private void configMainFile_$eq(Option<WorkspaceConf> x$1) {
        this.configMainFile = x$1;
    }

    public Option<WorkspaceConf> workspaceConfiguration() {
        return this.configMainFile();
    }

    public void setConfigMainFile(Option<WorkspaceConf> workspaceConf) {
        this.repository().cleanTree();
        this.repository().setCachables((Set<String>)((Set)workspaceConf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.cachables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        this.configMainFile_$eq(workspaceConf);
    }

    public Option<String> mainFile() {
        return this.configMainFile().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mainFile());
    }

    public Option<String> configFile() {
        return this.configMainFile().flatMap((Function1 & Serializable & scala.Serializable)ic -> ic.configReader().map((Function1 & Serializable & scala.Serializable)cr -> new StringBuilder(1).append(ic.rootFolder()).append("/").append(cr.configFileName()).toString()));
    }

    private StagingArea stagingArea() {
        return this.stagingArea;
    }

    public Environment environment() {
        return this.stagingArea().snapshot().environment();
    }

    private Repository repository() {
        return this.repository;
    }

    private Future<BoxedUnit> current() {
        return this.current;
    }

    private void current_$eq(Future<BoxedUnit> x$1) {
        this.current = x$1;
    }

    private Option<WorkspaceConfigurationProvider> workspaceConfigurationProvider() {
        return this.workspaceConfigurationProvider;
    }

    private void workspaceConfigurationProvider_$eq(Option<WorkspaceConfigurationProvider> x$1) {
        this.workspaceConfigurationProvider = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canProcess() {
        WorkspaceState workspaceState = this.state();
        Idle$ idle$ = Idle$.MODULE$;
        if (workspaceState == null) {
            if (idle$ != null) {
                return false;
            }
        } else if (!workspaceState.equals(idle$)) return false;
        Future<BoxedUnit> future = this.current();
        Future future2 = Future$.MODULE$.unit();
        if (future == null) {
            if (future2 == null) return true;
            return false;
        } else {
            if (!future.equals((Object)future2)) return false;
            return true;
        }
    }

    public synchronized void changedFile(String uri, NotificationKind kind) {
        block1: {
            WorkspaceState workspaceState = this.state();
            NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
            if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
                throw new UnavailableWorkspaceException();
            }
            this.stagingArea().enqueue(uri, kind);
            if (!this.canProcess()) break block1;
            this.current_$eq(this.process());
        }
    }

    public Future<CompilableUnit> getCompilableUnit(String uri) {
        Future future;
        String encodedUri = FileUtils$.MODULE$.getEncodedUri(uri, this.environmentProvider.platform());
        Option<ParsedUnit> option = this.repository().getParsed(encodedUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            ParsedUnit pu = (ParsedUnit)some.value();
            WorkspaceState workspaceState = this.state();
            NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
            future = Future$.MODULE$.successful((Object)pu.toCU(this.getNext(encodedUri), this.mainFile(), this.repository().getReferenceStack(encodedUri), !(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)));
        } else {
            future = (Future)this.getNext(encodedUri).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(encodedUri));
        }
        return future;
    }

    private Future<BoxedUnit> next(Future<BoxedUnit> f) {
        return f.recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkspaceContentManager $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger.error(A1.getMessage(), "WorkspaceContentManager", "Processing request");
                Future future = Future$.MODULE$.successful((Object)Unit$.MODULE$);
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)u -> {
            this.current_$eq(this.process());
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> process() {
        WorkspaceState workspaceState = this.state();
        NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
        if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
            throw new UnavailableWorkspaceException();
        }
        return this.stagingArea().isPending() ? this.next(this.preprocessSnapshot()) : this.goIdle();
    }

    public WorkspaceContentManager withConfiguration(WorkspaceConfigurationProvider confProvider) {
        this.workspaceConfigurationProvider_$eq((Option<WorkspaceConfigurationProvider>)new Some((Object)confProvider));
        return this;
    }

    private Future<BoxedUnit> preprocessSnapshot() {
        return this.stagingArea().shouldDie() ? this.disable() : this.processSnapshot();
    }

    private Future<BoxedUnit> processSnapshot() {
        Snapshot snapshot = this.stagingArea().snapshot();
        Tuple2 tuple2 = snapshot.files().partition((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processSnapshot$1(this, u)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List treeUnits = (List)tuple2._1();
        List isolated = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)treeUnits, (Object)isolated);
        Tuple2 tuple23 = tuple22;
        List treeUnits2 = (List)tuple23._1();
        List isolated2 = (List)tuple23._2();
        List changedTreeUnits = (List)treeUnits2.filter((Function1 & Serializable & scala.Serializable)tu -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processSnapshot$2(tu)));
        return this.hasChangedConfigFile(snapshot) ? this.processChangeConfigChanges(snapshot) : (changedTreeUnits.nonEmpty() ? this.processMFChanges(((WorkspaceConf)this.configMainFile().get()).mainFile(), snapshot) : this.processIsolatedChanges((List<Tuple2<String, NotificationKind>>)isolated2, snapshot.environment()));
    }

    private boolean hasChangedConfigFile(Snapshot snapshot) {
        return ((LinearSeqOptimized)snapshot.files().map((Function1 & Serializable & scala.Serializable)x$4 -> (NotificationKind)x$4._2(), List$.MODULE$.canBuildFrom())).contains((Object)CHANGE_CONFIG$.MODULE$);
    }

    private Nothing$ fail(String uri) {
        throw new UnitNotFoundException(uri);
    }

    private Option<Future<CompilableUnit>> getNext(String uri) {
        Future<BoxedUnit> future = this.current();
        Future future2 = Future$.MODULE$.unit();
        Future<BoxedUnit> future3 = future;
        Object object = !(future2 != null ? !future2.equals(future3) : future3 != null) ? None$.MODULE$ : new Some((Object)this.current().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> this.getCompilableUnit(uri), ExecutionContext.Implicits$.MODULE$.global()));
        return object;
    }

    private Future<BoxedUnit> goIdle() {
        this.changeState(Idle$.MODULE$);
        return Future$.MODULE$.unit();
    }

    private synchronized void changeState(WorkspaceState newState) {
        WorkspaceState workspaceState = this.state();
        NotAvailable$ notAvailable$ = NotAvailable$.MODULE$;
        if (!(workspaceState != null ? !workspaceState.equals(notAvailable$) : notAvailable$ != null)) {
            throw new UnavailableWorkspaceException();
        }
        this.state_$eq(newState);
    }

    private Promise<BoxedUnit> isDisabled() {
        return this.isDisabled;
    }

    private Future<BoxedUnit> disable() {
        this.changeState(NotAvailable$.MODULE$);
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)$this.dependencies.map((Function1 & Serializable & scala.Serializable)d -> {
            WorkspaceContentManager.$anonfun$disable$2(this, d);
            return BoxedUnit.UNIT;
        }, List$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            WorkspaceContentManager.$anonfun$disable$4(this, x$6);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> processIsolatedChanges(List<Tuple2<String, NotificationKind>> files, Environment environment) {
        Tuple2 tuple2 = files.partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processIsolatedChanges$1(x$7)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List closedFiles = (List)tuple2._1();
        List changedFiles = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)closedFiles, (Object)changedFiles);
        Tuple2 tuple23 = tuple22;
        List closedFiles2 = (List)tuple23._1();
        List changedFiles2 = (List)tuple23._2();
        this.cleanFiles((List<Tuple2<String, NotificationKind>>)closedFiles2);
        return changedFiles2.nonEmpty() ? this.processIsolated((String)((Tuple2)files.head())._1(), environment, UUID.randomUUID().toString()) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private Future<BoxedUnit> processIsolated(String file, Environment environment, String uuid) {
        this.changeState(new ProcessingFile(file));
        this.stagingArea().dequeue((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file}))));
        return this.parse(file, environment, uuid).map((Function1 & Serializable & scala.Serializable)bu -> {
            WorkspaceContentManager.$anonfun$processIsolated$1(this, uuid, bu);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> shutdown() {
        this.changedFile(this.folder(), WORKSPACE_TERMINATED$.MODULE$);
        return this.isDisabled().future();
    }

    private void cleanFiles(List<Tuple2<String, NotificationKind>> closedFiles) {
        closedFiles.foreach((Function1 & Serializable & scala.Serializable)cf -> {
            this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                x$10.onRemoveFile((String)cf._1());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private Future<BoxedUnit> processChangeConfigChanges(Snapshot snapshot) {
        Future future;
        this.changeState(ProcessingProject$.MODULE$);
        this.stagingArea().enqueue((List<Tuple2<String, NotificationKind>>)((List)snapshot.files().filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processChangeConfigChanges$1(t)))));
        Option<WorkspaceConfigurationProvider> option = this.workspaceConfigurationProvider();
        if (option instanceof Some) {
            Some some = (Some)option;
            WorkspaceConfigurationProvider cp = (WorkspaceConfigurationProvider)some.value();
            future = cp.obtainConfiguration(this.environmentProvider.platform(), snapshot.environment()).flatMap((Function1 & Serializable & scala.Serializable)maybeConfig -> this.processChangeConfig((Option<WorkspaceConf>)maybeConfig), ExecutionContext.Implicits$.MODULE$.global());
        } else {
            future = Future$.MODULE$.failed((Throwable)new Exception("Expected Configuration Provider"));
        }
        return future;
    }

    private Future<BoxedUnit> processChangeConfig(Option<WorkspaceConf> maybeConfig) {
        Future<BoxedUnit> future;
        this.configMainFile_$eq(maybeConfig);
        Option<WorkspaceConf> option = maybeConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            WorkspaceConf conf = (WorkspaceConf)some.value();
            this.repository().setCachables(conf.cachables());
            future = this.processMFChanges(conf.mainFile(), this.stagingArea().snapshot());
        } else {
            this.repository().cleanTree();
            this.repository().setCachables((Set<String>)Predef$.MODULE$.Set().empty());
            future = Future$.MODULE$.unit();
        }
        return future;
    }

    private Future<BoxedUnit> processMFChanges(String mainFile, Snapshot snapshot) {
        this.changeState(ProcessingProject$.MODULE$);
        String uuid = UUID.randomUUID().toString();
        return this.parse(new StringBuilder(1).append(this.folder()).append("/").append(mainFile).toString(), snapshot.environment(), uuid).flatMap((Function1 & Serializable & scala.Serializable)u -> this.repository().newTree((AmfParseResult)u).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            WorkspaceContentManager.$anonfun$processMFChanges$2(this, u, uuid, snapshot, x$11);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<AmfParseResult> parse(String uri, Environment environment, String uuid) {
        this.telemetryProvider.addTimedMessage("Start AMF Parse", "WorkspaceContentManager", "parse", MessageTypes$.MODULE$.BEGIN_PARSE(), uri, uuid);
        Future eventualUnit = this.environmentProvider.amfConfiguration().parserHelper().parse(FileUtils$.MODULE$.getDecodedUri(uri, this.environmentProvider.platform()), environment.withResolver(this.repository().resolverCache()));
        eventualUnit.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            this.telemetryProvider.addTimedMessage("End AMF Parse", "WorkspaceContentManager", "parse", MessageTypes$.MODULE$.END_PARSE(), uri, uuid);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return eventualUnit;
    }

    public Relationships getRelationships(String uri) {
        return Relationships$.MODULE$.apply(this.repository(), (Function0<Option<Future<CompilableUnit>>>)(Function0 & Serializable & scala.Serializable)() -> new Some(this.getCompilableUnit(uri)));
    }

    public static final /* synthetic */ boolean $anonfun$processSnapshot$1(WorkspaceContentManager $this, Tuple2 u) {
        return $this.repository().inTree((String)u._1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$processSnapshot$2(Tuple2 tu) {
        Object object = tu._2();
        CHANGE_FILE$ cHANGE_FILE$ = CHANGE_FILE$.MODULE$;
        if (object == null) {
            if (cHANGE_FILE$ == null) return true;
        } else if (object.equals(cHANGE_FILE$)) return true;
        Object object2 = tu._2();
        CLOSE_FILE$ cLOSE_FILE$ = CLOSE_FILE$.MODULE$;
        if (object2 != null) {
            if (!object2.equals(cLOSE_FILE$)) return false;
            return true;
        }
        if (cLOSE_FILE$ == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$disable$2(WorkspaceContentManager $this, BaseUnitListener d) {
        $this.repository().getAllFilesUris().foreach((Function1 & Serializable & scala.Serializable)uri -> {
            d.onRemoveFile(uri);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$disable$4(WorkspaceContentManager $this, List x$6) {
        $this.isDisabled().success((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$processIsolatedChanges$1(Tuple2 x$7) {
        Object object = x$7._2();
        CLOSE_FILE$ cLOSE_FILE$ = CLOSE_FILE$.MODULE$;
        return !(object != null ? !object.equals(cLOSE_FILE$) : cLOSE_FILE$ != null);
    }

    public static final /* synthetic */ void $anonfun$processIsolated$1(WorkspaceContentManager $this, String uuid$1, AmfParseResult bu) {
        $this.repository().update(bu.baseUnit());
        $this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.onNewAst(new Tuple2((Object)bu, (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), uuid$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$processChangeConfigChanges$1(Tuple2 t) {
        Object object = t._2();
        CHANGE_CONFIG$ cHANGE_CONFIG$ = CHANGE_CONFIG$.MODULE$;
        return !(object != null ? !object.equals(cHANGE_CONFIG$) : cHANGE_CONFIG$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$processMFChanges$4(WorkspaceContentManager $this, Tuple2 t) {
        return !$this.repository().inTree((String)t._1());
    }

    public static final /* synthetic */ void $anonfun$processMFChanges$2(WorkspaceContentManager $this, AmfParseResult u$1, String uuid$2, Snapshot snapshot$1, BoxedUnit x$11) {
        $this.dependencies.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.onNewAst(new Tuple2((Object)u$1, $this.repository().references()), uuid$2);
            return BoxedUnit.UNIT;
        });
        $this.stagingArea().enqueue((List<Tuple2<String, NotificationKind>>)((List)snapshot$1.files().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)WorkspaceContentManager.$anonfun$processMFChanges$4($this, t)))));
    }

    public WorkspaceContentManager(String folder, EnvironmentProvider environmentProvider, TelemetryProvider telemetryProvider, Logger logger, List<BaseUnitListener> dependencies) {
        this.folder = folder;
        this.environmentProvider = environmentProvider;
        this.telemetryProvider = telemetryProvider;
        this.org$mulesoft$als$server$modules$workspace$WorkspaceContentManager$$logger = logger;
        this.dependencies = dependencies;
        this.state = Idle$.MODULE$;
        this.configMainFile = None$.MODULE$;
        this.stagingArea = new StagingArea(environmentProvider);
        this.repository = new Repository(logger);
        this.current = Future$.MODULE$.unit();
        this.workspaceConfigurationProvider = None$.MODULE$;
        this.isDisabled = Promise$.MODULE$.apply();
    }
}

