/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import java.io.Serializable;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.common.interfaces.IEditorTextBuffer;
import org.mulesoft.als.server.modules.common.interfaces.IPoint;
import org.mulesoft.als.server.modules.common.interfaces.IRange;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u000b\u0017\u0001\u0005B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)A\t\u0001C\u0001\u000b\"9!\n\u0001a\u0001\n\u0003Y\u0005b\u0002'\u0001\u0001\u0004%\t!\u0014\u0005\u0007'\u0002\u0001\u000b\u0015B\u001a\t\u000fQ\u0003\u0001\u0019!C\u0001+\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0007B\u00023\u0001A\u0003&a\u000bC\u0003f\u0001\u0011\u0005a\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011%\t\u0019\u0002AI\u0001\n\u0003\t)\u0002C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0002\u000f)\u0016DHOQ;gM\u0016\u0014\u0018J\u001c4p\u0015\t9\u0002$\u0001\u0005uKb$8/\u001f8d\u0015\tI\"$\u0001\u0004tKJ4XM\u001d\u0006\u00037q\t1!\u00197t\u0015\tib$\u0001\u0005nk2,7o\u001c4u\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u0015%tG/\u001a:gC\u000e,7O\u0003\u0002.]\u000511m\\7n_:T!a\f\r\u0002\u000f5|G-\u001e7fg&\u0011\u0011G\u000b\u0002\u0012\u0013\u0016#\u0017\u000e^8s)\u0016DHOQ;gM\u0016\u0014\u0018aA;sSB\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\u0013\u000e\u0003]R!\u0001\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0013\tQD%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e%\u0003\u0019awnZ4feB\u0011\u0001IQ\u0007\u0002\u0003*\u0011a\bG\u0005\u0003\u0007\u0006\u0013a\u0001T8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002G\u0011&\u0003\"a\u0012\u0001\u000e\u0003YAQAM\u0002A\u0002MBQAP\u0002A\u0002}\nA\u0001^3yiV\t1'\u0001\u0005uKb$x\fJ3r)\tq\u0015\u000b\u0005\u0002$\u001f&\u0011\u0001\u000b\n\u0002\u0005+:LG\u000fC\u0004S\u000b\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'A\u0003uKb$\b%A\u0006mS:,G*\u001a8hi\"\u001cX#\u0001,\u0011\u0007]cf,D\u0001Y\u0015\tI&,A\u0004nkR\f'\r\\3\u000b\u0005m#\u0013AC2pY2,7\r^5p]&\u0011Q\f\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002$?&\u0011\u0001\r\n\u0002\u0004\u0013:$\u0018a\u00047j]\u0016dUM\\4uQN|F%Z9\u0015\u00059\u001b\u0007b\u0002*\t\u0003\u0003\u0005\rAV\u0001\rY&tW\rT3oORD7\u000fI\u0001\rY&tWMQ=PM\u001a\u001cX\r\u001e\u000b\u0003=\u001eDQ\u0001\u001b\u0006A\u0002y\u000baa\u001c4gg\u0016$\u0018!G2iCJ\f7\r^3s\u0013:$W\r\u001f$peB{7/\u001b;j_:$\"AX6\t\u000b1\\\u0001\u0019A7\u0002\u0011A|7/\u001b;j_:\u0004\"!\u000b8\n\u0005=T#AB%Q_&tG/A\rq_NLG/[8o\r>\u00148\t[1sC\u000e$XM]%oI\u0016DHCA7s\u0011\u0015AG\u00021\u0001_\u0003-\u0011\u0018M\\4f\r>\u0014(k\\<\u0015\u0007UD(\u0010\u0005\u0002*m&\u0011qO\u000b\u0002\u0007\u0013J\u000bgnZ3\t\u000bel\u0001\u0019\u00010\u0002\u0011I|w\u000fU1sC6DQa_\u0007A\u0002q\fa\"\u001b8dYV$WMT3xY&tW\r\u0005\u0002${&\u0011a\u0010\n\u0002\b\u0005>|G.Z1o\u000399W\r\u001e+fqRLeNU1oO\u0016$2aMA\u0002\u0011\u0019\t)A\u0004a\u0001k\u0006)!/\u00198hK\u0006q1/\u001a;UKb$\u0018J\u001c*b]\u001e,Gc\u0002(\u0002\f\u00055\u0011q\u0002\u0005\u0007\u0003\u000by\u0001\u0019A;\t\u000b){\u0001\u0019A\u001a\t\u0011\u0005Eq\u0002%AA\u0002q\fAC\\8s[\u0006d\u0017N_3MS:,WI\u001c3j]\u001e\u001c\u0018\u0001G:fiR+\u0007\u0010^%o%\u0006tw-\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0003\u0016\u0004y\u0006e1FAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015B%\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000f\u001d,G\u000fV3yiR\t1'\u0001\bhKR,e\u000e\u001a)pg&$\u0018n\u001c8\u0015\u00035\fqa]3u)\u0016DH\u000fF\u0002O\u0003oAQAS\nA\u0002M\n1\"\u001b8ji6\u000b\u0007\u000f]5oOR\ta\n")
public class TextBufferInfo
implements IEditorTextBuffer {
    private final Logger logger;
    private String text;
    private ArrayBuffer<Object> lineLengths;

    public String text() {
        return this.text;
    }

    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    public ArrayBuffer<Object> lineLengths() {
        return this.lineLengths;
    }

    public void lineLengths_$eq(ArrayBuffer<Object> x$1) {
        this.lineLengths = x$1;
    }

    @Override
    public int lineByOffset(int offset) {
        int n;
        Object object = new Object();
        try {
            IntRef currentOffset = IntRef.create((int)0);
            this.lineLengths().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                currentOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
                if (currentOffset$1.elem > offset) {
                    throw new NonLocalReturnControl.mcI.sp(object, i);
                }
            });
            n = this.lineLengths().length() - 1;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int characterIndexForPosition(IPoint position) {
        void var3_3;
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), position.row()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$1.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int result = lineStartOffset.elem + position.column();
        this.logger.debug(new StringBuilder(34).append("characterIndexForPosition:: [").append(position.row()).append(":").append(position.column()).append("] = ").append(result).toString(), "EditorManager", "TextBufferInfo#characterIndexForPosition");
        return (int)var3_3;
    }

    @Override
    public IPoint positionForCharacterIndex(int offset) {
        IPoint iPoint;
        IntRef pos = IntRef.create((int)offset);
        ObjectRef found = ObjectRef.create((Object)None$.MODULE$);
        String positionForCharacterIndex = "TextBufferInfo#positionForCharacterIndex";
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.lineLengths().length()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((Option)found$1.elem).isEmpty()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i));
            if (pos$1.elem < lineLength) {
                $this.logger.debug(new StringBuilder(31).append("positionForCharacterIndex:").append(offset).append(": [").append(i).append(":").append(pos$1.elem).append("]").toString(), "EditorManager", positionForCharacterIndex);
                found$1.elem = Option$.MODULE$.apply((Object)new IPoint(i, pos$1.elem));
            }
            pos$1.elem -= lineLength;
        });
        if (((Option)found.elem).isDefined()) {
            iPoint = (IPoint)((Option)found.elem).get();
        } else if (pos.elem == 0) {
            int resultRow = this.lineLengths().length() - 1;
            int resultColumn = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(this.lineLengths().length() - 1));
            this.logger.debug(new StringBuilder(31).append("positionForCharacterIndex:").append(offset).append(": [").append(resultRow).append(":").append(resultColumn).append("]").toString(), "EditorManager", positionForCharacterIndex);
            iPoint = new IPoint(resultRow, resultColumn);
        } else {
            String errorMessage = new StringBuilder(45).append("Character position exceeds text length: ").append(offset).append(" > + ").append(this.text().length()).toString();
            this.logger.error(errorMessage, "EditorManager", positionForCharacterIndex);
            throw new Error(errorMessage);
        }
        return iPoint;
    }

    @Override
    public IRange rangeForRow(int rowParam, boolean includeNewline) {
        this.logger.debug(new StringBuilder(18).append("rangeForRow start:").append(rowParam).toString(), "EditorManager", "TextBufferInfo#rangeForRow");
        IntRef lineStartOffset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowParam).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> lineStartOffset$2.elem += BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(i)));
        int lineLength = BoxesRunTime.unboxToInt((Object)this.lineLengths().apply(rowParam));
        IPoint startPoint = new IPoint(rowParam, 0);
        IPoint endPoint = new IPoint(rowParam, lineLength);
        this.logger.debug(new StringBuilder(28).append("rangeForRow return:").append(rowParam).append(": [").append(startPoint.row()).append(":").append(startPoint.column()).append("]").append(",[").append(endPoint.row()).append(":").append(endPoint.column()).append("]").toString(), "EditorManager", "TextBufferInfo#rangeForRow");
        return new IRange(null, startPoint, endPoint){
            private IPoint start;
            private IPoint end;

            public IPoint start() {
                return this.start;
            }

            public void start_$eq(IPoint x$1) {
                this.start = x$1;
            }

            public IPoint end() {
                return this.end;
            }

            public void end_$eq(IPoint x$1) {
                this.end = x$1;
            }
            {
                this.start = startPoint$1;
                this.end = endPoint$1;
            }
        };
    }

    @Override
    public String getTextInRange(IRange range) {
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        String result = this.text().substring(startOffset, endOffset);
        this.logger.debug(new StringBuilder(24).append("Text in range: [").append(range.start().row()).append(":").append(range.start().column()).append("]").append(",[").append(range.end().row()).append(":").append(range.end().column()).append("]:\n").append(result).toString(), "EditorManager", "TextBufferInfo#getTextInRange");
        return result;
    }

    @Override
    public void setTextInRange(IRange range, String text, boolean normalizeLineEndings) {
        this.logger.debug(new StringBuilder(32).append("Setting text in range: [").append(range.start().row()).append(":").append(range.start().column()).append("] ,").append("[").append(range.end().row()).append(":").append(range.end().column()).append("]\n").append(text).toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        int startOffset = this.characterIndexForPosition(range.start());
        int endOffset = this.characterIndexForPosition(range.end());
        this.logger.debug(new StringBuilder(35).append("Found range in absolute coords: [").append(startOffset).append(":").append(endOffset).append("]").toString(), "EditorManager", "TextBufferInfo#setTextInRange");
        String startText = startOffset > 0 ? this.text().substring(0, startOffset) : "";
        String endText = endOffset < this.text().length() ? this.text().substring(endOffset) : "";
        this.setText(new StringBuilder(0).append(startText).append(text).append(endText).toString());
    }

    @Override
    public String getText() {
        return this.text();
    }

    @Override
    public IPoint getEndPosition() {
        return this.positionForCharacterIndex(this.text().length() - 1);
    }

    public void setText(String text) {
        this.text_$eq(text);
        this.initMapping();
    }

    @Override
    public boolean setTextInRange$default$3() {
        return false;
    }

    public void initMapping() {
        this.lineLengths_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        IntRef ind = IntRef.create((int)0);
        int l = this.text().length();
        BooleanRef ignoreNext = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), l).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block3: {
                block4: {
                    block2: {
                        if (!ignoreNext$1.elem) break block2;
                        ignoreNext$1.elem = false;
                        break block3;
                    }
                    ignoreNext$1.elem = false;
                    if (this.text().charAt(i) != '\r') break block4;
                    if (i < l - 1 && this.text().charAt(i + 1) == '\n') {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 2)));
                        ind$1.elem = i + 2;
                        ignoreNext$1.elem = true;
                    } else {
                        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                        ind$1.elem = i + 1;
                    }
                    break block3;
                }
                if (this.text().charAt(i) != '\n') break block3;
                this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i - ind$1.elem + 1)));
                ind$1.elem = i + 1;
            }
        });
        this.lineLengths().$plus$eq((Object)BoxesRunTime.boxToInteger((int)(l - ind.elem)));
    }

    public TextBufferInfo(String uri, Logger logger) {
        this.logger = logger;
        this.text = "";
        this.lineLengths = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

