/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import java.io.Serializable;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.FOCUS_FILE$;
import org.mulesoft.als.server.modules.ast.OPEN_FILE$;
import org.mulesoft.als.server.modules.ast.TextListener;
import org.mulesoft.als.server.protocol.textsync.AlsTextDocumentSyncConsumer;
import org.mulesoft.als.server.protocol.textsync.DidFocusParams;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.als.server.textsync.TextDocumentContainer;
import org.mulesoft.lsp.edit.TextEdit;
import org.mulesoft.lsp.feature.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u000b\u0017\u0001\u0005B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005M\u0001\t\u0005\t\u0015!\u00039\u0011!i\u0005A!b\u0001\n\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bU\u0003A\u0011\u0001,\t\u000fm\u0003!\u0019!C!9\"1A\r\u0001Q\u0001\nuCQ!\u001a\u0001\u0005B\u0019Dq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!\t!!\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\n\u0019B+\u001a=u\t>\u001cW/\\3oi6\u000bg.Y4fe*\u0011q\u0003G\u0001\ti\u0016DHo]=oG*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005ma\u0012aA1mg*\u0011QDH\u0001\t[VdWm]8gi*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015.\u001b\u0005Q#BA\f,\u0015\ta\u0003$\u0001\u0005qe>$xnY8m\u0013\tq#FA\u000eBYN$V\r\u001f;E_\u000e,X.\u001a8u'ft7mQ8ogVlWM]\u0001\fkJLGk\\#eSR|'/F\u00012!\t\u00114'D\u0001\u0017\u0013\t!dCA\u000bUKb$Hi\\2v[\u0016tGoQ8oi\u0006Lg.\u001a:\u0002\u0019U\u0014\u0018\u000eV8FI&$xN\u001d\u0011\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:\u0016\u0003a\u00022!O!E\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>A\u00051AH]8pizJ\u0011!J\u0005\u0003\u0001\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\n!A*[:u\u0015\t\u0001E\u0005\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006\u0019\u0011m\u001d;\u000b\u0005%C\u0012aB7pIVdWm]\u0005\u0003\u0017\u001a\u0013A\u0002V3yi2K7\u000f^3oKJ\fQ\u0002Z3qK:$WM\\2jKN\u0004\u0013A\u00027pO\u001e,'/F\u0001P!\t\u0001&+D\u0001R\u0015\ti\u0005$\u0003\u0002T#\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005/bK&\f\u0005\u00023\u0001!)qf\u0002a\u0001c!)ag\u0002a\u0001q!)Qj\u0002a\u0001\u001f\u0006!A/\u001f9f+\u0005ifB\u00010c\u001b\u0005y&BA\fa\u0015\t\tG$A\u0002mgBL!aY0\u00025Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7i\u001c8gS\u001e$\u0016\u0010]3\u0002\u000bQL\b/\u001a\u0011\u0002\u0017\u0005\u0004\b\u000f\\=D_:4\u0017n\u001a\u000b\u0003Or\u0004B!\u000f5ks&\u0011\u0011n\u0011\u0002\u0007\u000b&$\b.\u001a:\u0011\u0005-4hB\u00017u\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003wAL\u0011aH\u0005\u0003;yI!!\u0019\u000f\n\u0005]\u0001\u0017BA;`\u0003Q!V\r\u001f;E_\u000e,X.\u001a8u'ft7mS5oI&\u0011q\u000f\u001f\u0002\u0015)\u0016DH\u000fR8dk6,g\u000e^*z]\u000e\\\u0015N\u001c3\u000b\u0005U|\u0006C\u00010{\u0013\tYxLA\fUKb$Hi\\2v[\u0016tGoU=oG>\u0003H/[8og\")QP\u0003a\u0001}\u000611m\u001c8gS\u001e\u0004BaI@\u0002\u0004%\u0019\u0011\u0011\u0001\u0013\u0003\r=\u0003H/[8o!\rq\u0016QA\u0005\u0004\u0003\u000fy&!I*z]\u000eD'o\u001c8ju\u0006$\u0018n\u001c8DY&,g\u000e^\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\u0018AC5oSRL\u0017\r\\5{KR\u0011\u0011Q\u0002\t\u0007\u0003\u001f\t)\"!\u0007\u000e\u0005\u0005E!bAA\nI\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005]\u0011\u0011\u0003\u0002\u0007\rV$XO]3\u0011\u0007\r\nY\"C\u0002\u0002\u001e\u0011\u0012A!\u00168ji\u0006qqN\\(qK:$unY;nK:$H\u0003BA\r\u0003GAq!!\n\r\u0001\u0004\t9#\u0001\u0005e_\u000e,X.\u001a8u!\r\u0011\u0014\u0011F\u0005\u0004\u0003W1\"AD(qK:,G\rR8dk6,g\u000e^\u0001\u0013I>\u001cW/\\3oi^\u000b7o\u00115b]\u001e,G\r\u0006\u0003\u0002\u001a\u0005E\u0002bBA\u0013\u001b\u0001\u0007\u00111\u0007\t\u0004e\u0005U\u0012bAA\u001c-\ty1\t[1oO\u0016$Gi\\2v[\u0016tG/A\bp]\u000ecwn]3E_\u000e,X.\u001a8u)\u0011\tI\"!\u0010\t\u000f\u0005}b\u00021\u0001\u0002B\u0005\u0019QO]5\u0011\t\u0005\r\u00131\n\b\u0005\u0003\u000b\n9\u0005\u0005\u0002<I%\u0019\u0011\u0011\n\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\r\tI\u0005J\u0001\u0011_:\u001c\u0005.\u00198hKB{7/\u001b;j_:$b!!\u0007\u0002V\u0005]\u0003bBA \u001f\u0001\u0007\u0011\u0011\t\u0005\b\u00033z\u0001\u0019AA.\u0003!\u0001xn]5uS>t\u0007cA\u0012\u0002^%\u0019\u0011q\f\u0013\u0003\u0007%sG/A\beKR,'/\\5oKNKh\u000e^1y)\u0019\t\t%!\u001a\u0002j!9\u0011q\r\tA\u0002\u0005\u0005\u0013aA;sY\"9\u00111\u000e\tA\u0002\u0005\u0005\u0013\u0001\u0002;fqR\fq\u0001Z5e\u001fB,g\u000e\u0006\u0003\u0002\u001a\u0005E\u0004bBA:#\u0001\u0007\u0011QO\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0007y\u000b9(C\u0002\u0002z}\u0013\u0011\u0004R5e\u001fB,g\u000eV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006IA-\u001b3DQ\u0006tw-\u001a\u000b\u0005\u00033\ty\bC\u0004\u0002tI\u0001\r!!!\u0011\u0007y\u000b\u0019)C\u0002\u0002\u0006~\u00131\u0004R5e\u0007\"\fgnZ3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018\u0001\u00033jI\u000ecwn]3\u0015\t\u0005e\u00111\u0012\u0005\b\u0003g\u001a\u0002\u0019AAG!\rq\u0016qR\u0005\u0004\u0003#{&A\u0007#jI\u000ecwn]3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018\u0001\u00033jI\u001a{7-^:\u0015\t\u0005e\u0011q\u0013\u0005\b\u0003g\"\u0002\u0019AAM!\rI\u00131T\u0005\u0004\u0003;S#A\u0004#jI\u001a{7-^:QCJ\fWn\u001d")
public class TextDocumentManager
implements AlsTextDocumentSyncConsumer {
    private final TextDocumentContainer uriToEditor;
    private final List<TextListener> dependencies;
    private final Logger logger;
    private final TextDocumentSyncConfigType$ type;

    public TextDocumentContainer uriToEditor() {
        return this.uriToEditor;
    }

    public List<TextListener> dependencies() {
        return this.dependencies;
    }

    private Logger logger() {
        return this.logger;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        this.logger().debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$1 = None$.MODULE$;
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$3 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option x$4 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option)x$2, (Option)x$3, x$4, x$5, (Option)x$1));
    }

    public Future<BoxedUnit> initialize() {
        return this.uriToEditor().initialize();
    }

    public void onOpenDocument(OpenedDocument document) {
        this.logger().debug(new StringBuilder(19).append("Document is opened ").append(document.uri()).toString(), "EditorManager", "onOpenDocument");
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), syntax, this.logger())));
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.notify(document.uri(), OPEN_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void documentWasChanged(ChangedDocument document) {
        this.logger().debug(new StringBuilder(20).append("Document is changed ").append(document.uri()).toString(), "EditorManager", "onChangeDocument");
        this.uriToEditor().get(document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
            TextDocumentManager.$anonfun$documentWasChanged$1(this, document, current);
            return BoxedUnit.UNIT;
        });
        String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), syntax, this.logger())));
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.notify(document.uri(), CHANGE_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void onCloseDocument(String uri) {
        this.uriToEditor().remove(uri);
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.notify(uri, CLOSE_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void onChangePosition(String uri, int position) {
        this.uriToEditor().get(uri).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.setCursorPosition(position);
            return BoxedUnit.UNIT;
        });
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.onOpenDocument(new OpenedDocument(params.textDocument().uri(), params.textDocument().version(), params.textDocument().text()));
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.text());
        this.documentWasChanged(new ChangedDocument(document.uri(), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.onCloseDocument(params.textDocument().uri());
    }

    @Override
    public void didFocus(DidFocusParams params) {
        this.uriToEditor().get(params.uri()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            TextDocumentManager.$anonfun$didFocus$1(this, params, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(TextDocumentManager $this, ChangedDocument document$2, TextDocument current) {
        block1: {
            int currentVersion = current.version();
            String currentText = current.text();
            if (currentVersion == document$2.version()) {
                $this.logger().debug(new StringBuilder(63).append("Version of the reported change is equal to the previous one at ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
            }
            if (document$2.version() >= currentVersion || !document$2.text().contains((Object)currentText)) break block1;
            $this.logger().debug(new StringBuilder(24).append("No changes detected for ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
        }
    }

    public static final /* synthetic */ void $anonfun$didFocus$1(TextDocumentManager $this, DidFocusParams params$1, TextDocument x$6) {
        $this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.notify(params$1.uri(), FOCUS_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public TextDocumentManager(TextDocumentContainer uriToEditor, List<TextListener> dependencies, Logger logger) {
        this.uriToEditor = uriToEditor;
        this.dependencies = dependencies;
        this.logger = logger;
        this.type = TextDocumentSyncConfigType$.MODULE$;
    }
}

