/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import amf.core.remote.Platform;
import java.io.Serializable;
import org.mulesoft.als.common.URIImplicits$;
import org.mulesoft.als.server.logger.Logger;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.FOCUS_FILE$;
import org.mulesoft.als.server.modules.ast.OPEN_FILE$;
import org.mulesoft.als.server.modules.ast.TextListener;
import org.mulesoft.als.server.protocol.textsync.AlsTextDocumentSyncConsumer;
import org.mulesoft.als.server.protocol.textsync.DidFocusParams;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.als.server.textsync.TextDocumentContainer;
import org.mulesoft.lsp.edit.TextEdit;
import org.mulesoft.lsp.feature.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0005A!b\u0001\n\u0013y\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000bY\u0003A\u0011A,\t\u000fq\u0003!\u0019!C\u0006;\"1\u0001\u000e\u0001Q\u0001\nyCq!\u001b\u0001C\u0002\u0013\u0005#\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001b\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ty\n\u0001C!\u0003C\u00131\u0003V3yi\u0012{7-^7f]Rl\u0015M\\1hKJT!\u0001G\r\u0002\u0011Q,\u0007\u0010^:z]\u000eT!AG\u000e\u0002\rM,'O^3s\u0015\taR$A\u0002bYNT!AH\u0010\u0002\u00115,H.Z:pMRT\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+]5\t1F\u0003\u0002\u0019Y)\u0011Q&G\u0001\taJ|Go\\2pY&\u0011qf\u000b\u0002\u001c\u00032\u001cH+\u001a=u\t>\u001cW/\\3oiNKhnY\"p]N,X.\u001a:\u0002\u0017U\u0014\u0018\u000eV8FI&$xN]\u000b\u0002eA\u00111\u0007N\u0007\u0002/%\u0011Qg\u0006\u0002\u0016)\u0016DH\u000fR8dk6,g\u000e^\"p]R\f\u0017N\\3s\u00031)(/\u001b+p\u000b\u0012LGo\u001c:!\u00031!W\r]3oI\u0016t7-[3t+\u0005I\u0004c\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u0005\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0005\u0005+\u0013a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013A\u0001T5ti*\u0011\u0011)\n\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b1!Y:u\u0015\tQ\u0015$A\u0004n_\u0012,H.Z:\n\u00051;%\u0001\u0004+fqRd\u0015n\u001d;f]\u0016\u0014\u0018!\u00043fa\u0016tG-\u001a8dS\u0016\u001c\b%\u0001\u0004m_\u001e<WM]\u000b\u0002!B\u0011\u0011kU\u0007\u0002%*\u0011a*G\u0005\u0003)J\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taK&l\u0017\t\u0003g\u0001AQ\u0001M\u0004A\u0002IBQaN\u0004A\u0002eBQAT\u0004A\u0002A\u000b\u0001\u0002\u001d7bi\u001a|'/\\\u000b\u0002=B\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\u0007e\u0016lw\u000e^3\u000b\u0005\r$\u0017\u0001B2pe\u0016T\u0011!Z\u0001\u0004C64\u0017BA4a\u0005!\u0001F.\u0019;g_Jl\u0017!\u00039mCR4wN]7!\u0003\u0011!\u0018\u0010]3\u0016\u0003-t!\u0001\u001c9\u000e\u00035T!\u0001\u00078\u000b\u0005=l\u0012a\u00017ta&\u0011\u0011/\\\u0001\u001b)\u0016DH\u000fR8dk6,g\u000e^*z]\u000e\u001cuN\u001c4jORK\b/Z\u0001\u0006if\u0004X\rI\u0001\fCB\u0004H._\"p]\u001aLw\rF\u0002v\u0003+\u0001RA\u000f<y\u0003\u001fI!a\u001e#\u0003\r\u0015KG\u000f[3s!\rI\u0018\u0011\u0002\b\u0004u\u0006\u0015abA>\u0002\u00049\u0019A0!\u0001\u000f\u0005u|hB\u0001\u001f\u007f\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\tyW$\u0003\u0002\u0019]&\u0019\u0011qA7\u0002)Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7*\u001b8e\u0013\u0011\tY!!\u0004\u0003)Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7*\u001b8e\u0015\r\t9!\u001c\t\u0004Y\u0006E\u0011bAA\n[\n9B+\u001a=u\t>\u001cW/\\3oiNKhnY(qi&|gn\u001d\u0005\b\u0003/a\u0001\u0019AA\r\u0003\u0019\u0019wN\u001c4jOB)A%a\u0007\u0002 %\u0019\u0011QD\u0013\u0003\r=\u0003H/[8o!\ra\u0017\u0011E\u0005\u0004\u0003Gi'!I*z]\u000eD'o\u001c8ju\u0006$\u0018n\u001c8DY&,g\u000e^\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\u0018AC5oSRL\u0017\r\\5{KR\u0011\u0011\u0011\u0006\t\u0007\u0003W\t\t$!\u000e\u000e\u0005\u00055\"bAA\u0018K\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005M\u0012Q\u0006\u0002\u0007\rV$XO]3\u0011\u0007\u0011\n9$C\u0002\u0002:\u0015\u0012A!\u00168ji\u0006qqN\\(qK:$unY;nK:$H\u0003BA\u001b\u0003\u007fAq!!\u0011\u000f\u0001\u0004\t\u0019%\u0001\u0005e_\u000e,X.\u001a8u!\r\u0019\u0014QI\u0005\u0004\u0003\u000f:\"AD(qK:,G\rR8dk6,g\u000e^\u0001\u0013I>\u001cW/\\3oi^\u000b7o\u00115b]\u001e,G\r\u0006\u0003\u00026\u00055\u0003bBA!\u001f\u0001\u0007\u0011q\n\t\u0004g\u0005E\u0013bAA*/\ty1\t[1oO\u0016$Gi\\2v[\u0016tG/A\bp]\u000ecwn]3E_\u000e,X.\u001a8u)\u0011\t)$!\u0017\t\u000f\u0005m\u0003\u00031\u0001\u0002^\u0005\u0019QO]5\u0011\t\u0005}\u0013q\r\b\u0005\u0003C\n\u0019\u0007\u0005\u0002=K%\u0019\u0011QM\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'J\u0001\u0010I\u0016$XM]7j]\u0016\u001c\u0016P\u001c;bqR1\u0011QLA9\u0003kBq!a\u001d\u0012\u0001\u0004\ti&A\u0002ve2Dq!a\u001e\u0012\u0001\u0004\ti&\u0001\u0003uKb$\u0018a\u00023jI>\u0003XM\u001c\u000b\u0005\u0003k\ti\bC\u0004\u0002\u0000I\u0001\r!!!\u0002\rA\f'/Y7t!\ra\u00171Q\u0005\u0004\u0003\u000bk'!\u0007#jI>\u0003XM\u001c+fqR$unY;nK:$\b+\u0019:b[N\f\u0011\u0002Z5e\u0007\"\fgnZ3\u0015\t\u0005U\u00121\u0012\u0005\b\u0003\u007f\u001a\u0002\u0019AAG!\ra\u0017qR\u0005\u0004\u0003#k'a\u0007#jI\u000eC\u0017M\\4f)\u0016DH\u000fR8dk6,g\u000e\u001e)be\u0006l7/\u0001\u0005eS\u0012\u001cEn\\:f)\u0011\t)$a&\t\u000f\u0005}D\u00031\u0001\u0002\u001aB\u0019A.a'\n\u0007\u0005uUN\u0001\u000eES\u0012\u001cEn\\:f)\u0016DH\u000fR8dk6,g\u000e\u001e)be\u0006l7/\u0001\u0005eS\u00124unY;t)\u0011\t)$a)\t\u000f\u0005}T\u00031\u0001\u0002&B\u0019!&a*\n\u0007\u0005%6F\u0001\bES\u00124unY;t!\u0006\u0014\u0018-\\:")
public class TextDocumentManager
implements AlsTextDocumentSyncConsumer {
    private final TextDocumentContainer uriToEditor;
    private final List<TextListener> dependencies;
    private final Logger logger;
    private final Platform platform;
    private final TextDocumentSyncConfigType$ type;

    public TextDocumentContainer uriToEditor() {
        return this.uriToEditor;
    }

    public List<TextListener> dependencies() {
        return this.dependencies;
    }

    private Logger logger() {
        return this.logger;
    }

    private Platform platform() {
        return this.platform;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        this.logger().debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$1 = None$.MODULE$;
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$3 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option x$4 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option)x$2, (Option)x$3, x$4, x$5, (Option)x$1));
    }

    public Future<BoxedUnit> initialize() {
        return this.uriToEditor().initialize();
    }

    public void onOpenDocument(OpenedDocument document) {
        this.logger().debug(new StringBuilder(19).append("Document is opened ").append(document.uri()).toString(), "EditorManager", "onOpenDocument");
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), syntax)));
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.notify(document.uri(), OPEN_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void documentWasChanged(ChangedDocument document) {
        this.logger().debug(new StringBuilder(20).append("Document is changed ").append(document.uri()).toString(), "EditorManager", "onChangeDocument");
        this.uriToEditor().get(document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
            TextDocumentManager.$anonfun$documentWasChanged$1(this, document, current);
            return BoxedUnit.UNIT;
        });
        String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), syntax)));
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.notify(document.uri(), CHANGE_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public void onCloseDocument(String uri) {
        this.uriToEditor().remove(uri);
        this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.notify(uri, CLOSE_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.onOpenDocument(new OpenedDocument(URIImplicits$.MODULE$.StringUriImplicits(params.textDocument().uri()).toAmfUri(this.platform()), params.textDocument().version(), params.textDocument().text()));
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.text());
        this.documentWasChanged(new ChangedDocument(URIImplicits$.MODULE$.StringUriImplicits(document.uri()).toAmfUri(this.platform()), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.onCloseDocument(URIImplicits$.MODULE$.StringUriImplicits(params.textDocument().uri()).toAmfUri(this.platform()));
    }

    @Override
    public void didFocus(DidFocusParams params) {
        this.uriToEditor().get(URIImplicits$.MODULE$.StringUriImplicits(params.uri()).toAmfUri(this.platform())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            TextDocumentManager.$anonfun$didFocus$1(this, params, x$5);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(TextDocumentManager $this, ChangedDocument document$2, TextDocument current) {
        block1: {
            int currentVersion = current.version();
            String currentText = current.text();
            if (currentVersion == document$2.version()) {
                $this.logger().debug(new StringBuilder(63).append("Version of the reported change is equal to the previous one at ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
            }
            if (document$2.version() >= currentVersion || !document$2.text().contains((Object)currentText)) break block1;
            $this.logger().debug(new StringBuilder(24).append("No changes detected for ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
        }
    }

    public static final /* synthetic */ void $anonfun$didFocus$1(TextDocumentManager $this, DidFocusParams params$1, TextDocument x$5) {
        $this.dependencies().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.notify(params$1.uri(), FOCUS_FILE$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public TextDocumentManager(TextDocumentContainer uriToEditor, List<TextListener> dependencies, Logger logger) {
        this.uriToEditor = uriToEditor;
        this.dependencies = dependencies;
        this.logger = logger;
        this.platform = uriToEditor.platform();
        this.type = TextDocumentSyncConfigType$.MODULE$;
    }
}

