/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import amf.core.internal.remote.Platform;
import java.io.Serializable;
import org.mulesoft.als.common.URIImplicits$;
import org.mulesoft.als.logger.Logger;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.FOCUS_FILE$;
import org.mulesoft.als.server.modules.ast.OPEN_FILE$;
import org.mulesoft.als.server.modules.ast.TextListener;
import org.mulesoft.als.server.protocol.textsync.AlsTextDocumentSyncConsumer;
import org.mulesoft.als.server.protocol.textsync.DidFocusParams;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.als.server.textsync.TextDocumentContainer;
import org.mulesoft.lsp.edit.TextEdit;
import org.mulesoft.lsp.feature.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t%\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0005A!b\u0001\n#y\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000bY\u0003A\u0011A,\t\u000fq\u0003!\u0019!C\u0006;\"1!\u000e\u0001Q\u0001\nyCqa\u001b\u0001C\u0002\u0013\u0005C\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001c\u0005\u0006k\u0002!\tE\u001e\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u00131\u0003V3yi\u0012{7-^7f]Rl\u0015M\\1hKJT!\u0001G\r\u0002\u0011Q,\u0007\u0010^:z]\u000eT!AG\u000e\u0002\rM,'O^3s\u0015\taR$A\u0002bYNT!AH\u0010\u0002\u00115,H.Z:pMRT\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+]5\t1F\u0003\u0002\u0019Y)\u0011Q&G\u0001\taJ|Go\\2pY&\u0011qf\u000b\u0002\u001c\u00032\u001cH+\u001a=u\t>\u001cW/\\3oiNKhnY\"p]N,X.\u001a:\u0002\u0017U\u0014\u0018\u000eV8FI&$xN]\u000b\u0002eA\u00111\u0007N\u0007\u0002/%\u0011Qg\u0006\u0002\u0016)\u0016DH\u000fR8dk6,g\u000e^\"p]R\f\u0017N\\3s\u00031)(/\u001b+p\u000b\u0012LGo\u001c:!\u00031!W\r]3oI\u0016t7-[3t+\u0005I\u0004c\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u0005\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0005\u0005+\u0013a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013A\u0001T5ti*\u0011\u0011)\n\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b1!Y:u\u0015\tQ\u0015$A\u0004n_\u0012,H.Z:\n\u00051;%\u0001\u0004+fqRd\u0015n\u001d;f]\u0016\u0014\u0018!\u00043fa\u0016tG-\u001a8dS\u0016\u001c\b%\u0001\u0004m_\u001e<WM]\u000b\u0002!B\u0011\u0011kU\u0007\u0002%*\u0011ajG\u0005\u0003)J\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taK&l\u0017\t\u0003g\u0001AQ\u0001M\u0004A\u0002IBQaN\u0004A\u0002eBQAT\u0004A\u0002A\u000b\u0001\u0002\u001d7bi\u001a|'/\\\u000b\u0002=B\u0011q\f[\u0007\u0002A*\u0011\u0011MY\u0001\u0007e\u0016lw\u000e^3\u000b\u0005\r$\u0017\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u00154\u0017\u0001B2pe\u0016T\u0011aZ\u0001\u0004C64\u0017BA5a\u0005!\u0001F.\u0019;g_Jl\u0017!\u00039mCR4wN]7!\u0003\u0011!\u0018\u0010]3\u0016\u00035t!A\u001c:\u000e\u0003=T!\u0001\u00079\u000b\u0005El\u0012a\u00017ta&\u00111o\\\u0001\u001b)\u0016DH\u000fR8dk6,g\u000e^*z]\u000e\u001cuN\u001c4jORK\b/Z\u0001\u0006if\u0004X\rI\u0001\fCB\u0004H._\"p]\u001aLw\rF\u0002x\u00033\u0001RA\u000f={\u0003'I!!\u001f#\u0003\r\u0015KG\u000f[3s!\rY\u0018Q\u0002\b\u0004y\u0006%abA?\u0002\b9\u0019a0!\u0002\u000f\u0007}\f\u0019AD\u0002=\u0003\u0003I\u0011\u0001I\u0005\u0003=}I!!]\u000f\n\u0005a\u0001\u0018bAA\u0006_\u0006!B+\u001a=u\t>\u001cW/\\3oiNKhnY&j]\u0012LA!a\u0004\u0002\u0012\t!B+\u001a=u\t>\u001cW/\\3oiNKhnY&j]\u0012T1!a\u0003p!\rq\u0017QC\u0005\u0004\u0003/y'a\u0006+fqR$unY;nK:$8+\u001f8d\u001fB$\u0018n\u001c8t\u0011\u001d\tY\u0002\u0004a\u0001\u0003;\taaY8oM&<\u0007#\u0002\u0013\u0002 \u0005\r\u0012bAA\u0011K\t1q\n\u001d;j_:\u00042A\\A\u0013\u0013\r\t9c\u001c\u0002\"'ft7\r\u001b:p]&T\u0018\r^5p]\u000ec\u0017.\u001a8u\u0007\u0006\u0004\u0018MY5mSRLWm]\u0001\u000bS:LG/[1mSj,GCAA\u0017!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003g)\u0013AC2p]\u000e,(O]3oi&!\u0011qGA\u0019\u0005\u00191U\u000f^;sKB\u0019A%a\u000f\n\u0007\u0005uRE\u0001\u0003V]&$\u0018AD8o\u001fB,g\u000eR8dk6,g\u000e\u001e\u000b\u0005\u0003[\t\u0019\u0005C\u0004\u0002F9\u0001\r!a\u0012\u0002\u0011\u0011|7-^7f]R\u00042aMA%\u0013\r\tYe\u0006\u0002\u000f\u001fB,g.\u001a3E_\u000e,X.\u001a8u\u0003I!wnY;nK:$x+Y:DQ\u0006tw-\u001a3\u0015\t\u00055\u0012\u0011\u000b\u0005\b\u0003\u000bz\u0001\u0019AA*!\r\u0019\u0014QK\u0005\u0004\u0003/:\"aD\"iC:<W\r\u001a#pGVlWM\u001c;\u0002\u001f=t7\t\\8tK\u0012{7-^7f]R$B!!\f\u0002^!9\u0011q\f\tA\u0002\u0005\u0005\u0014aA;sSB!\u00111MA6\u001d\u0011\t)'a\u001a\u0011\u0005q*\u0013bAA5K\u00051\u0001K]3eK\u001aLA!!\u001c\u0002p\t11\u000b\u001e:j]\u001eT1!!\u001b&\u0003=!W\r^3s[&tWmU=oi\u0006DHCBA1\u0003k\nI\bC\u0004\u0002xE\u0001\r!!\u0019\u0002\u0007U\u0014H\u000eC\u0004\u0002|E\u0001\r!!\u0019\u0002\tQ,\u0007\u0010^\u0001\bI&$w\n]3o)\u0011\ti#!!\t\u000f\u0005\r%\u00031\u0001\u0002\u0006\u00061\u0001/\u0019:b[N\u00042A\\AD\u0013\r\tIi\u001c\u0002\u001a\t&$w\n]3o)\u0016DH\u000fR8dk6,g\u000e\u001e)be\u0006l7/A\u0005eS\u0012\u001c\u0005.\u00198hKR!\u0011QFAH\u0011\u001d\t\u0019i\u0005a\u0001\u0003#\u00032A\\AJ\u0013\r\t)j\u001c\u0002\u001c\t&$7\t[1oO\u0016$V\r\u001f;E_\u000e,X.\u001a8u!\u0006\u0014\u0018-\\:\u0002\u0011\u0011LGm\u00117pg\u0016$B!!\f\u0002\u001c\"9\u00111\u0011\u000bA\u0002\u0005u\u0005c\u00018\u0002 &\u0019\u0011\u0011U8\u00035\u0011KGm\u00117pg\u0016$V\r\u001f;E_\u000e,X.\u001a8u!\u0006\u0014\u0018-\\:\u0002\u0011\u0011LGMR8dkN$B!!\f\u0002(\"9\u00111Q\u000bA\u0002\u0005%\u0006c\u0001\u0016\u0002,&\u0019\u0011QV\u0016\u0003\u001d\u0011KGMR8dkN\u0004\u0016M]1ng\u0002")
public class TextDocumentManager
implements AlsTextDocumentSyncConsumer {
    private final TextDocumentContainer uriToEditor;
    private final List<TextListener> dependencies;
    private final Logger logger;
    private final Platform platform;
    private final TextDocumentSyncConfigType$ type;

    @Override
    public TextDocumentContainer uriToEditor() {
        return this.uriToEditor;
    }

    public List<TextListener> dependencies() {
        return this.dependencies;
    }

    public Logger logger() {
        return this.logger;
    }

    private Platform platform() {
        return this.platform;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        this.logger().debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$1 = None$.MODULE$;
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$3 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option x$4 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option)x$2, (Option)x$3, x$4, x$5, (Option)x$1));
    }

    public Future<BoxedUnit> initialize() {
        return this.uriToEditor().initialize();
    }

    public Future<BoxedUnit> onOpenDocument(OpenedDocument document) {
        this.logger().debug(new StringBuilder(19).append("Document is opened ").append(document.uri()).toString(), "EditorManager", "onOpenDocument");
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), syntax)));
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.notify(document.uri(), OPEN_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> documentWasChanged(ChangedDocument document) {
        this.logger().debug(new StringBuilder(20).append("Document is changed ").append(document.uri()).toString(), "EditorManager", "onChangeDocument");
        this.uriToEditor().get(document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
            TextDocumentManager.$anonfun$documentWasChanged$1(this, document, current);
            return BoxedUnit.UNIT;
        });
        String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), syntax)));
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.notify(document.uri(), CHANGE_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> onCloseDocument(String uri) {
        this.logger().debug(new StringBuilder(16).append("Document closed ").append(uri).toString(), "EditorManager", "onCloseDocument");
        this.uriToEditor().remove(uri);
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.notify(uri, CLOSE_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public Future<BoxedUnit> didOpen(DidOpenTextDocumentParams params) {
        String uri = params.textDocument().uri();
        if (!URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) {
            this.logger().warning(new StringBuilder(36).append("Adding invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didOpen");
        }
        return this.onOpenDocument(new OpenedDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()), params.textDocument().version(), params.textDocument().text()));
    }

    public Future<BoxedUnit> didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.text());
        String uri = document.uri();
        if (!URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) {
            this.logger().warning(new StringBuilder(37).append("Editing invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didChange");
        }
        return this.documentWasChanged(new ChangedDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    public Future<BoxedUnit> didClose(DidCloseTextDocumentParams params) {
        String uri;
        block0: {
            uri = params.textDocument().uri();
            if (URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) break block0;
            this.logger().warning(new StringBuilder(38).append("Removing invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didClose");
        }
        return this.onCloseDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()));
    }

    @Override
    public Future<BoxedUnit> didFocus(DidFocusParams params) {
        return (Future)this.uriToEditor().get(URIImplicits$.MODULE$.StringUriImplicits(params.uri()).toAmfUri(this.platform())).map((Function1 & Serializable & scala.Serializable)x$8 -> Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.notify(params.uri(), FOCUS_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.unit());
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(TextDocumentManager $this, ChangedDocument document$2, TextDocument current) {
        block1: {
            int currentVersion = current.version();
            String currentText = current.text();
            if (currentVersion == document$2.version()) {
                $this.logger().debug(new StringBuilder(63).append("Version of the reported change is equal to the previous one at ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
            }
            if (document$2.version() >= currentVersion || !document$2.text().contains((Object)currentText)) break block1;
            $this.logger().debug(new StringBuilder(24).append("No changes detected for ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
        }
    }

    public TextDocumentManager(TextDocumentContainer uriToEditor, List<TextListener> dependencies, Logger logger) {
        this.uriToEditor = uriToEditor;
        this.dependencies = dependencies;
        this.logger = logger;
        this.platform = uriToEditor.platform();
        this.type = TextDocumentSyncConfigType$.MODULE$;
    }
}

