/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.textsync;

import amf.core.internal.remote.Platform;
import java.io.Serializable;
import org.mulesoft.als.common.URIImplicits$;
import org.mulesoft.als.logger.Logger$;
import org.mulesoft.als.server.modules.ast.CHANGE_FILE$;
import org.mulesoft.als.server.modules.ast.CLOSE_FILE$;
import org.mulesoft.als.server.modules.ast.FOCUS_FILE$;
import org.mulesoft.als.server.modules.ast.OPEN_FILE$;
import org.mulesoft.als.server.modules.ast.TextListener;
import org.mulesoft.als.server.protocol.textsync.AlsTextDocumentSyncConsumer;
import org.mulesoft.als.server.protocol.textsync.DidFocusParams;
import org.mulesoft.als.server.textsync.ChangedDocument;
import org.mulesoft.als.server.textsync.OpenedDocument;
import org.mulesoft.als.server.textsync.TextDocument;
import org.mulesoft.als.server.textsync.TextDocumentContainer;
import org.mulesoft.lsp.edit.TextEdit;
import org.mulesoft.lsp.feature.common.VersionedTextDocumentIdentifier;
import org.mulesoft.lsp.textsync.DidChangeTextDocumentParams;
import org.mulesoft.lsp.textsync.DidCloseTextDocumentParams;
import org.mulesoft.lsp.textsync.DidOpenTextDocumentParams;
import org.mulesoft.lsp.textsync.SynchronizationClientCapabilities;
import org.mulesoft.lsp.textsync.TextDocumentSyncConfigType$;
import org.mulesoft.lsp.textsync.TextDocumentSyncKind$;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions;
import org.mulesoft.lsp.textsync.TextDocumentSyncOptions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\f\u0001\u0003\u0006\u0004%\te\f\u0005\ti\u0001\u0011\t\u0011)A\u0005a!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005L\u0001\t\u0005\t\u0015!\u00038\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d\t\u0006A1A\u0005\fICaa\u0018\u0001!\u0002\u0013\u0019\u0006b\u00021\u0001\u0005\u0004%\t%\u0019\u0005\u0007S\u0002\u0001\u000b\u0011\u00022\t\u000b)\u0004A\u0011I6\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0012\u0001\u0005B\u0005=%a\u0005+fqR$unY;nK:$X*\u00198bO\u0016\u0014(B\u0001\f\u0018\u0003!!X\r\u001f;ts:\u001c'B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\u0011!dG\u0001\u0004C2\u001c(B\u0001\u000f\u001e\u0003!iW\u000f\\3t_\u001a$(\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q1j\u0011!\u000b\u0006\u0003-)R!aK\f\u0002\u0011A\u0014x\u000e^8d_2L!!L\u0015\u00037\u0005c7\u000fV3yi\u0012{7-^7f]R\u001c\u0016P\\2D_:\u001cX/\\3s\u0003-)(/\u001b+p\u000b\u0012LGo\u001c:\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003UI!aM\u000b\u0003+Q+\u0007\u0010\u001e#pGVlWM\u001c;D_:$\u0018-\u001b8fe\u0006aQO]5U_\u0016#\u0017\u000e^8sA\u0005aA-\u001a9f]\u0012,gnY5fgV\tq\u0007E\u00029\u0001\u000es!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005qz\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\ty4%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%\u0001\u0002'jgRT!aP\u0012\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015aA1ti*\u0011\u0001jF\u0001\b[>$W\u000f\\3t\u0013\tQUI\u0001\u0007UKb$H*[:uK:,'/A\u0007eKB,g\u000eZ3oG&,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079{\u0005\u000b\u0005\u00022\u0001!)a&\u0002a\u0001a!)Q'\u0002a\u0001o\u0005A\u0001\u000f\\1uM>\u0014X.F\u0001T!\t!V,D\u0001V\u0015\t1v+\u0001\u0004sK6|G/\u001a\u0006\u00031f\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035n\u000bAaY8sK*\tA,A\u0002b[\u001aL!AX+\u0003\u0011Ac\u0017\r\u001e4pe6\f\u0011\u0002\u001d7bi\u001a|'/\u001c\u0011\u0002\tQL\b/Z\u000b\u0002E:\u00111mZ\u0007\u0002I*\u0011a#\u001a\u0006\u0003Mn\t1\u0001\\:q\u0013\tAG-\u0001\u000eUKb$Hi\\2v[\u0016tGoU=oG\u000e{gNZ5h)f\u0004X-A\u0003usB,\u0007%A\u0006baBd\u0017pQ8oM&<Gc\u00017\u0002\u0004A!\u0001(\\8\u007f\u0013\tq'I\u0001\u0004FSRDWM\u001d\t\u0003ant!!]=\u000f\u0005IDhBA:x\u001d\t!hO\u0004\u0002;k&\ta$\u0003\u0002\u001d;%\u0011amG\u0005\u0003-\u0015L!A\u001f3\u0002)Q+\u0007\u0010\u001e#pGVlWM\u001c;Ts:\u001c7*\u001b8e\u0013\taXP\u0001\u000bUKb$Hi\\2v[\u0016tGoU=oG.Kg\u000e\u001a\u0006\u0003u\u0012\u0004\"aY@\n\u0007\u0005\u0005AMA\fUKb$Hi\\2v[\u0016tGoU=oG>\u0003H/[8og\"9\u0011Q\u0001\u0006A\u0002\u0005\u001d\u0011AB2p]\u001aLw\rE\u0003#\u0003\u0013\ti!C\u0002\u0002\f\r\u0012aa\u00149uS>t\u0007cA2\u0002\u0010%\u0019\u0011\u0011\u00033\u0003CMKhn\u00195s_:L'0\u0019;j_:\u001cE.[3oi\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002\u0002\u0018A1\u0011\u0011DA\u0010\u0003Gi!!a\u0007\u000b\u0007\u0005u1%\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\t\u0002\u001c\t1a)\u001e;ve\u0016\u00042AIA\u0013\u0013\r\t9c\t\u0002\u0005+:LG/\u0001\bp]>\u0003XM\u001c#pGVlWM\u001c;\u0015\t\u0005]\u0011Q\u0006\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003!!wnY;nK:$\bcA\u0019\u00024%\u0019\u0011QG\u000b\u0003\u001d=\u0003XM\\3e\t>\u001cW/\\3oi\u0006\u0011Bm\\2v[\u0016tGoV1t\u0007\"\fgnZ3e)\u0011\t9\"a\u000f\t\u000f\u0005=R\u00021\u0001\u0002>A\u0019\u0011'a\u0010\n\u0007\u0005\u0005SCA\bDQ\u0006tw-\u001a3E_\u000e,X.\u001a8u\u0003=ygn\u00117pg\u0016$unY;nK:$H\u0003BA\f\u0003\u000fBq!!\u0013\u000f\u0001\u0004\tY%A\u0002ve&\u0004B!!\u0014\u0002V9!\u0011qJA)!\tQ4%C\u0002\u0002T\r\na\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u0012aa\u0015;sS:<'bAA*G\u0005yA-\u001a;fe6Lg.Z*z]R\f\u0007\u0010\u0006\u0004\u0002L\u0005}\u00131\r\u0005\b\u0003Cz\u0001\u0019AA&\u0003\r)(\u000f\u001c\u0005\b\u0003Kz\u0001\u0019AA&\u0003\u0011!X\r\u001f;\u0002\u000f\u0011LGm\u00149f]R!\u0011qCA6\u0011\u001d\ti\u0007\u0005a\u0001\u0003_\na\u0001]1sC6\u001c\bcA2\u0002r%\u0019\u00111\u000f3\u00033\u0011KGm\u00149f]R+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn]\u0001\nI&$7\t[1oO\u0016$B!a\u0006\u0002z!9\u0011QN\tA\u0002\u0005m\u0004cA2\u0002~%\u0019\u0011q\u00103\u00037\u0011KGm\u00115b]\u001e,G+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u0003!!\u0017\u000eZ\"m_N,G\u0003BA\f\u0003\u000bCq!!\u001c\u0013\u0001\u0004\t9\tE\u0002d\u0003\u0013K1!a#e\u0005i!\u0015\u000eZ\"m_N,G+\u001a=u\t>\u001cW/\\3oiB\u000b'/Y7t\u0003!!\u0017\u000e\u001a$pGV\u001cH\u0003BA\f\u0003#Cq!!\u001c\u0014\u0001\u0004\t\u0019\nE\u0002)\u0003+K1!a&*\u00059!\u0015\u000e\u001a$pGV\u001c\b+\u0019:b[N\u0004")
public class TextDocumentManager
implements AlsTextDocumentSyncConsumer {
    private final TextDocumentContainer uriToEditor;
    private final List<TextListener> dependencies;
    private final Platform platform;
    private final TextDocumentSyncConfigType$ type;

    @Override
    public TextDocumentContainer uriToEditor() {
        return this.uriToEditor;
    }

    public List<TextListener> dependencies() {
        return this.dependencies;
    }

    private Platform platform() {
        return this.platform;
    }

    public TextDocumentSyncConfigType$ type() {
        return this.type;
    }

    public Either<Enumeration.Value, TextDocumentSyncOptions> applyConfig(Option<SynchronizationClientCapabilities> config) {
        Logger$.MODULE$.debug("Config applied", "TextDocumentManager", "applyConfig");
        None$ x$1 = None$.MODULE$;
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$3 = new Some((Object)TextDocumentSyncKind$.MODULE$.Full());
        Option x$4 = TextDocumentSyncOptions$.MODULE$.apply$default$3();
        Option x$5 = TextDocumentSyncOptions$.MODULE$.apply$default$4();
        return package$.MODULE$.Right().apply((Object)new TextDocumentSyncOptions((Option)x$2, (Option)x$3, x$4, x$5, (Option)x$1));
    }

    public Future<BoxedUnit> initialize() {
        return this.uriToEditor().initialize();
    }

    public Future<BoxedUnit> onOpenDocument(OpenedDocument document) {
        Logger$.MODULE$.debug(new StringBuilder(19).append("Document is opened ").append(document.uri()).toString(), "EditorManager", "onOpenDocument");
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), document.text(), syntax)));
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.notify(document.uri(), OPEN_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> documentWasChanged(ChangedDocument document) {
        Logger$.MODULE$.debug(new StringBuilder(20).append("Document is changed ").append(document.uri()).toString(), "EditorManager", "onChangeDocument");
        this.uriToEditor().get(document.uri()).foreach((Function1 & Serializable & scala.Serializable)current -> {
            TextDocumentManager.$anonfun$documentWasChanged$1(document, current);
            return BoxedUnit.UNIT;
        });
        String syntax = this.determineSyntax(document.uri(), (String)document.text().get());
        this.uriToEditor().$plus((Tuple2<String, TextDocument>)new Tuple2((Object)document.uri(), (Object)new TextDocument(document.uri(), document.version(), (String)document.text().get(), syntax)));
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.notify(document.uri(), CHANGE_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> onCloseDocument(String uri) {
        Logger$.MODULE$.debug(new StringBuilder(16).append("Document closed ").append(uri).toString(), "EditorManager", "onCloseDocument");
        this.uriToEditor().remove(uri);
        return Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.notify(uri, CLOSE_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public Future<BoxedUnit> didOpen(DidOpenTextDocumentParams params) {
        String uri = params.textDocument().uri();
        if (!URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) {
            Logger$.MODULE$.warning(new StringBuilder(36).append("Adding invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didOpen");
        }
        return this.onOpenDocument(new OpenedDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()), params.textDocument().version(), params.textDocument().text()));
    }

    public Future<BoxedUnit> didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.textDocument();
        int version = BoxesRunTime.unboxToInt((Object)document.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option text = params.contentChanges().headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.text());
        String uri = document.uri();
        if (!URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) {
            Logger$.MODULE$.warning(new StringBuilder(37).append("Editing invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didChange");
        }
        return this.documentWasChanged(new ChangedDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()), version, (Option<String>)text, (Option<Seq<TextEdit>>)None$.MODULE$));
    }

    public Future<BoxedUnit> didClose(DidCloseTextDocumentParams params) {
        String uri;
        block0: {
            uri = params.textDocument().uri();
            if (URIImplicits$.MODULE$.StringUriImplicits(uri).isValidFileUri()) break block0;
            Logger$.MODULE$.warning(new StringBuilder(38).append("Removing invalid URI file to manager: ").append(uri).toString(), "TextDocumentManager", "didClose");
        }
        return this.onCloseDocument(URIImplicits$.MODULE$.StringUriImplicits(uri).toAmfUri(this.platform()));
    }

    @Override
    public Future<BoxedUnit> didFocus(DidFocusParams params) {
        return (Future)this.uriToEditor().get(URIImplicits$.MODULE$.StringUriImplicits(params.uri()).toAmfUri(this.platform())).map((Function1 & Serializable & scala.Serializable)x$8 -> Future$.MODULE$.sequence((TraversableOnce)this.dependencies().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.notify(params.uri(), FOCUS_FILE$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> Future$.MODULE$.unit(), ExecutionContext.Implicits$.MODULE$.global())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.unit());
    }

    public static final /* synthetic */ void $anonfun$documentWasChanged$1(ChangedDocument document$2, TextDocument current) {
        block1: {
            int currentVersion = current.version();
            String currentText = current.text();
            if (currentVersion == document$2.version()) {
                Logger$.MODULE$.debug(new StringBuilder(63).append("Version of the reported change is equal to the previous one at ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
            }
            if (document$2.version() >= currentVersion || !document$2.text().contains((Object)currentText)) break block1;
            Logger$.MODULE$.debug(new StringBuilder(24).append("No changes detected for ").append(document$2.uri()).toString(), "EditorManager", "onChangeDocument");
        }
    }

    public TextDocumentManager(TextDocumentContainer uriToEditor, List<TextListener> dependencies) {
        this.uriToEditor = uriToEditor;
        this.dependencies = dependencies;
        AlsTextDocumentSyncConsumer.$init$(this);
        this.platform = uriToEditor.platform();
        this.type = TextDocumentSyncConfigType$.MODULE$;
    }
}

