/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.lsp4j.extension;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.adapters.InitializeParamsTypeAdapter;
import org.mulesoft.als.server.lsp4j.extension.AlsClientCapabilities;
import org.mulesoft.als.server.lsp4j.extension.AlsConfiguration;
import org.mulesoft.als.server.lsp4j.extension.AlsInitializeParams;

public class AlsInitializeParamsTypeAdapter
extends InitializeParamsTypeAdapter {
    private Gson gson;

    public AlsInitializeParamsTypeAdapter(Gson gson) {
        super(gson);
        this.gson = gson;
    }

    protected AlsClientCapabilities readCapabilities(JsonReader jsonReader) throws IOException {
        return (AlsClientCapabilities)((Object)this.gson.fromJson(jsonReader, AlsClientCapabilities.class));
    }

    protected AlsConfiguration readConfiguration(JsonReader jsonReader) throws IOException {
        return (AlsConfiguration)this.gson.fromJson(jsonReader, AlsConfiguration.class);
    }

    public AlsInitializeParams read(JsonReader jsonReader) throws IOException {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            return null;
        }
        AlsInitializeParams alsInitializeParams = new AlsInitializeParams();
        jsonReader.beginObject();
        block30: while (jsonReader.hasNext()) {
            String string;
            switch (string = jsonReader.nextName()) {
                case "processId": {
                    alsInitializeParams.setProcessId(this.readProcessId(jsonReader));
                    continue block30;
                }
                case "rootPath": {
                    alsInitializeParams.setRootPath(this.readRootPath(jsonReader));
                    continue block30;
                }
                case "rootUri": {
                    alsInitializeParams.setRootUri(this.readRootUri(jsonReader));
                    continue block30;
                }
                case "initializationOptions": {
                    alsInitializeParams.setInitializationOptions(this.readInitializationOptions(jsonReader));
                    continue block30;
                }
                case "capabilities": {
                    alsInitializeParams.setCapabilities(this.readCapabilities(jsonReader));
                    continue block30;
                }
                case "clientInfo": {
                    alsInitializeParams.setClientInfo(this.readClientInfo(jsonReader));
                    continue block30;
                }
                case "clientName": {
                    Optional.ofNullable(alsInitializeParams.getClientInfo()).ifPresent(clientInfo -> {
                        try {
                            alsInitializeParams.setClientInfo(new ClientInfo(this.readClientInfo(jsonReader).getName(), clientInfo.getVersion()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    continue block30;
                }
                case "trace": {
                    alsInitializeParams.setTrace(this.readTrace(jsonReader));
                    continue block30;
                }
                case "workspaceFolders": {
                    alsInitializeParams.setWorkspaceFolders(this.readWorkspaceFolders(jsonReader));
                    continue block30;
                }
                case "configuration": {
                    alsInitializeParams.setConfiguration(this.readConfiguration(jsonReader));
                    continue block30;
                }
                case "hotReload": {
                    alsInitializeParams.setHotReload(this.readHotReload(jsonReader));
                    continue block30;
                }
                case "shouldRetryExternalFragments": {
                    alsInitializeParams.setShouldRetryExternalFragments(this.readShouldRetryExternalFragments(jsonReader));
                    continue block30;
                }
                case "maxFileSize": {
                    alsInitializeParams.setMaxFileSize(this.readMaxFileSize(jsonReader));
                    continue block30;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return alsInitializeParams;
    }

    private Boolean readHotReload(JsonReader jsonReader) {
        return (Boolean)this.gson.fromJson(jsonReader, Boolean.class);
    }

    private Boolean readShouldRetryExternalFragments(JsonReader jsonReader) {
        return (Boolean)this.gson.fromJson(jsonReader, Boolean.class);
    }

    private Integer readMaxFileSize(JsonReader jsonReader) {
        return (Integer)this.gson.fromJson(jsonReader, Integer.class);
    }

    protected void writeCapabilities(JsonWriter jsonWriter, ClientCapabilities clientCapabilities) throws IOException {
        this.gson.toJson((Object)clientCapabilities, AlsClientCapabilities.class, jsonWriter);
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!AlsInitializeParams.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new AlsInitializeParamsTypeAdapter(gson);
        }
    }
}

