/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.server.lsp4j;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticCodeDescription;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.mulesoft.als.server.lsp4j.LspConversions$;
import org.mulesoft.als.server.lsp4j.extension.AlsClientCapabilities;
import org.mulesoft.als.server.lsp4j.extension.AlsInitializeParams;
import org.mulesoft.lsp.configuration.TextDocumentClientCapabilities;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t\tBj]\"p]Z,'\u000f^5p]N$Vm\u001d;\u000b\u0005\u0011)\u0011!\u00027taRR'B\u0001\u0004\b\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001\"C\u0001\u0004C2\u001c(B\u0001\u0006\f\u0003!iW\u000f\\3t_\u001a$(\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0016\u001b\u0005\t\"B\u0001\n\u0014\u0003!1WO\\:vSR,'B\u0001\u000b\f\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0017#\tY\u0011I\\=Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\u0001")
public class LsConvertionsTest
extends AnyFunSuite {
    public LsConvertionsTest() {
        this.test("Empty InitializeParams Conversions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.mulesoft.als.server.protocol.configuration.AlsInitializeParams internalParams = LspConversions$.MODULE$.alsInitializeParams(new AlsInitializeParams());
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 16));
        this.test("Empty sons of InitializeParams Conversions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AlsInitializeParams clientParams = new AlsInitializeParams();
            clientParams.setCapabilities(new ClientCapabilities());
            WorkspaceFolder folder = new WorkspaceFolder();
            clientParams.setWorkspaceFolders((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)folder, (List)Nil$.MODULE$)).asJava());
            clientParams.setInitializationOptions(new Object());
            clientParams.setHotReload(Predef$.MODULE$.boolean2Boolean(true));
            org.mulesoft.als.server.protocol.configuration.AlsInitializeParams internalParams = LspConversions$.MODULE$.alsInitializeParams(clientParams);
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 21));
        this.test("Empty sons of client capabilities", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AlsClientCapabilities capabilities = new AlsClientCapabilities();
            capabilities.setTextDocument(new org.eclipse.lsp4j.TextDocumentClientCapabilities());
            capabilities.setWorkspace(new WorkspaceClientCapabilities());
            org.mulesoft.als.server.protocol.configuration.AlsClientCapabilities internal = LspConversions$.MODULE$.clientCapabilities(capabilities);
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Empty sons of text document client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.eclipse.lsp4j.TextDocumentClientCapabilities documentClient = new org.eclipse.lsp4j.TextDocumentClientCapabilities();
            documentClient.setSynchronization(new SynchronizationCapabilities());
            documentClient.setPublishDiagnostics(new PublishDiagnosticsCapabilities());
            documentClient.setCompletion(new CompletionCapabilities());
            documentClient.setReferences(new ReferencesCapabilities());
            documentClient.setDocumentSymbol(new DocumentSymbolCapabilities());
            documentClient.setDefinition(new DefinitionCapabilities());
            documentClient.setRename(new RenameCapabilities());
            TextDocumentClientCapabilities internal = org.mulesoft.lsp.LspConversions$.MODULE$.textDocumentClientCapabilities(documentClient);
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("Full Diagnostic conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Diagnostic clientDiagnostic = new Diagnostic();
            clientDiagnostic.setCode(Predef$.MODULE$.int2Integer(2));
            clientDiagnostic.setCodeDescription(new DiagnosticCodeDescription("https://a.ml/error-codes/code/1"));
            clientDiagnostic.setMessage("Message");
            clientDiagnostic.setTags(new ArrayList());
            Position start = new Position(0, 1);
            Position end = new Position(1, 1);
            clientDiagnostic.setRange(new Range(start, end));
            clientDiagnostic.setRelatedInformation(new ArrayList());
            clientDiagnostic.setSeverity(DiagnosticSeverity.Information);
            clientDiagnostic.setSource("Source");
            org.mulesoft.lsp.feature.diagnostic.Diagnostic internalDiagnostic = org.mulesoft.lsp.LspConversions$.MODULE$.diagnostic(clientDiagnostic);
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Diagnostic Only mandatory fields conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Position start = new Position(0, 1);
            Position end = new Position(1, 1);
            Diagnostic clientDiagnostic = new Diagnostic(new Range(start, end), "Message");
            org.mulesoft.lsp.feature.diagnostic.Diagnostic internalDiagnostic = org.mulesoft.lsp.LspConversions$.MODULE$.diagnostic(clientDiagnostic);
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("Empty clientDiagnostic conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Diagnostic clientDiagnostic = new Diagnostic();
            try {
                org.mulesoft.lsp.feature.diagnostic.Diagnostic internalDiagnostic = org.mulesoft.lsp.LspConversions$.MODULE$.diagnostic(clientDiagnostic);
                assertion = BoxedUnit.UNIT;
            }
            catch (NullPointerException nullPointerException) {
                assertion = this.succeed();
            }
            catch (Throwable e) {
                throw this.fail("Unexpected error on empty clientDiagnostic conversion test", e, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            }
            return assertion;
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("Diagnostic with empty related information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Position start = new Position(0, 1);
            Position end = new Position(1, 1);
            Diagnostic clientDiagnostic = new Diagnostic(new Range(start, end), "Message");
            org.mulesoft.lsp.feature.diagnostic.Diagnostic internalDiagnostic = org.mulesoft.lsp.LspConversions$.MODULE$.diagnostic(clientDiagnostic);
            Option relatedInformation = internalDiagnostic.relatedInformation();
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("Diagnostic with related information set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Position start = new Position(0, 1);
            Position end = new Position(1, 1);
            Diagnostic clientDiagnostic = new Diagnostic(new Range(start, end), "Message");
            DiagnosticRelatedInformation relatedInformation = new DiagnosticRelatedInformation(new Location("uri", new Range(start, end)), "Message");
            clientDiagnostic.setRelatedInformation((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)relatedInformation, (List)Nil$.MODULE$)).asJava());
            org.mulesoft.lsp.feature.diagnostic.Diagnostic internalDiagnostic = org.mulesoft.lsp.LspConversions$.MODULE$.diagnostic(clientDiagnostic);
            Option internalRelatedInformation = internalDiagnostic.relatedInformation();
            return this.succeed();
        }, new org.scalactic.source.Position("LsConvertionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }
}

