package org.mulesoft.als.server.modules.actions.links

import org.mulesoft.als.server.modules.workspace.CompilableUnit
import org.mulesoft.als.server.workspace.WorkspaceManager
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global
import org.mulesoft.amfintegration.relationships.{AliasInfo, RelationshipLink}

import scala.concurrent.Future


object LinkKnowledge {
  def getUnitWithLinks(workspace: WorkspaceManager, uri: String, uuid: String): Future[UnitWithLinks] =
    for {
      cu <- workspace
        .getLastUnit(uri, uuid)
        .flatMap(_.getLast)
      aliases <- workspace.getAliases(uri, uuid)
      relationships <- workspace.getRelationships(uri, uuid)
    } yield UnitWithLinks(cu, aliases, relationships._2)
}

case class UnitWithLinks(cu: CompilableUnit, aliases: Seq[AliasInfo], relationships: Seq[RelationshipLink])