package org.mulesoft.als.server.modules.actions.rename

import amf.core.client.scala.model.document.Document
import amf.core.internal.remote.Spec
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.als.common.YPartASTWrapper.AlsYScalarOps
import org.mulesoft.als.common.dtoTypes.{Position, PositionRange}
import org.mulesoft.als.common.{ASTPartBranch, ObjectInTree}
import org.mulesoft.als.server.modules.workspace.CompilableUnit
import org.mulesoft.amfintegration.AmfImplicits.AmfObjectImp
import org.mulesoft.amfintegration.dialect.dialects.metadialect.MetaDialect
import org.mulesoft.amfintegration.relationships.RelationshipLink
import org.mulesoft.amfintegration.vocabularies.jsonschema.agentnetwork.AgentNetworkVocabulary
import org.yaml.model.{YMap, YMapEntry, YScalar}

trait RenameTools {

  protected def branch(cu: CompilableUnit, position: Position, uri: String): ASTPartBranch =
    cu.astPartBranch.getCachedOrNew(position, uri)

  protected def tree(cu: CompilableUnit, position: Position, uri: String): ObjectInTree =
    cu.tree.getCachedOrNew(position, uri)

  private def isDeclarable(cu: CompilableUnit, tree: ObjectInTree, relationships: Seq[RelationshipLink]): Boolean =
    !tree.obj.isAbstract &&
      !tree.obj.isInstanceOf[Document] &&
      (tree.obj.declarableKey(cu.documentDefinition).isDefined || isRelationshipTarget(tree, relationships) || nonAmlDefinition(cu, tree))

  private def isRelationshipTarget(tree: ObjectInTree, relationships: Seq[RelationshipLink]) = {
    tree.astPartBranch.node match {
      case entry: YMapEntry =>
        relationships.exists(rl => rl.targetEntry == entry)
      case map: YMap if map.entries.nonEmpty =>
        relationships.exists(rl => rl.targetEntry == map.entries.head)
      case _ => false
    }

  }

  private def nonAmlDefinition(cu: CompilableUnit, tree: ObjectInTree): Boolean =
    isAgentNetworkDeclaration(cu, tree)

  private def isAgentNetworkDeclaration(cu: CompilableUnit, tree: ObjectInTree) =
    cu.unit.sourceSpec.contains(Spec.AGENT_NETWORK) &&
      (tree.obj match {
        case json: JsonLDObject => json.typeIris.contains(AgentNetworkVocabulary.DECLARATIONS)
        case _ => false
      })

  protected def isDeclarableKey(cu: CompilableUnit, position: Position, uri: String, relationships: Seq[RelationshipLink]): Boolean =
    (isDeclarable(cu, tree(cu, position, uri), relationships) || cu.documentDefinition.baseUnit == MetaDialect.dialect) &&
      branch(cu, position, uri).isKey

  protected def keyCleanRange(uri: String, position: Position, bu: CompilableUnit): PositionRange =
    bu.astPartBranch.getCachedOrNew(position, uri).node match {
      case s: YScalar => PositionRange(s.unmarkedRange())
      case map: YMap =>
        // in case we are at the position 0 of the first entry of a map
        map.entries.headOption.map(entry => entry.key.location.range).map(PositionRange(_)).getOrElse(PositionRange(map.location.range))
      case o          => PositionRange(o.location.range)
    }
  protected val renameThroughReferenceEnabled = false
}
