package org.mulesoft.als.server.workspace.fileusage

import org.mulesoft.lsp.feature.common.{Location, Position, Range}

trait TestEntries {
  val testSets: Set[TestEntry] = Set(
    TestEntry(
      "file:///root/t.raml",
      "api.raml",
      Map(
        "file:///root/api.raml" ->
          """#%RAML 1.0
            |types:
            |  t: !include t.raml""".stripMargin,
        "file:///root/t.raml" ->
          """#%RAML 1.0 DataType
            |type: string""".stripMargin
      ),
      Set(Location("file:///root/api.raml", Range(Position(2, 14), Position(2, 20))))
    ),
    TestEntry(
      "file:///root/l.raml",
      "api.raml",
      Map(
        "file:///root/api.raml" ->
          """#%RAML 1.0
            |uses:
            |  l: l.raml""".stripMargin,
        "file:///root/l.raml" ->
          """#%RAML 1.0 Library
            |types
            |  t: string""".stripMargin
      ),
      Set(Location("file:///root/api.raml", Range(Position(2, 5), Position(2, 11))))
    ),
    TestEntry(
      "file:///root/t.yaml",
      "api.yaml",
      Map(
        "file:///root/api.yaml" ->
          """asyncapi: "2.0.0"
            |
            |components:
            |  schemas:
            |    mySchema:
            |      $ref: "t.yaml#/mySchema"""".stripMargin,
        "file:///root/t.yaml" ->
          """mySchema:
            |  type: object
            |  properties:
            |    id: string""".stripMargin
      ),
      Set(Location("file:///root/api.yaml", Range(Position(5, 13), Position(5, 19))))
    )
    //    TestEntry(
    //      "file:///root/t.json",
    //      "api.json",
    //      Map(
    //        "file:///root/api.json" ->
    //          """{
    //            |  "$schema": "http://json-schema.org/draft-04/schema#",
    //            |
    //            |  "type": "object",
    //            |  "properties": {
    //            |    "street_address": { "type": "string" },
    //            |    "city": { "type": "string" },
    //            |    "state": { "$ref": "t.json#/definitions/state" }
    //            |  },
    //            |  "required": ["street_address", "city", "state"]
    //            |}"""".stripMargin,
    //        "file:///root/t.json" ->
    //          """{
    //            |  "$schema": "http://json-schema.org/draft-04/schema#",
    //            |
    //            |  "type": "object",
    //            |  "definitions": {
    //            |    "state": { "enum": ["CA", "NY", "... etc ..."] }
    //            |  }
    //            |}""".stripMargin
    //      ),
    //      Set(Location("file:///root/api.json", Range(Position(7, 23), Position(7, 50))))
    //    )
  )

}
case class TestEntry(
    searchedUri: String,
    mainFile: String,
    ws: Map[String, String],
    result: Set[Location],
    root: String = "file:///root/"
)
