/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.suggestions.client;

import amf.core.model.document.BaseUnit;
import amf.core.remote.Oas20$;
import amf.core.remote.Platform;
import amf.core.remote.Raml08$;
import amf.core.remote.Raml10$;
import amf.dialects.WebApiDialectsRegistry$;
import amf.internal.environment.Environment;
import amf.plugins.document.vocabularies.model.document.Dialect;
import amf.plugins.document.vocabularies.model.document.DialectInstanceUnit;
import java.io.Serializable;
import org.mulesoft.als.common.DirectoryResolver;
import org.mulesoft.als.common.dtoTypes.Position;
import org.mulesoft.als.common.dtoTypes.Position$;
import org.mulesoft.als.suggestions.CompletionProviderAST;
import org.mulesoft.als.suggestions.CompletionProviderAST$;
import org.mulesoft.als.suggestions.Core$;
import org.mulesoft.als.suggestions.HeaderCompletionProviderBuilder$;
import org.mulesoft.als.suggestions.RamlHeaderCompletionProvider$;
import org.mulesoft.als.suggestions.aml.AmlCompletionRequestBuilder$;
import org.mulesoft.als.suggestions.aml.CompletionEnvironment;
import org.mulesoft.als.suggestions.client.SuggestionsHelper;
import org.mulesoft.als.suggestions.interfaces.CompletionProvider;
import org.mulesoft.als.suggestions.interfaces.Syntax;
import org.mulesoft.als.suggestions.plugins.aml.webapi.oas.package$Oas20DialectWrapper$;
import org.mulesoft.als.suggestions.plugins.aml.webapi.raml.raml08.Raml08TypesDialect$;
import org.mulesoft.als.suggestions.plugins.aml.webapi.raml.raml10.Raml10TypesDialect$;
import org.mulesoft.amfmanager.InitOptions;
import org.mulesoft.amfmanager.InitOptions$;
import org.mulesoft.lsp.feature.completion.CompletionItem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Suggestions$
implements SuggestionsHelper {
    public static Suggestions$ MODULE$;

    static {
        new Suggestions$();
    }

    @Override
    public Future<BaseUnit> amfParse(String url, Environment environment, Platform platform) {
        return SuggestionsHelper.amfParse$(this, url, environment, platform);
    }

    @Override
    public Syntax getMediaType(String originalContent) {
        return SuggestionsHelper.getMediaType$(this, originalContent);
    }

    @Override
    public Tuple2<String, Environment> patchContentInEnvironment(Environment environment, String fileUrl, String fileContentsStr, int position) {
        return SuggestionsHelper.patchContentInEnvironment$(this, environment, fileUrl, fileContentsStr, position);
    }

    public Future<BoxedUnit> init(InitOptions options) {
        return Core$.MODULE$.init(options);
    }

    public InitOptions init$default$1() {
        return InitOptions$.MODULE$.WebApiProfiles();
    }

    public Future<Seq<CompletionItem>> suggest(String language, String url, int position, DirectoryResolver directoryResolver, Environment environment, Platform platform, boolean snippetsSupport) {
        return platform.resolve(url, environment).map((Function1 & Serializable & scala.Serializable)content -> {
            Environment patchedEnv;
            String originalContent = content.stream().toString();
            Tuple2<String, Environment> tuple2 = MODULE$.patchContentInEnvironment(environment, url, originalContent, position);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Environment environment = patchedEnv = (Environment)tuple2._2();
            Environment patchedEnv2 = environment;
            return new Tuple2((Object)originalContent, (Object)patchedEnv2);
        }, ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String originalContent = (String)tuple2._1();
            Environment patchedEnv = (Environment)tuple2._2();
            Future<Seq<CompletionItem>> future = MODULE$.suggestWithPatchedEnvironment(language, url, originalContent, position, directoryResolver, patchedEnv, platform, snippetsSupport);
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<CompletionProvider> buildProvider(BaseUnit bu, int position, DirectoryResolver directoryResolver, Platform platform, Environment env, String url, String originalContent, boolean snippetSupport) {
        Future future;
        Option<Dialect> option = this.dialectFor(bu);
        if (option instanceof Some) {
            Some some = (Some)option;
            Dialect d = (Dialect)some.value();
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.buildCompletionProviderAST(bu, d, bu.id(), Position$.MODULE$.apply(position, originalContent), originalContent, directoryResolver, env, platform, snippetSupport), ExecutionContext.Implicits$.MODULE$.global());
        } else {
            future = this.isHeader(position, url, originalContent) ? (!url.toLowerCase().endsWith(".raml") ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HeaderCompletionProviderBuilder$.MODULE$.build(url, originalContent, Position$.MODULE$.apply(position, originalContent)), ExecutionContext.Implicits$.MODULE$.global()) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> RamlHeaderCompletionProvider$.MODULE$.build(url, originalContent, Position$.MODULE$.apply(position, originalContent)), ExecutionContext.Implicits$.MODULE$.global())) : Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(30).append("Cannot find dialect for unit: ").append(bu.id()).toString()));
        }
        return future;
    }

    public Future<CompletionProvider> buildProviderAsync(Future<BaseUnit> unitFuture, int position, DirectoryResolver directoryResolver, Platform platform, Environment env, String url, String originalContent, boolean snippetSupport) {
        return unitFuture.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.buildProvider((BaseUnit)x$1, position, directoryResolver, platform, env, url, originalContent, snippetSupport), ExecutionContext.Implicits$.MODULE$.global());
    }

    private boolean isHeader(int position, String url, String originalContent) {
        return !new StringOps(Predef$.MODULE$.augmentString(originalContent.substring(0, position).replaceAll("^\\{?\\s+", ""))).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'));
    }

    private Option<Dialect> dialectFor(BaseUnit bu) {
        BaseUnit baseUnit = bu;
        Object object = baseUnit instanceof DialectInstanceUnit ? WebApiDialectsRegistry$.MODULE$.dialectFor(bu) : (baseUnit.sourceVendor().contains((Object)Oas20$.MODULE$) ? new Some((Object)package$Oas20DialectWrapper$.MODULE$.dialect()) : (baseUnit.sourceVendor().contains((Object)Raml10$.MODULE$) ? new Some((Object)Raml10TypesDialect$.MODULE$.dialect()) : (baseUnit.sourceVendor().contains((Object)Raml08$.MODULE$) ? new Some((Object)Raml08TypesDialect$.MODULE$.dialect()) : None$.MODULE$)));
        return object;
    }

    private Future<Seq<CompletionItem>> suggestWithPatchedEnvironment(String language, String url, String originalContent, int position, DirectoryResolver directoryResolver, Environment environment, Platform platform, boolean snippetsSupport) {
        return this.buildProviderAsync(this.amfParse(url, environment, platform), position, directoryResolver, platform, environment, url, originalContent, snippetsSupport).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.suggest(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private CompletionProviderAST buildCompletionProviderAST(BaseUnit bu, Dialect dialect, String url, Position pos, String originalContent, DirectoryResolver directoryResolver, Environment env, Platform platform, boolean snippetSupport) {
        Position amfPosition = pos.moveLine(1);
        return CompletionProviderAST$.MODULE$.apply(AmlCompletionRequestBuilder$.MODULE$.build(bu, amfPosition, dialect, new CompletionEnvironment(directoryResolver, platform, env), originalContent, snippetSupport));
    }

    private Suggestions$() {
        MODULE$ = this;
        SuggestionsHelper.$init$(this);
    }
}

