package org.mulesoft.als.suggestions

import org.mulesoft.als.common.dtoTypes.PositionRange
import org.mulesoft.lsp.edit.TextEdit
import org.mulesoft.lsp.feature.completion.InsertTextFormat

case class RawSuggestion(newText: String,
                         displayText: String,
                         description: String,
                         textEdits: Seq[TextEdit],
                         category: String = "unknown",
                         range: Option[PositionRange] = None,
                         options: SuggestionStructure = SuggestionStructure(),
                         children: Seq[RawSuggestion] = Nil) {

  implicit def bool2InsertTextFormat(v: Boolean): InsertTextFormat.Value =
    if (v) InsertTextFormat.Snippet
    else InsertTextFormat.PlainText
}

object RawSuggestion {
  def arrayProp(text: String, category: String): RawSuggestion =
    RawSuggestion(text, text, text, Nil, category, options = SuggestionStructure(rangeKind = ArrayRange, isKey = true))

  def plain(text: String, description: String): RawSuggestion =
    RawSuggestion(text, text, description, Nil, options = SuggestionStructure(rangeKind = PlainText))

  def plain(text: String, range: PositionRange): RawSuggestion =
    RawSuggestion(text, text, text, Nil, range = Some(range), options = SuggestionStructure(rangeKind = PlainText))

  def forBool(value: String, category: String = "unknown"): RawSuggestion = {
    apply(value, value, value, Nil, category = category, options = SuggestionStructure(rangeKind = BoolScalarRange))
  }

  def forBoolKey(value: String, category: String = "unknown"): RawSuggestion = {
    apply(value,
          value,
          value,
          Nil,
          category = category,
          options = SuggestionStructure(rangeKind = BoolScalarRange, isKey = true))
  }

  def forKey(value: String): RawSuggestion = {
    apply(value, isAKey = true, "unknown")
  }

  def forKey(value: String, category: String): RawSuggestion = {
    apply(value, isAKey = true, category = category)
  }

  def apply(value: String, isAKey: Boolean): RawSuggestion = {
    apply(value, isAKey, "unknown")
  }

  def apply(value: String, isAKey: Boolean, category: String): RawSuggestion = {
    new RawSuggestion(value, value, value, Seq(), category, options = SuggestionStructure(isKey = isAKey))
  }

  def forObject(value: String, category: String): RawSuggestion = {
    new RawSuggestion(value,
                      value,
                      value,
                      Seq(),
                      category,
                      options = SuggestionStructure(isKey = true, rangeKind = ObjectRange))
  }

  def keyOfArray(text: String, category: String): RawSuggestion = {
    new RawSuggestion(text, text, text, Nil, category, None, SuggestionStructure(ArrayRange, isKey = true))
  }

  def valueInArray(text: String, description: String, category: String, isKey: Boolean): RawSuggestion = {
    new RawSuggestion(text, text, text, Nil, category, None, SuggestionStructure(ArrayRange, isKey = isKey))
  }
}
