package org.mulesoft.als.suggestions.plugins.aml.webapi.oas

import amf.core.annotations.AutoGeneratedName
import amf.core.model.domain.{AmfObject, Shape}
import amf.plugins.domain.shapes.models.ScalarShape
import amf.plugins.domain.webapi.metamodel.{EndPointModel, OperationModel, ParameterModel, RequestModel}
import amf.plugins.domain.webapi.models._
import org.mulesoft.als.common.YPartBranch
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.als.suggestions.interfaces.AMLCompletionPlugin
import org.mulesoft.als.suggestions.plugins.aml._
import org.mulesoft.als.suggestions.plugins.aml.categories.CategoryRegistry
import org.mulesoft.amfmanager.dialect.webapi.oas.Oas20DialectWrapper

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object ParameterStructure extends AMLCompletionPlugin {
  override def id: String = "ParameterStructure"

  override def resolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = {
    Future {
      if (isWrittingFacet(request.yPartBranch)) {
        request.amfObject match {
          case p: Parameter if p.binding.option().contains("header") && comesFromHeader(request.yPartBranch) =>
            if (p.name.value() != request.yPartBranch.stringValue)
              OasTypeFacetsCompletionPlugin.resolveShape(Option(p.schema).getOrElse(ScalarShape()), Nil)
            else Nil
          case p: Parameter if request.fieldEntry.isEmpty => parameterSuggestions(request, p)
          case ep: EndPoint if request.fieldEntry.exists(_.field == EndPointModel.Parameters) =>
            suggestions(request, withName = false, None)
          case o: Request if request.fieldEntry.exists(_.field == RequestModel.QueryParameters) =>
            suggestions(request, withName = false, None)
          case _ => Nil
        }
      } else Nil
    }
  }

  private def parameterSuggestions(request: AmlCompletionRequest, p: Parameter) = {
    suggestions(request, isNamePresent(p), Option(p.schema))
  }

  private def suggestions(request: AmlCompletionRequest, withName: Boolean, schema: Option[Shape]) = {
    val common = OasTypeFacetsCompletionPlugin.resolveShape(schema.getOrElse(ScalarShape()), Nil)

    val particular =
      if (withName) Seq(onlyBinding) else paramsFields
    particular ++ common
  }

  private def isWrittingFacet(yPart: YPartBranch) = {
    yPart.isKey || (yPart.isJson && yPart.isInArray && yPart.stringValue == "x")
  }

  private def isNamePresent(p: Parameter) =
    p.name.option().isDefined && !p.name.annotations().contains(classOf[AutoGeneratedName])
  private def comesFromHeader(yPart: YPartBranch) = yPart.keys.contains("headers")

  private def onlyBinding =
    Oas20DialectWrapper.paramBiding.toRaw(CategoryRegistry(ParameterModel.`type`.head.iri(), "in"))

  private def paramsFields: Seq[RawSuggestion] =
    Oas20DialectWrapper.basicParamsProps
      .map(p => p.toRaw(CategoryRegistry(ParameterModel.`type`.head.iri(), p.name().value())))
}
