package org.mulesoft.als.suggestions.plugins.aml.webapi.oas.oas20

import amf.core.annotations.AutoGeneratedName
import amf.core.model.domain.Shape
import amf.dialects.oas.nodes.Oas20ParamObject
import amf.plugins.domain.shapes.models.ScalarShape
import amf.plugins.domain.webapi.metamodel.{EndPointModel, ParameterModel, RequestModel}
import amf.plugins.domain.webapi.models.{EndPoint, Parameter, Request}
import org.mulesoft.als.common.YPartBranch
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.als.suggestions.interfaces.AMLCompletionPlugin
import org.mulesoft.als.suggestions.plugins.aml._
import org.mulesoft.als.suggestions.plugins.aml.categories.CategoryRegistry
import org.mulesoft.als.suggestions.plugins.aml.webapi.oas.OasTypeFacetsCompletionPlugin

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object Oas20ParameterStructure extends AMLCompletionPlugin {
  override def id: String = "ParameterStructure"

  override def resolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = {
    Future {
      if (isWrittingFacet(request.yPartBranch)) {
        request.amfObject match {
          case p: Parameter if p.binding.option().contains("header") && comesFromHeader(request.yPartBranch) =>
            if (p.name.value() != request.yPartBranch.stringValue)
              Oas20TypeFacetsCompletionPlugin.resolveShape(Option(p.schema).getOrElse(ScalarShape()), Nil)
            else Nil
          case p: Parameter if request.fieldEntry.isEmpty => parameterSuggestions(request, p)
          case ep: EndPoint if request.fieldEntry.exists(_.field == EndPointModel.Parameters) =>
            suggestions(request, withName = false, None)
          case o: Request if request.fieldEntry.exists(_.field == RequestModel.QueryParameters) =>
            suggestions(request, withName = false, None)
          case _ => Nil
        }
      } else Nil
    }
  }

  private def parameterSuggestions(request: AmlCompletionRequest, p: Parameter) = {
    suggestions(request, isNamePresent(p), Option(p.schema))
  }

  private def suggestions(request: AmlCompletionRequest, withName: Boolean, schema: Option[Shape]) = {
    val common = Oas20TypeFacetsCompletionPlugin.resolveShape(schema.getOrElse(ScalarShape()), Nil)

    val particular =
      if (withName) Seq(onlyBinding) else Seq(onlyBinding, nameSuggestion)
    particular ++ common
  }

  private def isWrittingFacet(yPart: YPartBranch) = {
    yPart.isKey || (yPart.isJson && yPart.isInArray && yPart.stringValue == "x")
  }

  private def isNamePresent(p: Parameter) =
    p.name.option().isDefined && !p.name.annotations().contains(classOf[AutoGeneratedName])
  private def comesFromHeader(yPart: YPartBranch) = yPart.keys.contains("headers")

  private def onlyBinding =
    Oas20ParamObject.paramBinding.toRaw(CategoryRegistry(ParameterModel.`type`.head.iri(), "in"))

  private def nameSuggestion: RawSuggestion =
    Oas20ParamObject.paramName.toRaw(
      CategoryRegistry(ParameterModel.`type`.head.iri(), Oas20ParamObject.paramName.name().value()))
}
