package org.mulesoft.als.suggestions.plugins.aml.webapi.oas.oas30

import amf.core.client.scala.model.domain.{Linkable, Shape}
import amf.core.internal.annotations.SourceNode
import amf.core.internal.parser.YNodeLikeOps
import amf.shapes.client.scala.model.domain.{IriTemplateMapping, NodeShape}
import amf.shapes.internal.domain.metamodel.{IriTemplateMappingModel, NodeShapeModel}
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.als.suggestions.plugins.aml.webapi.ExceptionPlugin
import org.mulesoft.amfintegration.AmfImplicits.ShapeImp
import org.yaml.model.YMap

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object DiscriminatorMappingValue extends ExceptionPlugin {
  override def id: String = "DiscriminatorMappingValue"

  override def resolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = Future {
    request.amfObject match {
      case obj: NodeShape
          if request.fieldEntry
            .exists(_.field == NodeShapeModel.DiscriminatorMapping) && request.astPartBranch.isValue =>
        suggest(obj)
      case _: IriTemplateMapping if request.fieldEntry.exists(_.field == IriTemplateMappingModel.LinkExpression) =>
        request.branchStack.collectFirst({ case n: NodeShape => suggest(n) }).getOrElse(Nil)
      case _ => Nil
    }
  }

  private def suggest(n: NodeShape): Seq[RawSuggestion] =
    parents(n).collect({ case l: Linkable if l.isLink => extractRef(l) }).map(RawSuggestion(_, isAKey = false))

  private def extractRef(l: Linkable) = {
    l.annotations.find(classOf[SourceNode]).flatMap(_.node.toOption[YMap]).flatMap(_.entries.headOption) match {
      case Some(e) => e.value.asScalar.map(_.text).getOrElse(l.linkLabel.value())
      case _       => l.linkLabel.value()
    }
  }

  private def parents(n: NodeShape): Seq[Shape] = n.mergedAndOrXone

  // ?????
  override def applies(request: AmlCompletionRequest): Boolean = {
    request.amfObject match {
      case _: NodeShape =>
        request.fieldEntry.exists(_.field == NodeShapeModel.DiscriminatorMapping) && request.astPartBranch.isValue
      case _: IriTemplateMapping => true
      case _                     => false
    }
  }
}
