package org.mulesoft.als.suggestions.plugins.jsonschema

import amf.core.client.scala.model.domain.ScalarNode
import amf.shapes.client.scala.model.domain.{ArrayShape, ScalarShape}
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global

import scala.concurrent.Future

object JsonSchemaEnumsCompletionPlugin extends JsonSchemaBaseCompletionPlugin {

  override def id: String = "JsonSchemaEnumsCompletionPlugin"

  override def innerResolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = Future {
    request.guessedShapes
      .collect {
        case arrayShape: ArrayShape if arrayShape.items.isInstanceOf[ScalarShape] => arrayShape.items.asInstanceOf[ScalarShape]
        case scalarShape: ScalarShape => scalarShape
      }
      .flatMap(scalarShape => scalarNodeSuggestions(scalarShape))
  }

  private def scalarNodeSuggestions(item: ScalarShape): Seq[RawSuggestion] =
    item.values
        .collect { case scalar: ScalarNode => RawSuggestion.plain(scalar.value.value(), scalar.value.value()) }
}
