package org.mulesoft.als.suggestions.plugins.aml

import amf.core.client.scala.model.domain.{AmfObject, Shape}
import amf.core.client.scala.vocabulary.Namespace.XsdTypes
import amf.core.internal.metamodel.Type
import amf.shapes.client.scala.model.domain.ScalarShape
import org.mulesoft.als.suggestions.RawSuggestion

trait BooleanSuggestions {
  val booleanSuggestions: Seq[RawSuggestion] = Seq("true", "false").map(RawSuggestion.forBool(_))
}

trait AMLBooleanSuggestions extends BooleanSuggestions {
  def isBoolean(h: AmfObject, text: String): Boolean =
    h.fields.fields().find(_.field.value.name == text).exists(_.field.`type` == Type.Bool)
}