package org.mulesoft.als.suggestions.jsonschema.agentnetwork

import amf.core.internal.remote.Spec
import org.mulesoft.als.suggestions.CompletionPluginRegistry
import org.mulesoft.als.suggestions.interfaces.AMLCompletionPlugin
import org.mulesoft.als.suggestions.jsonschema.JsonSchemaBaseCompletionPlugins
import org.mulesoft.als.suggestions.plugins.jsonschema.agentnetwork.{LocalBaseProviderReferencesCompletionPlugin, LocalConnectionKindProviderReferencesCompletionPlugin}

object AgentNetworkCompletionPluginRegistry extends CompletionPluginRegistry {

  override def plugins: Seq[AMLCompletionPlugin] = JsonSchemaBaseCompletionPlugins.all ++ Seq(
    LocalBaseProviderReferencesCompletionPlugin,
    LocalConnectionKindProviderReferencesCompletionPlugin
  )

  override def id: String = Spec.AGENT_NETWORK.id
}
