package org.mulesoft.als.suggestions.plugins.jsonschema

import amf.shapes.client.scala.model.domain.ScalarShape
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.aml.AmlCompletionRequest
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global

import scala.concurrent.Future

object JsonSchemaBooleanCompletionPlugin extends JsonSchemaBaseCompletionPlugin with JsonSchemaBooleanSuggestions {

  override def id: String = "JsonSchemaBooleanCompletionPlugin"

  override def innerResolve(request: AmlCompletionRequest): Future[Seq[RawSuggestion]] = Future {
    request.guessedShapes
      .collect {
        case scalarShape: ScalarShape => scalarShape
      }
      .filter(isBoolean)
      .flatMap(_ => booleanSuggestions)
  }
}
