package org.mulesoft.als.suggestions.antlr.grpc

import amf.core.client.scala.model.document.BaseUnit
import org.mulesoft.als.common.DirectoryResolver
import org.mulesoft.als.common.dtoTypes.{Position => DtoPosition}
import org.mulesoft.als.common.finder.StrictObjectStack
import org.mulesoft.als.suggestions.interfaces.CompletionProvider
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.als.suggestions.plugins.antlr.grpc.{GRPCPathNavigatorCompletionPlugin, GRPCSnippetsCompletionPlugin}
import org.mulesoft.als.suggestions.plugins.antlr.{CompletionPlugin, CompletionPluginParams}
import org.mulesoft.amfintegration.amfconfiguration.ALSConfigurationState
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global
import org.mulesoft.lsp.feature.completion.CompletionItem

import scala.collection.mutable
import scala.concurrent.Future

class GRPCCompletionProvider(
                              baseUnit: BaseUnit,
                              position: DtoPosition,
                              directoryResolver: DirectoryResolver,
                              alsConfiguration: ALSConfigurationState) extends CompletionProvider {
  override def suggest(): Future[Seq[CompletionItem]] = {
    val stack: StrictObjectStack = StrictObjectStack(baseUnit, position.toAmfPosition)

    val params: CompletionPluginParams = CompletionPluginParams(
      stack,
      new DeclarationProvider(baseUnit),
      directoryResolver,
      alsConfiguration)
    val completionPlugins = mutable.Queue[CompletionPlugin]()
    completionPlugins.enqueue(GRPCSnippetsCompletionPlugin, GRPCPathNavigatorCompletionPlugin)

    Future.sequence(completionPlugins.map(_.suggest(params))).map(_.flatten)
  }
}