package org.mulesoft.als.suggestions.jsonschema

import org.mulesoft.als.suggestions.{CompletionPluginsRegistryAML, CustomBaseCompletionPlugins}
import org.mulesoft.als.suggestions.interfaces.AMLCompletionPlugin
import org.mulesoft.als.suggestions.plugins.jsonschema.{JsonSchemaBooleanCompletionPlugin, JsonSchemaEnumsCompletionPlugin, JsonSchemaStructureCompletionPlugin}

object JsonSchemaBaseCompletionPlugins {
  lazy val all: Seq[AMLCompletionPlugin] = CustomBaseCompletionPlugins.custom ++ Seq(
    JsonSchemaStructureCompletionPlugin,
    JsonSchemaBooleanCompletionPlugin,
    JsonSchemaEnumsCompletionPlugin
  )

  val base: CompletionPluginsRegistryAML = {
    val b = new CompletionPluginsRegistryAML
    all.foreach(b.registerPlugin)
    b
  }
}
