package org.mulesoft.als.suggestions.plugins.antlr

import org.mulesoft.als.common.DirectoryResolver
import org.mulesoft.als.common.finder.StrictObjectStack
import org.mulesoft.als.suggestions.antlr.grpc.AstNodeKnowledge
import org.mulesoft.als.suggestions.plugins.antlr.grpc.declarations.DeclarationProvider
import org.mulesoft.amfintegration.AmfImplicits.AmfAnnotationsImp
import org.mulesoft.amfintegration.amfconfiguration.ALSConfigurationState
import org.mulesoft.antlrast.ast.ASTNode
import org.mulesoft.lsp.feature.completion.CompletionItem

import scala.concurrent.Future


trait CompletionPlugin {
  def suggest(stack: CompletionPluginParams): Future[Seq[CompletionItem]]
}
case class CompletionPluginParams(
  stack: StrictObjectStack,
  declarations: DeclarationProvider,
  directoryResolver: DirectoryResolver,
  alsConfiguration: ALSConfigurationState) {

  lazy val mostSpecificAstNode: Option[ASTNode] = stack.element.flatMap(_.annotations.astNode()).flatMap(ast => AstNodeKnowledge.mostSpecificAstNode(ast , stack.position))
}