package org.mulesoft.als.suggestions.plugins.antlr.grpc

import amf.grpc.internal.spec.parser.syntax.TokenTypes.{IMPORT_STATEMENT, PROTO, STRING_LITERAL}
import org.mulesoft.als.suggestions.RawSuggestion
import org.mulesoft.als.suggestions.antlr.grpc.AstNodeKnowledge.isInside
import org.mulesoft.als.suggestions.plugins.antlr.{CompletionPlugin, CompletionPluginParams}
import org.mulesoft.als.suggestions.plugins.commons.pathnavigation.PathSuggestor
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global
import org.mulesoft.antlrast.ast.{ASTNode, Terminal}
import org.mulesoft.common.client.lexical.Position
import org.mulesoft.lsp.feature.completion.{CompletionItem, CompletionItemKind, InsertTextFormat}

import scala.concurrent.Future

object GRPCPathNavigatorCompletionPlugin extends CompletionPlugin {

  override def suggest(params: CompletionPluginParams): Future[Seq[CompletionItem]] =
    if (!isInside(params.stack, Seq(Left(PROTO), Left(IMPORT_STATEMENT), Left(STRING_LITERAL))))
      Future.successful(Seq.empty)
    else
      PathSuggestor.resolveInclusion(
        params.stack.root.location().getOrElse(""),
        params.directoryResolver,
        prefix(params.mostSpecificAstNode, params.stack.position),
        params.stack.root.location(),
        params.alsConfiguration,
        None
      ).map(_.map(toCompletionItem))

  private def prefix(astNode: Option[ASTNode], position: Position): String = astNode match {
    case Some(stringLiteral: Terminal) =>
      stringLiteral.value.substring(
        1, // skip opening quotation
        Math.max(1,position.column - stringLiteral.location.columnFrom) // relative position from terminal and cursor
      ) // if there is a chance of multiline terminal, we need to take into consideration lines
    case _ => ""
  }

  private def toCompletionItem(rawSuggestion: RawSuggestion): CompletionItem = CompletionItem(
    label = rawSuggestion.displayText,
    kind = Some(CompletionItemKind.File),
    detail = Some(rawSuggestion.description),
    sortText = Some(rawSuggestion.newText),
    insertText = Some(rawSuggestion.newText),
    insertTextFormat = Some(InsertTextFormat.PlainText)
  )
}
