package org.mulesoft.als.suggestions.plugins.antlr.grpc

import org.mulesoft.als.suggestions.plugins.antlr.grpc.snippets.{EnumBodySnippets, MessageBodySnippets, OneofBodySnippets, RootSnippets}
import org.mulesoft.als.suggestions.plugins.antlr.snippets.SnippetPlugin
import org.mulesoft.als.suggestions.plugins.antlr.{CompletionPlugin, CompletionPluginParams}
import org.mulesoft.amfintegration.amfconfiguration.executioncontext.Implicits.global
import org.mulesoft.lsp.feature.completion.CompletionItem

import scala.concurrent.Future

object GRPCSnippetsCompletionPlugin extends CompletionPlugin {

  override def suggest(params: CompletionPluginParams): Future[Seq[CompletionItem]] =
    Future(
      registry.flatMap(_.getAll(params)).map(_.toCompletionItem)
    )

  private val registry: Seq[SnippetPlugin] = Seq(
    RootSnippets,
    MessageBodySnippets,
    EnumBodySnippets,
    OneofBodySnippets
  )
}